function p = identifica_patron(patrones,QRS,umbral)
%   p = IdentificaPatron(patrones,QRS,umbral)
%
%   Esta funcin identifica el patrn al que corresponde un complejo QRS
%   dado. En el caso de que el QRS no corresponda a ningn tipo de patrn 
%   perteneciente al conjunto de patrones, la funcin devuelve p=0
%   
%   Parmetros de entrada
%       patrones [matriz]:   conjunto de patrones de QRS organizados en filas
%       QRS [vector]:        QRS actual 
%
%   Parmetro de entrada opcional:
%       umbral [real]:       umbral de correlacin para la comparacin de patrones (entre 0 y 1)
%   
%   Parmetro de salida
%       p [entero]:          ndice correspondiente al tipo de patrn identificado
%
%   
if nargin==2
    umbral=0.85;
end

if isempty(patrones)
    p=0;
else
    %% Clculo coeficiente de correlacin
    for i = 1:size(patrones,1)
        CC_matrix = corrcoef(QRS,patrones(i,:));
        CC(i) = CC_matrix(1,2); %Matriz de correlacin (simtrica)
    end

    %% Comparacin con el umbral
    % Obtenemos la mxima correlacin
    [CCmax,idx] = max(CC);
    % Vemos si la mxima correlacin supera el umbral
    if CCmax>umbral
        p=idx;
    else
        p=0;
    end
end


    
