function [ Pwave ] = extractPwave( ecg, QRS, fs  )
%*******************  preproST_TP *****************************%  
% Funcion que nos devuelve el intervalo SQ
% Created by: Pedro lvarez Guirado 29/03/2017
% OPEN-SOURCE SOFTWARE 
% *************************************************************%
% Pasamos de fs a tiempo y cogemos las muesras detras del pico R detectado
% dif_QRS = round(mean(diff(QRS)));
dif_QRS = round(diff(QRS));
% Partimos el intervalo en 2 (post-pre R)
int_SQ = round(dif_QRS);
samp_SQ = fs * (600*10^(-3)); % 600 ms despues de R para empezar ST
samp_QR = fs * (40*10^(-3)); % 40 ms antes de R para finalizar QR
SQ_pos = cell(length(dif_QRS),1);
SQ_i = cell(length(dif_QRS),1);
for i = 1:length(dif_QRS)
    SQ_pos{i} = samp_SQ:1:int_SQ(i)-samp_QR;
end

for j = 1:length(SQ_pos)
  SQ_i{j,1} =  QRS(j) + SQ_pos{j,1};
end

% Concatenamos en un solo vector
clear C;
C = cell2mat(SQ_i');
C_pos = C < length(ecg);
Pwave = C(C_pos)';
end