function [latidos,indices_latidos] = enventana_QRS(signal,v_ant_ms,v_pos_ms)
%latidos = enventanaQRS(ECG,v_ant,v_pos);
%
% Esta funcin enventana cada QRS del ECG y los organiza en una matriz. En
% el caso de que no haya suficiente seal para enventanar el primer y/o
% ltimo latido, los elimina. Si hay suficiente seal, los mantiene
% igualmente
%
% Entradas:
%   ECG [struct tipo ECG]: requiere ECG.senyal; ECG.fs; ECG.R
%
% Entradas opcionales
%   v_ant:  ventana anterior al R en ms
%   v_pos:  ventana posterior al R en ms
%
% Salida:
%   latidos [matriz]: QRS extrados, organizados en filas

%% Inicializamos variables
Fs = 300; %Frecuenc~ia de muestreo
[R,~,~] = qrs_detect2(signal',0.25,0.6,Fs);
indices_latidos = zeros(length(R),2);

%Pasamos las ventanas a muestras
v_ant_muestras = round(v_ant_ms/1000*Fs); 
v_pos_muestras = round(v_pos_ms/1000*Fs);
j=1;
error_filas = [];
latidos = zeros(length(R),v_pos_muestras+v_ant_muestras+1);     %El 1 es porque se cuenta tambin la posicin de la R como muestra

%% Construimos matriz de complejos
k=1;
for i = 1:length(R)
    try
        latidos(i,:) = signal(R(i)-v_ant_muestras:R(i)+v_pos_muestras);
        indices_latidos(k,1) = R(i)-v_ant_muestras;
        indices_latidos(k,2) = R(i)+v_pos_muestras;
        k=k+1;
    catch 
        error_filas(j) = i;
        j = j+1;
    end
end
% Eliminamos las filas rellanas con ceros (complejos cortados)
if not(isempty(error_filas))
      latidos(error_filas,:) = [];

end

end



