function classifyResult = challenge(recordName)

% Sample entry for the 2017 PhysioNet/CinC Challenge.
%
% INPUTS:
% recordName: string specifying the record name to process
%
% OUTPUTS:
% classifyResult: integer value where
%                     N = normal rhythm
%                     A = AF
%                     O = other rhythm
%                     ~ = noisy recording (poor signal quality)
%
% To run your entry on the entire training set in a format that is
% compatible with PhysioNet's scoring enviroment, run the script
% generateValidationSet.m
%
% The challenge function requires that you have downloaded the challenge
% data 'training_set' in a subdirectory of the current directory.
%    http://physionet.org/physiobank/database/challenge/2017/
%
% This dataset is used by the generateValidationSet.m script to create
% the annotations on your training set that will be used to verify that
% your entry works properly in the PhysioNet testing environment.
%
%
% Version 1.0
%
%
% Written by: Chengyu Liu and Qiao Li January 20 2017
%             chengyu.liu@emory.edu  qiao.li@emory.edu
%
% Last modified by: Pedro lvarez and Jos Sanchez
%
%

classifyResult = 'N'; % default output normal rhythm

%% AF determination
[tm,ecg,fs,siginfo]=rdmat(recordName);
[QRS,sign,en_thres] = qrs_detect2(ecg',0.25,0.6,fs);
AFEv = 0;
if length(QRS)<6
else
    RR=diff(QRS')/fs;
    AFEv = comput_AFEv(RR);
end
        WEt = wentropy(ecg,'shannon');
        rel_maxmint = max(ecg)/min(ecg);
        powbp = bandpower(ecg,fs,[0 fs/2-1]);
        powbp_noise = bandpower(ecg,fs,[50 fs/2-1]);
        pow_normt = powbp_noise/powbp;
        [ ST, TP ] = preproST_TP( ecg, QRS, fs );
        WE_STt = wentropy(ST,'shannon');
        WE_TPt = wentropy(TP,'shannon');
    try 
        AFEstit=AFEv;
        % RR intervals
        RR_meant = mean(RR);
        RR_stdt = std(RR);
        % ST and TP signal
        % Patrones XAVI
        [latidos,~] = enventana_QRS(ecg,60,350);
        [~,patrones] = ClasificaComplejos(latidos);
        [num_patronest,sum_mint,neg_post ] = buscanegativos( patrones );
        

    catch 
        num_patronest = 1;
        sum_mint = 0;
        neg_post = 0;
        AFEstit=0;
        % RR intervals
        RR_meant = 0;
        RR_stdt = 0;
        
    end    
    
%% Create Table variable
DataTest = table(WEt,AFEstit,RR_meant,RR_stdt,pow_normt,num_patronest,sum_mint,neg_post,rel_maxmint,WE_STt,WE_TPt);
load('clasificadores_22052017_76_ComplexTreemat.mat')
%% Use trainedClassifier
classifyResult = trainedModel.predictFcn(DataTest);
end

