function [tipo_QRS,patrones,num_complejos] = clasificaComplejos(QRS)
%[tipo_QRS,patrones,num_complejos] = ClasificaComplejos(QRS)
%
%Esta funcin clasifica una serie de complejos QRS en distintos patrones
%segn su morfologa. Para ello emplea el siguiente algoritmo: para cada
%QRS de la matriz de entrada, identifica el patrn correspondiente entre
%los patrones detectados hasta el momento. Si no se corresponde con ningn
%patrn conocido, entonces aade un nuevo patrn y lo asigna al QRS actual.
%En caso contrario, si efectivamente se encuentra entre los patrones
%existentes, actualiza el patrn correspondiente con el QRS actual. 
%
%   Entrada:
%       QRS [matriz]: secuencia de complejos QRS organizados en filas
%
%   Salida:
%       tipo_QRS [vector]:       clasificacin de cada complejo
%       patrones [matriz]:       conjunto de patrones detectados (en filas)
%       num_complejos [vector]:  nmero de complejos identificados de cada patrn
%
%   Llamadas a otras funciones:
%       IdentificaPatron

%% Inicializamos variables
patrones=[];
%umbral = 0.9;
num_complejos = [];
tipo_QRS = [];

%% Construimos matriz de patrones
for i = 1:size(QRS,1)
    p = identifica_patron(patrones,QRS(i,:));
    if p > 0
        tipo_QRS(i) = p;
        num_complejos(p) = num_complejos(p)+1;
        patrones(p,:) = (patrones(p,:)*(num_complejos(p)-1)+QRS(i,:))/num_complejos(p);
    else
        patrones = [patrones;QRS(i,:)];
        [m,~] = size(patrones);
        tipo_QRS(i) = m;
        num_complejos(m) = 1;
    end
end
num_complejos = num_complejos';     % Para que funcione el test
end
        
        
        
    
    
    


