function QRS = maximize_qrs(ecg,QRS,QRS_radius)
	% choose the position of maximum QRS in QRS_radius
	n = size(QRS,2);	
	for i=1:n
		QRS_curr = QRS(i);
		ecg_max = ecg(QRS_curr);
		
		start_p = max([QRS_curr - QRS_radius, 1]);
		end_p = min([QRS_curr + QRS_radius, size(ecg,1)]);
		for j=start_p:end_p
			if ecg_max < ecg(j)
				ecg_max = ecg(j);
				QRS_curr = j;
			end
		end
		QRS(i) = QRS_curr;
	end		
end