function [RR_segments, RR_lengths, ST_lengths, PQ_lengths, R_prevs, T_vals, P_vals, R_currs] = extract_all_info(...
	ecg, ...
	QRS, QRS_height_threshold, ...
	RR_new_length, ...
	SQ_amplifying, SQ_smoothing, ...
	TP_distance_threshold)
	
	RR_segments = [];
	RR_lengths = [];
	ST_lengths = [];
	PQ_lengths = [];
    R_prevs = [];
	T_vals = [];
	P_vals = [];
    R_currs = [];
	
	n = size(QRS,2);
	if n == 0
		return
	end	
	
	QRS_prev = QRS(1);
	%QRS_median = median(QRS);	
	
	% extract RR segments and RR lengths
	for i=2:n
		QRS_curr = QRS(i);
		
		%if abs(ecg(QRS_curr)-ecg(QRS_prev)) < (QRS_height_threshold * ecg(QRS_prev))
			RR_length = QRS_curr - QRS_prev + 1;
			RR_lengths = [RR_lengths RR_length];
			
            R_prevs = [R_prevs ecg(QRS_prev)];
            R_currs = [R_currs ecg(QRS_curr)];
            
			RR_segment = ecg(QRS_prev:QRS_curr);
			RR_resampled = resample(RR_segment, RR_new_length, RR_length);
			RR_segments = [RR_segments RR_resampled];
			
            %radius = RR_length / 32;
            
            RR_detrend = detrend(RR_segment);
            m = size(RR_detrend,1);
            RR_smoothed = RR_detrend;
            smoothing_window = SQ_smoothing*2+1;
            s = sum(RR_detrend(1:smoothing_window));            
            for j=SQ_smoothing+1:m-SQ_smoothing-1
                RR_smoothed(j)=s/smoothing_window;
                s = s - RR_detrend(j-SQ_smoothing) + RR_detrend(j+SQ_smoothing+1);
            end
            
            RR_smoothed(m-SQ_smoothing)=s/smoothing_window;
            
			S_prev = 1;
            S_val = RR_smoothed(S_prev);
            for j=1:int64(m/8)
                if S_val > RR_smoothed(j)
                    S_prev = j;
                    S_val = RR_smoothed(S_prev);
                end
            end
            
            T = S_prev+1;
            T_val = RR_smoothed(T);
            for j=(T+1):int64(m/2)
                if T_val < RR_smoothed(j)
                    T = j;
                    T_val = RR_smoothed(T);
                end
            end
            T_val = RR_segment(T);
            
            Q_curr = m;
            Q_val = RR_smoothed(Q_curr);
            for j=int64(m*7/8):(m-1)
                if Q_val > RR_smoothed(j)
                    Q_curr = j;
                    Q_val = RR_smoothed(Q_curr);
                end
            end
            
            P = Q_curr-1;
            P_val = RR_detrend(P);
            for j=int64(2*m/3):(Q_curr-1)
                if P_val < RR_detrend(j)
                    P = j;
                    P_val = RR_detrend(P);
                end
            end
            P_val = RR_segment(P);
			 
            %{
            clf
            hold on
            plot(RR_segment)
            plot([S_prev T P Q_curr], [RR_segment(S_prev) RR_segment(T) RR_segment(P) RR_segment(Q_curr)], 'marker','X');
            hold off
			%}            
            
			ST_lengths = [ST_lengths T];
			PQ_lengths = [PQ_lengths (m-P+1)];
			T_vals = [T_vals T_val];
			P_vals = [P_vals P_val];
            
            
		%end            
		
		QRS_prev = QRS_curr;
	end
end