function classifyResult = challenge(recordName)
%
% Sample entry for the 2017 PhysioNet/CinC Challenge.
%
% INPUTS:
% recordName: string specifying the record name to process
%
% OUTPUTS:
% classifyResult: integer value where
%                     N = normal rhythm
%                     A = AF
%                     O = other rhythm
%                     ~ = noisy recording (poor signal quality)
%
% To run your entry on the entire training set in a format that is
% compatible with PhysioNet's scoring enviroment, run the script
% generateValidationSet.m
%
% The challenge function requires that you have downloaded the challenge
% data 'training_set' in a subdirectory of the current directory.
%    http://physionet.org/physiobank/database/challenge/2017/
%
% This dataset is used by the generateValidationSet.m script to create
% the annotations on your training set that will be used to verify that
% your entry works properly in the PhysioNet testing environment.
%
%
% Version 1.0
%
%
% Written by: Na Liu April 7 2017
%             nkuliuina@163.com
%
%

%% You can add the determination rules for other rhythm and noisy recordings here
    [d,C,stat_RR,pow,AFEv,OriginCount,IrrEv,PACEv,p_ratio,HOS,P,P_absence,f_presence,Noise,wevelet_power] = featureExtract(recordName);
    testData = [d,C,stat_RR,pow,AFEv,OriginCount,IrrEv,PACEv,p_ratio,HOS,P,P_absence,f_presence,Noise]; 
    testData(isnan(testData))=0;
%     testData = [d,C,stat_RR(1:2),pow,AFEv,p_ratio,HOS,P,P_absence,f_presence,Noise]; 
    load trainedModel;
    yfit = trainedModel.predictFcn(testData);
    switch yfit
        case 1
            classifyResult='N';
        case 2
            classifyResult='A';
        case 3
            classifyResult='O';
        case 4
            classifyResult='~';
    end
end
