% This script will verify that your code is working as you intended, by
% running it on a small subset (300 records) of the training data, then
% comparing the answers.txt file that you submit with your entry with
% answers produced by your code running in our test environment using
% the same records.
%
% In order to run this script, you should have downloaded and extracted
% the validation set into the directory containing this file.
%
%
% Written by: Chengyu Liu and Qiao Li January 20 2017
%             chengyu.liu@emory.edu  qiao.li@emory.edu
%
% Last modified by:
%
%

clear all;
close all;
clc

data_dir = [pwd filesep 'training2017' filesep];

%% Add this directory to the MATLAB path.
addpath(pwd)

%% Load the list of records in the validation set.
fid = fopen([data_dir 'RECORDS'],'r');
if(fid ~= -1)
    RECLIST = textscan(fid,'%s');
else
    error(['Could not open ' data_dir 'RECORDS for scoring. Exiting...'])
end
fclose(fid);
RECORDS = RECLIST{1};

total_time = 0;

fprintf('Processing and creation of files containing extract features from the  with the sample detector.\n');
fprintf('Here the extract features are hrv (heart rate), irrEv (irregularity evidence) and pacEv (PAC Evidence, Premature atrial contractions).\n');
fprintf('The extract features are saved in the validation_data directory.\n');
fprintf('They are going to be used in the python script containing the model.\n');

for i = 1:length(RECORDS)
    fname = RECORDS{i};
    tic;
    challenge([data_dir fname]);
    total_time = total_time+toc;
end

averageTime = total_time/length(RECORDS);
fprintf(['Generation of validation set completed.\n  Total time = ' ...
    num2str(total_time) '\n  Average time = ' num2str(averageTime) '\n'])