function [tm,ecg,fs,siginfo,QRS,sign,en_thres,RR,IrrEv,PACEv,r_t,r_amp,hrv] = challenge(recordName)
%
% Sample entry for the 2017 PhysioNet/CinC Challenge.
%
% INPUTS:
% recordName: string specifying the record name to process
%
% OUTPUTS:
% classifyResult: integer value where
%                     N = normal rhythm
%                     A = AF
%                     O = other rhythm
%                     ~ = noisy recording (poor signal quality)
%
% To run your entry on the entire training set in a format that is
% compatible with PhysioNet's scoring enviroment, run the script
% generateValidationSet.m
%
% The challenge function requires that you have downloaded the challenge
% data 'training_set' in a subdirectory of the current directory.
%    http://physionet.org/physiobank/database/challenge/2017/
%
% This dataset is used by the generateValidationSet.m script to create
% the annotations on your training set that will be used to verify that
% your entry works properly in the PhysioNet testing environment.
%
%
% Version 1.0
%
%
% Written by: Chengyu Liu and Qiao Li January 20 2017
%             chengyu.liu@emory.edu  qiao.li@emory.edu
%
% Last modified by:
%
%

classifyResult = 'N'; % default output normal rhythm
RR = [0,0];
PACEv = 0;
IrrEv = 0;
OriginCount = 0;
dRR = [0,0];
dRRnew = [ 0. 0. ; 0. 0. ];
r_amp = [0,0];
r_t = [0,0];


%% AF determination
[tm,ecg,fs,siginfo]=rdmat(recordName);
[QRS,sign,en_thres,r_t,r_amp,hrv,bpfecg] = qrs_detect2(ecg',0.25,0.6,fs);
if length(QRS)<6
else
    RR=diff(QRS')/fs;
    [dRR,IrrEv,PACEv,dRRnew,OriginCount] = comput_AFEv(RR);
    %if AFEv>1
        %classifyResult = 'A';
    %end
end

#namefile = strsplit(recordName, "/");
#namefile = namefile{1,2};
#name = strcat('training_data/',namefile,'_data.mat');

namefile = strsplit(recordName, "/");
namefile = namefile{1,length(namefile)};
name = strcat([pwd filesep],namefile,'_data.mat');

if (length(r_t) < 2)
    r_t = [ r_t ; r_t ];
endif

if (length(r_amp) < 2)
    r_amp = [ r_amp ; r_amp ];
endif

if (length(ecg) < 2)
    ecg = [ ecg ; ecg ];
endif

if (length(tm) < 2)
    tm = [ tm ; tm ];
endif

if (length(hrv) < 2)
    hrv = [ hrv ; hrv ];
endif

if (length(dRR) < 2)
    dRR = [ dRR ; dRR ];
endif

if (length(QRS) < 2)
    QRS = [ QRS ; QRS ];
endif

data.r_t = r_t;
data.r_amp = r_amp;
data.qrs = QRS;
data.ecg = ecg;
data.tm = tm;
data.hrv = hrv;

save('-6',name,'-struct','data');


%% You can add the determination rules for other rhythm and noisy recordings here

