% -------------------
%
% Esamina una sequenza di puntatori a QRS, selezionando battiti nomali o AF
% corregge i puntatori ritenuti anomali (elimina e/o introduce QRS)
% e produce in uscita puntatori a QRS tipo N o AF
%
% Elimina falsi positivi, falsi negativi, pvc e riconoscimenti ritardati
% (FP e FN del QRS detector, battiti interpolati, PVC).
%
% Modifica per mantenere i qrs relativi a fibrillazione atriale (AF)
%
%   Input parameters:
%    qrsPs     : sequenza di puntatori a QRS in secondi
%    cName     : record name
%    graphRR   : enable RR.interval series graphics
%    graphStr  : structure for ecg signal graphic
%           .graphSgn - 1 enable graphics
%           .ecg  - ecg signal
%           .fs   - sampling frequency
%           .stts - start time in seconds
%           .ents - end time in seconds
%    debugF    : debug flag
%
%   Ouput parameters:
%	 qrsPsc : sequenza di puntatori a QRS "normali" (talvolta fittizi) in secondi
%	 qrsType : tipo di correzione effettuata sul puntatore a QRS  (stessa dimensione di qrsPsc)
%    npQm   :
% -------------------------------------------------------------------------------------------------
%   Maurizio Varanini,  Clinical Physiology Institute, CNR, Pisa, Italy
%   For any comment or bug report, please send e-mail to: maurizio.varanini@ifc.cnr.it
% -------------------------------------------------------------------------------------------------

function [qrsPsc, qrsType, npQm]=selNNeAFqrsP(qrsPs, cName, graphRR,saveGraphRR,RRgraph_path, graphStr, debugF)

if(nargin <7), debugF=0; end
if(nargin <6), graphStr=[]; end
if(nargin <5), RRgraph_path=[]; end
if(nargin <4), saveGraphRR=0; end
if(nargin <3), graphRR=0; end
if(nargin <2), cName=''; end
dbFlag=debugF>0; dbFlag1=debugF>1;
graphD1=graphRR & (debugF>1);
graphD2=graphRR & (debugF>2);
if(isstruct(graphStr))
    graphSgn=graphStr.graphSgn;
    ecg=graphStr.ecg;      % signal
    fs=graphStr.fs;        % sampling frequency
    stts=graphStr.stts;    % start time in seconds
    ents=graphStr.ents;    % end time in seconds
else
    graphSgn=0;
end
% dbFlag1=1;

nQRSp=length(qrsPs);
if(nQRSp<5), qrsPsc=[]; qrsType=[];
    npQm.nLVC= NaN;
    npQm.nPVC= NaN;
    npQm.nFP= NaN;
    npQm.nFN= NaN;
    return;
end

% Build RR-interval series
RRs=diff(qrsPs);

xmk= qrsPs(2:end);

if(graphD2)
    % function plotSgnTmMrkTnSec(xtime, sgn, pqrsi, tqrsi, name,nband, nsecr, normModef, swYTickLabel)
    %    PlotSgnTmMrkTsec(xmk,RRs, xmk, tmk, cName,1,xmk(end),0);
    [normModef.min, normModef.max]=mimaxsc(RRs,2,2); normModef.marg=1;
    PlotSgnTmMrkTsec(xmk,RRs, [], [], cName,1,xmk(end),normModef);
    %set( gcf,'Menubar','none');
    shg;
    figResize(0, 1, 1, 0.3);
end
% --------------------------------------------------------------------------
RRmedian=median(RRs);
if(length(RRs) > 11)
    %    RRme = meanWsc(RRs,11,3);
    RRmd = medfilt1(RRs, 11);  % RRmd = medfilt1(RRs, 5); %
    RRmeb =filter([.5,.5],1,RRmd); RRme = medfilt1(RRmeb,3);
    RRme(1:5)=RRme(6); RRme(end-4:end)=RRme(end-5);
    %    [RRme, RRmi, RRma] = memimaxWsc(RRs, 11, 4);
else
    RRme=repmat(RRmedian,length(RRs),1);
end
RRme=[RRme(1); RRme];
RRa=[RRme(1); RRs];
a=.02;
RRfb= filtfilt(a,[1,-(1-a)],RRa);  % low-pass filter
RRmebfb= filtfilt(a,[1,-(1-a)],RRme);  % low-pass filter
RRpc=RRa(1);                % previous corrected RR
nQRS=length(qrsPs);
nQRSp=ceil(nQRS*1.1);       % only for memory allocation
qrsPsc=zeros(nQRSp,1); RRc=zeros(nQRSp,1); %RRm3p=zeros(nQRSp,1);
qrsType=ones(nQRSp,1);
qrsPsc(1)=qrsPs(1); RRc(1)=RRpc;
%RRm3p(1)=RRa(1);  alp=0.9;
ic=1;
LVCflag=0; PVCflag=0; FNflag=0; FPflag=0;
nLVC=0; nPVC=0; nFP=0; nFN=0;
i=2;
while i<=nQRS
    RRai= RRa(i); RRmei= RRme(i);
    % if(i>2 && RRpc < 0.6*RRai && RRpc+RRai > 1.98 * RRmei && RRpc+RRai < 2.02 * RRmei)      % PVC with compensatory pause?
    if(i>2 && RRpc < 0.6*RRai && RRpc+RRai > 1.90 * RRmei && RRpc+RRai < 2.10 * RRmei)      % PVC with compensatory pause?
        RRpac=0.5*(RRpc+RRai);
        qrsPsc(ic)=qrsPsc(ic-1)+RRpac;
        qrsType(ic)=2;
        RRc(ic)= RRpac;
        ic=ic+1;
        if(dbFlag1), fprintf('PL: %d, %10.3f,%5.3f,%5.3f,%5.3f, %d, %10.3f,%5.3f, %5.3f, %5.3f\n',i-1,...
                qrsPs(i-1),RRa(i-1),RRai,RRmei, ic-1, qrsPsc(ic-1),(qrsPsc(ic-1)-qrsPsc(max(1,ic-2))),RRc(ic-1),RRpc); end
        if(i<nQRS), i=i+1; RRai= RRa(i); RRmei= RRme(i); else break; end
        qrsPsc(ic)=qrsPs(i-1);
        RRc(ic)=qrsPsc(ic)-qrsPsc(ic-1);
        if(graphD1)
            figure; plot(diff(qrsPs(max(i-10,1):i))); hold on; plot(RRme(max(i-10,1):i),'g'); hold off;
            figure; plot(max(ic-9,2):ic,[diff(qrsPsc(max(ic-10,1):ic)),RRc(max(ic-9,2):ic)]);
        end
        if(dbFlag), fprintf('PVC condition: i-1=%d, ic=%d\n',i-1,ic); end
        RRpc=RRai;
        ic=ic+1;
        nPVC=nPVC+1;
        
        %     elseif( i>2 && RRpc > 1.6*RRai && RRpc+RRai > 1.98 * RRmei && RRpc+RRai < 2.02 * RRmei)      % "late+early" condition
    elseif( i>2 && RRpc > 1.6*RRai && RRpc+RRai > 1.95 * RRmei && RRpc+RRai < 2.05 * RRmei)      % "late+early" condition
        RRpac=0.5*(RRpc+RRai);
        qrsPsc(ic)=qrsPsc(ic-1)+RRpac;
        qrsType(ic)=4;
        RRc(ic)= RRpac;
        ic=ic+1;
        if(dbFlag1), fprintf('LP: %d, %10.3f,%5.3f,%5.3f,%5.3f, %d, %10.3f,%5.3f, %5.3f, %5.3f\n',i-1,...
                qrsPs(i-1),RRa(i-1),RRai,RRmei, ic-1, qrsPsc(ic-1),(qrsPsc(ic-1)-qrsPsc(max(1,ic-2))),RRc(ic-1),RRpc); end
        if(i<nQRS), i=i+1; RRai= RRa(i); RRmei= RRme(i); else break; end
        qrsPsc(ic)=qrsPs(i-1);
        RRc(ic)=qrsPsc(ic)-qrsPsc(ic-1);
        if(graphD1)
            figure; plot(diff(qrsPs(max(i-10,1):i))); hold on; plot(RRme(max(i-10,1):i),'g'); hold off; shg;
            figure; plot(max(ic-9,2):ic,[diff(qrsPsc(max(ic-10,1):ic)),RRc(max(ic-9,2):ic)]); shg;
        end
        if(dbFlag), fprintf('"late+early" condition: i-1=%d, ic=%d\n',i-1,ic); end
        RRpc=RRai;
        ic=ic+1;
        nLVC=nLVC+1;
        
    elseif( RRpc+RRai < 1.2 * RRmei && RRpc<0.6*RRmei)    % too short RR interval (FP ?)
        if(dbFlag), fprintf('early beat: i-1=%d, ic=%d\n',i-1,ic); end
        RRpc=RRpc+RRai;
        if(dbFlag), fprintf('FP condition: i-1=%d, ic=%d\n',i-1,ic); end
        if(dbFlag1), fprintf('P: %d, %10.3f,%5.3f,%5.3f,%5.3f, %d, %10.3f,%5.3f, %5.3f, %5.3f\n',i-1,...
                qrsPs(i-1),RRa(i-1),RRai,RRmei, ic-1, qrsPsc(ic-1),(qrsPsc(ic-1)-qrsPsc(max(1,ic-2))),RRc(ic-1),RRpc); end
        nFP=nFP+1;
        
    elseif( RRpc > 1.7 * RRmei)                              % too long RR interval  (FN ?)
        if(dbFlag), fprintf('Late beat: i-1=%d, ic=%d\n',i-1,ic); end
        % nFNi=round((qrsPs(i)-qrsPsc(ic-1))/RRmei);
        nFNi=round(RRpc/RRmei);
        RRfn=RRpc/nFNi;
        for jfi=1:nFNi
            RRc(ic)=RRfn;
            qrsPsc(ic)=qrsPsc(ic-1)+ RRfn;
            qrsType(ic)=3;      % FN condition
            ic=ic+1;
            if(dbFlag), fprintf('FN condition: i=%d, ic=%d\n',i,ic); end
            nFN=nFN+1;
        end
        if(dbFlag1), fprintf('L: %d, %10.3f,%5.3f,%5.3f,%5.3f, %d, %10.3f,%5.3f, %5.3f, %5.3f\n',i-1,...
                qrsPs(i-1),RRa(i-1),RRai,RRmei, ic-1, qrsPsc(ic-1),(qrsPsc(ic-1)-qrsPsc(max(1,ic-2))),RRc(ic-1),RRpc); end
        RRpc=RRai;
        
    else                                    % Normal RR
        qrsPsc(ic)=qrsPs(i-1);
        RRc(ic)=RRpc;
        RRpc=RRai;
        ic=ic+1;
    end
    
    if(dbFlag1), fprintf('%d, %10.3f,%5.3f,%5.3f,%5.3f, %d, %10.3f,%5.3f, %5.3f, %5.3f\n',i-1,...
            qrsPs(i-1),RRa(i-1),RRai,RRmei, ic-1, qrsPsc(ic-1),(qrsPsc(ic-1)-qrsPsc(max(1,ic-2))),RRc(ic-1),RRpc); end
    
    if(ic>2 && abs((qrsPsc(ic-1)-qrsPsc(max(1,ic-2)))-RRc(ic-1))>1.e-9)
        if(dbFlag), fprintf('-----------------\n'); end
        for  j=min(5,ic-2):-1:0
            if(dbFlag), fprintf('%d, %10.3f, %7.3f, %d, %10.3f, %7.3f, %7.3f\n',i-1-j, qrsPs(i-1-j),RRs(i-1-j), ...
                    ic-j, qrsPsc(ic-1-j),(qrsPsc(ic-1-j)-qrsPsc(max(1,ic-2-j))),RRc(ic-1-j)); end
        end
    end
    %    debugFlag=(24101<i && i<24104);
    %    if debugFlag
    %        fprintf('%d\n',i);
    %    end
    
    i=i+1;
end

if(RRa(nQRS) < 0.7 * RRme(nQRS))
    RRc(ic)=RRme(nQRS);    qrsPsc(ic)=qrsPsc(ic-1)+RRc(ic);
else
    ic=ic-1;
end
nQRSc=ic;

qrsPsc(ic+1:end)=[];  RRc(ic+1:end)=[];  % RRm3p(ic+1:end)=[];
qrsType(ic+1:end)=[];

% check test
RRc_=diff(qrsPsc); RRc_=[RRc(1);RRc_];
dTest=find(abs(RRc-RRc_)>1.e-9);
if(~isempty(dTest))
    errpRR=length(dTest);
    fprintf('Check test failed!, err=%d\n',errpRR);
    if(graphRR && errpRR)
        figure('Color','white');    xlabel('time (seconds)');
        figResize(0, 1, 1, 0.3);
        plot(qrsPsc,RRc_,'m.-'); hold on;
        plot(qrsPsc,RRc,'b.-'); hold on;
        set(gca,'ylim',[0.2,3.0]);
        ht=title([cName, ' - RRc_ (m), RRc (b)']); set(ht,'Interpreter','none');
    end
    if(graphRR && errpRR)
        figure('Color','white');    xlabel('time (seconds)');
        figResize(0, 1, 1, 0.3);
        plot(qrsPsc,RRc_,'m.-'); hold on;
        plot(qrsPs,RRa,'r.-'); hold on;
        set(gca,'ylim',[0.2,3.0]);
        ht=title([cName, ' - RRc_ (r), RRa (b)']); set(ht,'Interpreter','none');
    end
end
% ----
if(graphRR || saveGraphRR)
    if(graphRR), figure; else figure('visible','off'); end
    set(gcf,'Color','white');    xlabel('time (seconds)');
    figResize(0, 1, 1, 0.3);
    plot(qrsPs,RRa,'r.-'); hold on;
    plot(qrsPsc,RRc,'b.-'); hold on;
    plot(qrsPs,RRme,'c'); hold on;
    plot(qrsPs,RRmebfb,'k','LineWidth',2); hold on;
    set(gca,'ylim',[0.2,2.4]);
    if(graphRR) shg; end
    ht=title([cName, ' - RR (r), RRc (b), med (c), mdfb (g)']); set(ht,'Interpreter','none');
    if(saveGraphRR), figFmtRR='png';
        figNameRR=fullfile(RRgraph_path,[cName,'_RR']);
        saveas(gcf, figNameRR, 'epsc');
        saveas(gcf, figNameRR, 'png');
        %       saveas(gcf, figNameRR, 'fig');
    end
end
% if(min(diff(qrsPsc)) <=0.3) [RRmin,iqrs]=min(diff(qrsPsc)); fprintf('RR too short! RR=%4.2g, index=%d\n', RRmin, iqrs); end
npQm.nLVC= nLVC;
npQm.nPVC= nPVC;
npQm.nFP= nFP;
npQm.nFN= nFN;

npQmt= nLVC+nPVC+nFP+nFN;
rAn= npQmt/nQRSc;
if(dbFlag)
    fprintf('nLVC=%d,  nPVC=%d,  nFP=%d,  nFN=%d,   rAn=%1.4f\n',nLVC,nPVC,nFP,nFN, rAn);
end

RRmean= mean(RRa);
RRstd= std(RRa);
if(dbFlag)
    fprintf('RR mean= %5.3f,  stdev=%5.3f\n', RRmean, RRstd);
end

if(graphD2)
    xmk= (qrsPsc(1:end)-1);
    tmk=ones(length(xmk),1);
    PlotSgnTmMrkTsec(xmk,RRa, xmk, tmk, cName,1,xmk(end),0);
    %set( gcf,'Menubar','none');
    figResize(0, 1, 1, 0.3);
end

if(graphSgn)
    %     ivqrsg=find( stts<qrsPsc & qrsPsc<ents);
    %     qrsPcg=qrsPsc(ivqrsg)-stts;
    %     istt=stts*fs+1; iett=ents*fs+1;
    stts=qrsPsc(find(qrsType>1,1,'first')) -5;  % start time = 5s before the first anomalous QRS
    if(isempty(stts)|| (stts<0)),stts=0; end
    ents=stts+60;
    istt=floor(stts*fs)+1; iett=floor(ents*fs)+1;
    
    ivqrsg=find(stts<qrsPs & qrsPs<ents);
    qrsPg=qrsPs(ivqrsg);
    %     PlotSgnMrkN(ecg(istt:iett), qrsPcg*fs, fs, [cName, '_ecg - time: ',num2str(stts),'s']);
    qrsTa=qrsType(ivqrsg);
    PlotSgnTmMrkTnSec((istt:iett)/fs, ecg(istt:iett), qrsPg, qrsTa, [cName, '_ecg - qrsP - time: ',num2str(stts),'s']);
    
    ivqrscg=find(stts<qrsPsc & qrsPsc<ents);
    qrsPcg=qrsPsc(ivqrscg);
    qrsTa=qrsType(ivqrscg);
    % plotSgnTmMrkTnSec(xtime, sgn, pqrsi, tqrsi, name, nband, nsecr, normModef, swYTickLabel)
    PlotSgnTmMrkTnSec((istt:iett)/fs, ecg(istt:iett), qrsPcg, qrsTa, [cName, '_ecg - qrsPc - time: ',num2str(stts),'s']);
end
