function [mi, ma] = mimaxMsc(M,perci,percf)
%  INSERIRE CONTROLLI sugli indici!!!
% -------------------------------------------------------------------------------------------------
% Compute the minimum and the maximum value of the columns of a matrix excluding the distribution tails.
%   [mi; ma] = mimaxMsc(v,perci,percf)
%            "perci" = % of min values;  "percf" = % of max values to be excluded
%
% -------------------------------------------------------------------------------------------------
%   Maurizio Varanini, Clinical Physiology Institute, CNR, Pisa, Italy
%   For any comment or bug report, please send e-mail to: maurizio.varanini@ifc.cnr.it
% -------------------------------------------------------------------------------------------------
[nrows,ncols]=size(M);
if(nrows==0 || ncols==0) mi=min(M',[],2); ma=max(M',[],2); return; end      % TOPPA!
if(nargin>1)
    if(nargin<3) percf=perci; end
    ii = max(min(floor(1 + nrows*perci/100),floor(nrows/2)),1);
    fi = min(max(ceil(nrows*(1 - percf/100)),ceil(nrows/2)),nrows);
    for icol=1:ncols
        vo=sort(M(:,icol));
        mi(icol)=min(vo(ii:fi));
        ma(icol)=max(vo(ii:fi));
    end
else
    mi=min(M,[],2); ma=max(M,[],2);
%     for icol=1:ncols
%         mi(icol)=min(M(:,icol));
%         ma(icol)=max(M(:,icol));
%     end
end
mi=mi.';
ma=ma.';

