function [meaMi,meaMa] = meanMiMaSc(v,wl,percmi,percma)
%  [meaMi,meaMa] = meanMiMaSc(v,wl,percmi,percma)
% -------------------------------------------------------------------------------------------------
% meanmaxsc.m: Compute the average value of the minima and of the maxima 
%              computed on data intervals of the input vector.
%              Distribution tails can be excluded using parameters "perci" and "percf"
%              "v"      = input data vector
%              "wl"     = data window length
%              "percmi" = % of min values (mins and maxs) to be excluded; (if positive)
%                         number of min values (if negative)
%              "percma" = % of max values to be excluded (if positive)
%                         number of max (mins and maxs) values (if negative)
%
%   Version 1.00, Date: 01/05/2000
% ---------------------------------------------------------------------------------------------
%   Maurizio Varanini, Clinical Physiology Institute, CNR, Pisa, Italy
%   For any comment or bug report, please send e-mail to: maurizio.varanini@ifc.cnr.it
% ---------------------------------------------------------------------------------------------

if(nargin<3), percmi=5; end
if(nargin<4), percma=percmi; end

wl=round(wl);
if(wl>length(v)) wl=length(v); end

% --- Often the code that follows is faster!
nw=fix(length(v)/wl);
n=nw*wl;
vm=reshape(v(1:n),wl,nw);
mini=min(vm);
maxi=max(vm);
%
% --- the code that follows is slower!
% j=1;
% mini=zeros(floor(length(v)/wl),1);
% maxi=zeros(floor(length(v)/wl),1);
% for i=1:wl:length(v)-wl+1
%     mini(j)=min(v(i:i+wl-1));
%     maxi(j)=max(v(i:i+wl-1));
%     j=j+1;
% end
% -----

if(percmi<0), ii=1-percmi;
else ii=1+floor(length(maxi)*percmi/100); end
if(percma<0), fi=length(maxi)+percma;
else fi=length(maxi)-floor(length(maxi)*percma/100); end

omini=sort(mini);
omaxi=sort(maxi);
meaMi=mean(omini(ii:fi));
meaMa=mean(omaxi(ii:fi));

