function [ y ] = Trapmf(x,vp)
% y = trapmf(x,[a b c d])
% trapezoidal function
%
y=zeros(size(x));
a=vp(1); b=vp(2); c=vp(3); d=vp(4); 
y(x<a)=0;
y(a<=x & x<=b)=(x(a<=x & x<=b)-a)/(b-a);
y(b<=x & x<=c)=1;
y(c<=x & x<=d)=(d-x(c<=x & x<=d))/(d-c);
y(x>d)=0;
end

% x = 0:0.1:10;
% y = Trapmf(x,[1 5 7 8]);
% plot(x,y)
% xlabel('trapmf, P = [1 5 7 8]')
% ylim([-0.05 1.05])
