    
function[featNames,featVals] =RRfeatures(RRv)

featNames=cell(1,20);
featVals=nan(1,20);   % <<==
nRR=numel(RRv);

RRmean=mean(RRv); RRmeansc=meansc(RRv);

jm=1;

featNames{jm}='RRmean'; 
if(nRR>0), featVals(jm)=RRmean; end
jm=jm+1;

featNames{jm}='RRmin'; 
if(nRR>0), featVals(jm)=min(RRv); end
jm=jm+1;

featNames{jm}='RRmax'; 
if(nRR>0), featVals(jm)=max(RRv); end
jm=jm+1;

featNames{jm}='RRbrady'; 
if(nRR>0), if(RRmean>1.2), featVals(jm)=(RRmean-1)/(2-1); else featVals(jm)=0; end; end
%if(nRR>0), featVals(jm)=0.5+0.5*tanh(4*(RRmean-1.2)); end
jm=jm+1;

featNames{jm}='RRtachy'; 
if(nRR>0), if(RRmean<0.7), featVals(jm)=(0.7-RRmean)/(0.7-0.3); else featVals(jm)=0; end; end
%if(nRR>0), featVals(jm)=0.5+0.5*tanh(2*(0.7-RRmean)); end
jm=jm+1;

featNames{jm}='Rmssdn';
if(nRR>6), featVals(jm)=Rmssd(RRv)/RRmean; end
jm=jm+1;

featNames{jm}='CoSEn';
if(nRR>6), featVals(jm)=CoSEn(RRv); end 
jm=jm+1;

featNames{jm}='Mhlbw';
if(nRR>6), featVals(jm)=MhlbwADiff(RRv)/RRmean; end
jm=jm+1;

featNames{jm}='Mhlbwc';
if(nRR>6), featVals(jm)=MhlbwADiffc(RRv)/RRmean; end
jm=jm+1;

% Katz Fractal Dimension (KFD)
featNames{jm}='KFD';
if(nRR>6), featVals(jm)= Katz_FD(RRv); end
jm=jm+1;

featNames{jm}='Tpc';
if(nRR>6), featVals(jm)=turningPointCount(RRv)/length(RRv); end
jm=jm+1;

featNames{jm}='IndPeC';
if(nRR>8), featVals(jm)=sum(IndPeC(RRv))/length(RRv); end
jm=jm+1;

featNames(jm:end)=[];
featVals(jm:end)=[];

if(0 & find(isinf( featVals)))
    debug=1; pause;
end
     
end
