% Mean of high-low Bounded weighted Absolute Difference
%
%--------------------------------------------------------------------------------------------------
%   Maurizio Varanini, Clinical Physiology Institute, CNR, Pisa, Italy
%   For any comment or bug report, please send e-mail to: maurizio.varanini@ifc.cnr.it
% -------------------------------------------------------------------------------------------------
 
function mwad = MhlbwADiffc(RRint)

mdRR=median(RRint);
if(length(RRint)>=5)
    RRwi = meanWsc(RRint, 5, 1, 1);
else
    RRwi = mdRR + zeros(size(RRint));
end
th1= 0.05 * mdRR;   %0.001 * mdRR;
th2= 0.5 * mdRR;
mwad = 0;
pvc=0;
% Find turning points
for j = 2:length(RRint)-1
    RRwm=RRwi(j);
    RRp=RRint(j-1); RRa=RRint(j); RRs=RRint(j+1);
    diffB=RRa - RRp;
    diffF=RRa - RRs;
    if(pvc), pvc=0; continue;end
    if( RRa < 0.65*RRwm &&  1.98 * RRwm <RRa+RRs && RRa+RRs < 2.02 * RRwm)
       pvc=1; continue;   % PVC with compensatory pause?
    end

    adiffB=abs(diffB);
    adiffF=abs(diffF);
    if((adiffB<th1) || (adiffB>th2)), continue; end
    if((adiffF<th1) || (adiffF>th2)), continue; end
    
    if((diffB>th1) && (diffF>th1))    % ^
        mwad = mwad + diffB + diffF;
    elseif((diffB<-th1) && (diffF<-th1))  % v
        mwad = mwad - diffB - diffF;
    else
        mwad = mwad + 0.5* abs(diffB) + 0.5* abs(diffB);
    end
end
mwad = mwad/(length(RRint)-2);

end

