% Mean of high-low Bounded weighted Absolute Difference
%
%--------------------------------------------------------------------------------------------------
%   Maurizio Varanini, Clinical Physiology Institute, CNR, Pisa, Italy
%   For any comment or bug report, please send e-mail to: maurizio.varanini@ifc.cnr.it
% -------------------------------------------------------------------------------------------------
 
function mwad = MhlbwADiff(RRint)
mdRR=median(RRint);
th1= 0.05 * mdRR;   %0.001 * mdRR;
th2= 0.5 * mdRR;
mwad = 0;
% Find turning points
for j = 2:length(RRint)-1
    diffB=RRint(j) - RRint(j-1);
    diffF=RRint(j) - RRint(j+1);
    adiffB=abs(diffB);
    adiffF=abs(diffF);
    if((adiffB<th1) || (adiffB>th2)), continue; end
    if((adiffF<th1) || (adiffF>th2)), continue; end
    
    if((diffB>th1) && (diffF>th1))    % ^
        mwad = mwad + diffB + diffF;
    elseif((diffB<-th1) && (diffF<-th1))  % v
        mwad = mwad - diffB - diffF;
    else
        mwad = mwad + 0.5* abs(diffB) + 0.5* abs(diffB);
    end
end
mwad = mwad/(length(RRint)-2);

end

