% Atrial fibrillation detection
% suggested threshold (eta=0.75)
% IndPeC >eta  ==> AF
% -
% extracted from:
% "Low-complexity detection of atrial fibrillation in continuous long-term monitoring
% A. Petrėnas, V. Marozas, L. Sörnmo
% Computers in Biology and Medicine 65 (2015) 184–191
%-----------------------------------------------------------------------------------------
function IndPeC = IndPeC(RRs)
RRlen=length(RRs);

gamma=0.03; N=8;

Mm=zeros(RRlen,1);
for n=N+1:RRlen
    Mm(n)=0;
    for j=0:N-1
        for k=j+1:N
            if(abs(RRs(n-j)-RRs(n-k))-gamma > 0), valm=1; else valm=0; end;
            Mm(n)=Mm(n)+valm;
        end
    end
end
Mm(1:N)=Mm(N+1);
Mm=Mm*2 /(N*(N-1));

a=.02;
RRintf= filtfilt(a,[1,-(1-a)],RRs);  % low-pass filter

Mmf= filtfilt(a,[1,-(1-a)],Mm);     % low-pass filter

It=Mmf./RRintf;

RRmds=medfilt1(RRs,3);

for n=N+1:RRlen
    Bm(n)= (sum(RRmds(n-N+1:n))/sum(RRs(n-N+1:n)) -1)^2;
end
Bm(1:N)=Bm(N+1);

% Bmt=expavfb(Bm,a);
Bmt= filtfilt(a,[1,-(1-a)],Bm);     % low-pass filter

delta=0.0002;

O=zeros(RRlen,1);
for n=1:RRlen
    if(Bmt(n) >= delta)
        IndPeC(n)=It(n);
    else
        IndPeC(n)=Bmt(n);
    end
end

