% Rimozione battiti ectopici
% Lucia Billeci
% modified MV
function RRe=ectBeatRemM(RRa,winL)
if(nargin<2), winL=min(240,length(RRa)); end
RRaLen=length(RRa);
if(RRaLen<4), RRe=ones(size(RRa)); return; end
RRe=RRa;
for iw=1:winL:RRaLen-winL+1
    RRw=RRa(iw:iw+winL-1);
    for i=2:length(RRw)-1
        K1(i)=RRw(i)/RRw(i-1);
    end
    K1_thLow=prctile(K1(2:end),1.5);   % K1_thLow=prctile(K1,1);
    K1_thHigh=prctile(K1(2:end),98.5); % K1_thHigh=prctile(K1,99);
    
    for i=2:length(RRw)-1
        K2(i)=RRw(i)/RRw(i+1);
    end
    K2_th=prctile(K2(2:end),25);    %  K2_th=prctile(K2,25);
     
    count=0;
    for i=2:length(RRw)-2
        if K1(i)<K1_thLow && K1(i+1)>K1_thHigh && K2(i+1)>K2_th
            RRw(i)=NaN; RRw(i+1)=NaN;
            count=count+1;
        end
    end
    RRe(iw:iw+winL-1)=RRw;
end
%    RRe(iw:RRaLen)=RRa(iw:RRaLen);
nanx = isnan(RRe);
t= 1:numel(RRe);
RRe(nanx) = interp1(t(~nanx), RRe(~nanx), t(nanx));
end

function prc = prctile(X,prcvals)
prc = Prctiles(X,prcvals);
end
