function [FpPmax,mPdAF,mPdAFr]=Ecg_spectPeak(X,fs,cName,graph,dbFlag,saveFig)
% -------------------------------------------------------------------------------------------
%  Search for a spectral peak in the residual signal (after QRS cancelinq).
%
%  X      : signal matrix (one signal per column)
%  fs     : sampling frequency
%  cName  : record name
%  graph   : flag enabling figure drawing
%  dbFlag : flag enabling figure drawing for tuning and debugging
% -------------------------------------------------------------------------------------------
% output:
%  FpPmax  : frequency of the peak
%  mPdAF   : weighted power arond the peak
%  mPdAFr  : ratio between the peakpower and the power around it
%
% -------------------------------------------------------------------------------------------
%   Maurizio Varanini, Clinical Physiology Institute, CNR, Pisa, Italy
%   For any comment or bug report, please send e-mail to: maurizio.varanini@ifc.cnr.it
% -------------------------------------------------------------------------------------------
% This program is free software; you can redistribute it and/or modify it under the terms
% of the GNU General Public License as published by the Free Software Foundation; either
% version 2 of the License, or (at your option) any later version.
%
% This program is distributed "as is" and "as available" in the hope that it will be useful,
% but WITHOUT ANY WARRANTY of any kind; without even the implied warranty of MERCHANTABILITY
% or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
% -------------------------------------------------------------------------------------------

if(nargin<3), cName=''; end
if(nargin<4), graph=0; end
if(nargin<5), dbFlag=0; end
if(nargin<6), saveFig=0; end
graphD= graph &dbFlag ;
graphSpt= graph &dbFlag ;
graph=0;
dbgLog=0;
if(dbFlag)
    fprintf('\n --------------------------------------------------------- \n');
    progname = mfilename;
    fprintf('Program: %s,   record name: %s\n', progname, cName);
end
if(saveFig), figFmt='png';
    figPath=fullfile('../Figure/',progname);
    if(~exist(figPath,'dir')), mkdir(figPath); end
end
%-------------------------------------------------------------
% recording duration
[ndt, ns]=size(X);
vtime= [1:ndt]/fs;
%-------------------------------------------------------------------------------
Xf=zeros(size(X));
for is=1:ns
    x=X(:,is);
    x=x-mean(x);
    if(dbFlag && graphSpt), figure; pwelch(X(:,is),[],[],[],fs);
        title('ECG Welch spectrum');
    end
    if(dbgLog)
    window=feval('hamming',ndt);
    periodogram(x,window);
    end
    % ---------------------------------------------------------------------------------------------------------
    % Power Spectral Density
    wLen=4*fs; if(wLen>0.5*ndt),FpPmax=NaN; mPdAF=NaN; mPdAFr=NaN; return; end
    wOverlap=fix(wLen*0.7);
    ni=round((ndt-wLen)/(wLen-wOverlap))+1;  % si ricalcola il numero di intervalli
    nfft=2.^(ceil(log2(wLen))+2);
    winType= 'hamming';      % 'rectwin';  'hann'; 'blackman';
    window=feval(winType,wLen);
    %
    fris=fs/wLen;   % risoluzione in frequenza effettiva
    if(dbgLog)
    fprintf(' Analisi spettrale con il metodo di Welch\n');
    fprintf(' Durata finestra = %g sec, risoluzione in freq. %g Hz \n', wLen/fs, fs/wLen);
    fprintf(' Risoluzione in freq. apparente %g Hz\n', fs/nfft);
    fprintf(' Numero di intervalli %d, frazione di sovrapposizione = %4.3f\n', ni, wOverlap/wLen);
    fprintf(' Parametri per la pWelch; wLen= %g, wOverlap=%g, nfft=%g\n', wLen, wOverlap, nfft);fprintf(' Analisi spettrale con il metodo di Welch\n');
    end
    % [Ppxx,Fp] = pwelch(x,window,wOverlap,nfft,fs);
    %   returns the Power Spectral Density (PSD) estimate, Pxx,
    %   of a discrete-time signal vector X using Welch's averaged, modified
    %   periodogram method.  PSD computed as a function of physical frequency (Hz).
    %   Fs is the sampling frequency specified in Hz.  If Fs is empty, it defaults to 1 Hz.
    %   F is the vector of frequencies at which the PSD is estimated and has
    %   units of Hz.  For real signals, F spans the interval [0,Fs/2] when nfft
    %   is even and [0,Fs/2) when nfft is odd.  For complex signals, F always
    %   spans the interval [0,Fs).
    [Ppxx,Fp] = pwelch(x,window,wOverlap,nfft,fs);
    if(dbgLog),fprintf('Numero di frequenze =%d\n',length(Fp));end
    
    % ---------------------------------------------------------------------------------------------------------
 
    fmin=3;
    fmax=10;
    indAF=find(fmin<Fp & Fp<fmax);
    f4=4; indf4=find(f4<Fp,1,'first');
    f6=6; indf6=find(Fp<f6,1,'last');
    wgt=Trapmf(indAF,[indAF(1),indf4,indf6,indAF(end)]);
    if(graph), figure; plot(Fp(indAF),wgt); end

    % Search the frequency of maximum power
    [Pdmaxb, ifPmaxb] = max(wgt.*Ppxx(indAF));
    ifPmaxb=indAF(1)+ifPmaxb-1;
    FpPmax=Fp(ifPmaxb);    %  FpPmax  : frequency of the peak
    % ---------------------------------------------------------------------------------------------------------
    
%     pAroundPeak=sum(Ppxx([FpPmax-0.5<Fp & Fp<FpPmax+0.5]));
%     pAround=sum(Ppxx([(1<Fp & Fp<FpPmax-0.5) |( FpPmax+0.5<Fp & Fp<15)]));
%     mDpAroundPeak=pAroundPeak/(0.5+0.5);
%     mDpAround=pAround/((FpPmax-0.5)-1 + 15 -(FpPmax+0.5));
%--- 20170802 --
    pAroundPeak=sum(Ppxx([FpPmax-0.5<Fp & Fp<FpPmax+0.5]));
    pAround=sum(Ppxx((1<Fp & Fp<FpPmax-1.0) |( FpPmax+1.0<Fp & Fp<15)));
    mDpAroundPeak=pAroundPeak/(0.5+0.5);
    mDpAround=pAround/((FpPmax-1.5)-1 + 15 -(FpPmax+1.5));
   
    mPdAF=Pdmaxb;                     % weighted power arond the peak
    mPdAFr=mDpAroundPeak/mDpAround;   % ratio between the peakpower and the power around it
% ------------------------------------------------------------------------   
    if(mPdAF<=0), mPdAF=1e-9; end
    mPdAF=log(mPdAF);
    
    if(mPdAFr<=0), mPdAFr=1e-9; end
    mPdAFr=log(mPdAFr);    %  log of ratio between the peakpower and the power around it

    if(isnan(mPdAFr)), mPdAFr=0; end
    
% ---------------------------------------------------------------------------------------------------------
%     if(graph)
%         figure;
%         plot(Fp(indAF),Ppxx(indAF)); hold on
%         % draw the marker of the power peak
%         ylim = get(gca,'Ylim');
%         ymima=ylim(2)-ylim(1);
%         fxPeak=Fp([ifPmaxb,ifPmaxb]);
%         ylimb=ylim+[0.2*ymima -0.2*ymima];
%         fyband = ones(size(fxPeak)); fyband(:,1)=ylimb(1); fyband(:,2)=ylimb(2);
%         plot(fxPeak',fyband', 'r-.'); hold off
%     end
%     
%     if(graph)
%         figure;
%         indF=find(0<Fp & Fp<70);
%         plot(Fp(indF),Ppxx(indF));
%         
%         indF=find(1<Fp & Fp<30);
%         figure;
%         plot(Fp(indF),Ppxx(indF));
%         ylim = get(gca,'Ylim');
%         hold on
%         % draw the marker of the power peak
%         fxPeak=Fp([ifPmaxb,ifPmaxb]);
%         ylimb=ylim+[0.2*ymima -0.2*ymima];
%         fyband = ones(size(fxPeak)); fyband(:,1)=ylimb(1); fyband(:,2)=ylimb(2);
%         plot(fxPeak',fyband', 'r-.');
%     end
    % ---------------------------------------------------------------------------------------------------------
end %== function ================================================================
%

