function QRSmorphPar=EcgQRSmorphPar(X,qrsP,fs,elaOption,cName,graph,dbFlag,figmPath,figArtPar,fidLog)
% ---------------------------------------------------------------------------------------------
% ECG: QRS complex clustering using  an approximation obtained by the
% Singular Value Decomposition (SVD).
% A trapezoidal window is used to select and weight the signal around each detected QRS.
%
% ==>> changes are necessary to manage long record of signal as
% this version assumes the number of point in the window greather than the
% number of qrs!
% 
% Author: Maurizio Varanini, Clinical Physiology Institute, CNR, Pisa, Italy
% For any comment or bug report, please send e-mail to: maurizio.varanini@ifc.cnr.it
% ---------------------------------------------------------------------------------------------
% This program is free software; you can redistribute it and/or modify it under the terms
% of the GNU General Public License as published by the Free Software Foundation; either
% version 2 of the License, or (at your option) any later version.
% This program is distributed "as is" and "as available" in the hope that it will be useful,
% but WITHOUT ANY WARRANTY of any kind; without even the implied warranty of MERCHANTABILITY
% or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
% ---------------------------------------------------------------------------------------------

if(nargin<4), elaOption=[]; end
if(nargin<5), cName=''; end
if(nargin<6), graph=1; end
if(nargin<7), dbFlag=1; end
if(nargin<8), figmPath=''; end
if(nargin<9), figArtPar=[]; end
if(nargin<10), fidLog=0; end
if(isempty(figArtPar))
    figArt=0; 
else
    figArt=1;
    saveFigA=1;
    isFig=figArtPar.isFig;   % interval start (second) for articles figure
    ieFig=figArtPar.ieFig;   % interval end
    fontName=figArtPar.fontName;
    fontSize=figArtPar.fontSize;
    plotWidth=figArtPar.plotWidth;
    splotHeight=figArtPar.splotHeight;  % singol plot heght in cm 
end
if(isempty(elaOption)),    elaOption.nds=0; end

nds=elaOption.nds;

grafEigD=0;

progname=mfilename;
if(fidLog),
fprintf('\n --------------------------------------------------------- \n');
fprintf('Program:  %s,  record name: %s\n', mfilename, cName);
    fprintf(fidLog,'--------------------------------------------------------- \n');
    fprintf(fidLog,'Program: %s,   record name: %s\n', mfilename, cName);
    if(nds>0), fprintf(fidLog,'Fixed n_eig=%d\n', nds); end
end

%-------------------------------------------------------------
% recording duration
[ndt, ns]=size(X);

vtime= [1:ndt]/fs;
% -----

if(dbFlag), PlotSgnMrkNc(X, qrsP, fs, [cName, ' - mother QRS det.']); end
nQRS=length(qrsP);
if(fidLog), fprintf('Number of QRSs= %d\n', nQRS); end

RRc= diff(qrsP);
RRs= RRc/fs;
RRmean=meansc(RRs,4,4);
%RRmean= mean(RRs);
RRstd= std(RRs);
if(fidLog), fprintf('RR mean= %d,  stdev=%d\n', RRmean, RRstd); end

QTlen=0.42*sqrt(RRmean);   % normal Qt length (RR=1 => QT=0.42s, humans)
npQT=fix(QTlen*fs);

% the reference point is the point of max signed derivative
npp=fix(0.15*fs);               % number of samples before the qrs reference
npd=fix(min(0.2, 0.7*(RRmean-0.1))*fs);  % number of samples after the qrs reference
%npd=fix(min(0.2, QTlen)*fs);  % number of samples after the qrs reference
npt=1+npp+npd;

% extend the signals in order to manage the first and the last QRS
Xx=X;
npqp=fix(0.12*fs);
if(qrsP(1)-npqp < 1), qi=2; 
    npxp=0;
    Xx(1:npqp,:)=repmat(Xx(npqp+1,:),npqp,1);
else qi=1;
    npxp=max(0,npp+1-qrsP(1));  % number of samples added to left of each signal
    Xx=[repmat(X(1,:),npxp,1);X];
end
npqd=fix(0.14*fs);
qf=nQRS;
if(qrsP(end)+npqd > size(X,1)), qf=qf-1;
    Xx(end-npqd+1:end,:)=repmat(Xx(end-npqd-1,:),npqd,1);
end
if(qrsP(qf)+0.85*fs*median(RRs(end-4:end)) < size(X,1))
    npep=fix(max(0.1*fs, 0.15*fs*mean(RRs(end-4:end))));
    Xx(end-npep+1:end,:)=repmat(Xx(end-npep-1,:),npep,1);
end
npxd=max(0,qrsP(qf)+npd-ndt);  % number of samples added to right of each signal
Xx=[Xx;repmat(X(end,:),npxd,1)];

ndtx=size(Xx,1);
nqe= qf-qi+1;
vtimex= [1-npxp:ndt+npxd]/fs;


% built vectors of indexes (start and end) of QRS window
iqw=qrsP(qi:qf);
iw=npxp+iqw-npp;      %  start of QRS window
fw=npxp+iqw+npd;      %  end of QRS window

A=zeros(npt,nqe);
Aw=zeros(npt,nqe);
wwg=weightFun2(npp,npd,fs);
Xc=zeros(ndtx,ns);
B=cell(nqe,1);
% nds=3;     % select the number of singular values  <===
for is=1:ns
    iow=fw(1); fow=iw(2); 
    for iq=1:nqe
        iwq=iw(iq); fwq=fw(iq);
        if(iq<nqe),  fow=iw(iq+1);  iow=min(fwq-npd+npQT,fow-fix(0.2*fs));
        end
        A(:,iq)=Xx(iwq:fwq,is);
        B{iq}=Xx(iow:fow,is);
        Aw(:,iq)=A(:,iq).*wwg;
    end
%    if(nds==0 || dbFlag)
        % -------------------------------------
        % Singular value decomposition
        % S = diagonal matrix containing the singular values
        % U and V = unitary matrices so that X = U*S*V'.
        % The matrix Aw has dimension (npt, nqe) with npt> nqe
        % then we use the "economy size" decomposition
        %    tic;
        [U,S,V] = svd(Aw,0);
        %    fprintf('SVD (%d,%d) computation time = %3.2f\n', size(Aw), toc);
        
        %    fprintf('%f,  ', diag(S));   fprintf('\n');
        if(grafEigD), figure; plot(diag(S),'r-*');
            title([num2str(is),'- Singular values']); drawnow;
        end
        
        sv=diag(S);
        if(nds==0)
            if(sv(3)>1.5*sv(4)), ndsi=3; else  ndsi=2; end
            %fprintf('Chan=%d, n_eig=%d\n', is, ndsi);
            if(fidLog),
                fprintf(fidLog,'Chan=%d, n_eig=%d\n', is, ndsi);
            end
        else ndsi=nds;    
        end
        pownds(is)=sum(sv(1:ndsi).^2)/sum(sv(1:nqe).^2);
        if(dbFlag), fprintf('is=%d, pownds=%f\n', is, pownds(is)); end
        
        %    tic
        % Ar=U(:,1:ndsi)*S(1:ndsi,1:ndsi)*V(:,1:ndsi)';
        %    fprintf('Ar (%d,%d) rebuilding time = %3.2f\n', size(Ar), toc);
%     else
%         % ------------------------------------------
%         % --- if we know the number of singular values, we can use "svds"
%         [U,S,V] = svds(Aw,nds);
%         Ar=U*S*V';
%         % ---
%     end
% ------------------------------------------    
%     [arAr,ind]=min(sum(abs(Ar)));
%     ppAmpl=max(Ar(:,ind))-min(Ar(:,ind));
%     QRSwidth= arAr/ppAmpl;
    
    arabsAr=sum(abs(A))';
    [minA,maxA]=mimaxMsc(A,1,1);
    ppAmpl=maxA-minA;
    qrsPol=maxA+minA;
    QRSewidth= (1/fs)*2*arabsAr./ppAmpl;  % QRS equivalent width
    minB=zeros(nqe,1); maxB=zeros(nqe,1);
    for ib=1:size(B,1)
        [minB(ib),maxB(ib)]=mimaxsc(B{ib},3,3);
    end
    basPPampl=maxB-minB;
    pprAmpl=ppAmpl./basPPampl;
    
    QRSppAmplMea=meansc(ppAmpl,2,2);
    QRSpprAmplMea=meansc(pprAmpl,2,2);
    QRSpolMea=meansc(qrsPol,3,3);
    
    QRSwidthMax=max(QRSewidth);
    QRSwidthMin=min(QRSewidth);
    QRSwidthMea=meansc(QRSewidth,4,4);
    QRSwidthNmea=meansc(QRSewidth,4,40);
    QRSwidthStd=std(QRSewidth);
    nWideQRS=sum(QRSewidth > 1.25 * QRSwidthNmea); % 1.2 peggiora
    pnWideQRS=nWideQRS / numel(QRSewidth);
    %pnWideQRS=sum(0.5+0.5*tanh(1*(QRSewidth - 0.6* QRSwidthNmea))) / numel(QRSewidth);
   
    QRSmean=meanMsc(A',5,5); 
    morphDiffr=mean(sum(abs(A-repmat(QRSmean,1,size(A,2)))))/sum(abs(QRSmean));

    %morphDiffr=sum(abs(U(:,1)-U(:,2)))/sum(abs(U(:,1)+U(:,2)));

    eigDiff2=(sv(1)-sv(2))/sum(sv);
%    eigDiff2=(sv(1)-sv(2)-sv(3))/sum(sv);
    eigDiff=1+(sv(1)-sum(sv(3:end)))/sum(sv);
    
    if(dbFlag) 
        figure; plot((0:npt-1)/fs,A);
%        figure; plot((0:npt-1)/fs,Ar);
%        figure; plot((0:npt-1)/fs,Ar./wwg);
        figure; plot((0:npt-1)/fs,U(:,1));
        figure; plot((0:npt-1)/fs,U(:,2));
        figure; plot((0:npt-1)/fs,U(:,3));
    end
end

QRSmorphPar.QRSewidth=nan(size(qrsP));
QRSmorphPar.QRSewidth(qi:qf,1)= QRSewidth;

QRSmorphPar.QRSppAmplMea= QRSppAmplMea;
QRSmorphPar.QRSpprAmplMea= QRSpprAmplMea;
QRSmorphPar.QRSpolMea= QRSpolMea;

QRSmorphPar.QRSwidthMax= QRSwidthMax;
QRSmorphPar.QRSwidthMin= QRSwidthMin;
QRSmorphPar.QRSwidthMea= QRSwidthMea;
QRSmorphPar.QRSwidthNmea= QRSwidthNmea;
QRSmorphPar.QRSwidthStd= QRSwidthStd;
QRSmorphPar.pnWideQRS= pnWideQRS;
QRSmorphPar.morphDiffr= morphDiffr;
QRSmorphPar.eigDiff2= eigDiff2;
QRSmorphPar.eigDiff= eigDiff;


if(fidLog),
    fprintf(fidLog,'--------------------------------------------------------- \n');
    fprintf(fidLog,'Program: %s,   record name: %s, n_eig=%d\n', mfilename, cName, nds);
end

iw=iw-npxp;  fw=fw-npxp;
if(graph)
    for is=1:ns,
        figure,  set(gcf,'Color','white');
        subplot(2,1,1), plot(vtime,[X(:,is),Xc(:,is)]);
        wgmi1= min(X(:,is)) -2;
        wgma1= max(X(:,is)) +2;
        ylim([wgmi1, wgma1]);
        set(gca,'YTick',[-5 0 5])
        DrawVertMarker(iw/fs,'r',':','none');
        DrawVertMarker(qrsP/fs,'g',':','none');
        DrawVertMarker(fw/fs,'m',':','none');
        title([cName,' - ',num2str(is),': ecg & ecgM'],'Interpreter','none');
        subplot(2,1,2), plot(vtime,Xe(:,is));
        ylim([wgmi1, wgma1]);
        set(gca,'YTick',[-5 0 5])
        DrawVertMarker(iw/fs,'r',':','none');
        DrawVertMarker(qrsP/fs,'g',':','none');
        DrawVertMarker(fw/fs,'m',':','none');
        title([cName,' - ',num2str(is),': ecg - ecgM'],'Interpreter','none');
        shg
    end
end
%--------------------------------------------------------------------------------------------
if(graph || ~isempty(figmPath))
    figure, set(gcf,'Color','white');
    for is=1:ns,
        subplot(ns,1,is), plot(vtime,Xe(:,is));
        wgmi1= min(Xe(:,is)) -2;
        wgma1= max(Xe(:,is)) +2;
        ylim([wgmi1, wgma1]);
        DrawVertMarker(iw/fs,'r',':','none');
        DrawVertMarker(qrsP/fs,'g',':','none');
        DrawVertMarker(fw/fs,'m',':','none');
        set(gca,'YTick',[-5 0 5])
        % if(is~=ns), set(gca,'XTickLabel',''); end
        if(is==1), title([cName,': residual signals'],'Interpreter','none'); end
    end
    shg
    if(~isempty(figmPath)), figFmt='png';
        figPath=fullfile(figmPath,progname);
        if(~exist(figPath,'dir')), mkdir(figPath); end
        figName=fullfile(figPath,[cName,'_mCanc']);
        print(gcf, ['-d',figFmt],figName);
        %    saveas(gcf, figName,'fig');
    end
end

if(figArt)  
    isFig=isFig*fs+1;   % interval start (samples) for articles figure
    ieFig=ieFig*fs;   % interval end
    vtimeFig=(isFig:ieFig)/fs;
    figure, set(gcf,'Color','white');
    % set the size of the figure
    set(gcf, 'units', 'centimeters', 'position', [0,0,plotWidth,(3+1)*splotHeight]) % [left, bottom, width, height]
    wgmima= mimaxscG(Xx(isFig:ieFig,:),0.1,0.1,0.2);
    is=2;
    h=subplot(3,1,1); plot(vtimeFig, Xx(isFig:ieFig,is));  % ,'align'
    
    ylim(wgmima);
    %set(gca,'YTick',[-10 0 10]);
    set(gca,'XTickLabel','');
    set(gca,'FontName',fontName,'FontSize',fontSize)
    ylabel(['ECG',num2str(is),' (au)'],'FontName',fontName,'FontSize',fontSize);
    h=subplot(3,1,2); plot(vtimeFig, Xc(isFig:ieFig,is));  % ,'align'
    p=get(h,'pos');   % 4-element vector [left, bottom, width, height]
    p(2)=p(2)+0.05; set(h, 'pos', p);   % reduce space between subplots
    
    ylim(wgmima);
    %set(gca,'YTick',[-10 0 10]);
    set(gca,'XTickLabel','');
    set(gca,'FontName',fontName,'FontSize',fontSize);
    ylabel(['estECG (au)'],'FontName',fontName,'FontSize',fontSize);
    h=subplot(3,1,3); plot(vtimeFig, Xe(isFig:ieFig,is));  % ,'align'
    p=get(h,'pos');   % 4-element vector [left, bottom, width, height]
    p(2)=p(2)+2*0.05; set(h, 'pos', p);   % reduce space between subplots
    
    ylim(wgmima);
    %set(gca,'YTick',[-5 0 5]);
    set(gca,'FontName',fontName,'FontSize',fontSize);
    xlabel('time (s)','FontName',fontName,'FontSize',fontSize);
    ylabel(['resSgn (au)'],'FontName',fontName,'FontSize',fontSize);
    align_YlabelsM(gcf);
    shg
    if(saveFigA), figFmt='eps'; %figFmt='png';
        figPath='./FigureArt/';
        if(~exist(figPath,'dir')), mkdir(figPath); end
        figName=fullfile(figPath,['Fig05_',cName,'_mECGcanc']);
        % ---
        % resize the figure window
        set(gcf, 'units', 'centimeters', 'position', [0,0,plotWidth,3*splotHeight]) % [left, bottom, width, height]
        % save the figure using export_fig
        export_fig(figName,'-eps', '-p0.01');
        % ---
% %         lineobj = findobj('type', 'line');
% %         set(lineobj, 'linewidth', 0.5);
%         set(gcf,'PaperPositionMode', 'manual');
%         set(gcf,'PaperUnits', 'centimeters') 
%         set(gcf,'PaperPosition',[0,0,16,12]);       % [left, bottom, width, height]
%         print(gcf, ['-d',figFmt],'-r300','-loose','-tiff',figName);
% %        print(gcf, '-dtiff','-r300',figName);
        saveas(gcf, figName, 'png');
        saveas(gcf, figName, 'fig');
    end
end
%-------------------------------------------------------------


return
end % = function ===============================================================

% ------------------------------------------------------------------
function wwg=weightFun2(npp,npd,fs)
nppc1=fix(0.06*fs); npdc1=fix(0.06*fs);
nppc2=fix(0.08*fs); npdc2=min(fix(0.2*fs),npd-npdc1);
ii1=1; ie1=npp-nppc1-nppc2;
ii2=ie1+1; ie2=ie1+nppc2;
ii3=ie2+1; ie3=ie2+nppc1+npdc1+1;
ii4=ie3+1; ie4=ie3+npdc2;
ii5=ie4+1; ie5=npp+npd+1;
wwg(ii1:ie1)=0.20;
wwg(ii2:ie2)=0.20+0.8*(1:nppc2)/nppc2;
wwg(ii3:ie3)=1;
wwg(ii4:ie4)=1-0.8*(1:npdc2)/npdc2;
wwg(ii5:ie5)=0.20;
wwg=wwg';
% figure, plot(wwg);
return
end % = function ===============================================================
%

