function [Xl,pR]=EcgLowPass(X,fs,cName,graph,dbFlag,saveFig)
% -------------------------------------------------------------------------------------------
%   ECG high pass
%
%  X      : signal matrix (one signal per column)
%  fs     : sampling frequency
%  cName  : record name
%  graf   : flag enabling figure drawing
%  dbFlag : flag enabling figure drawing for tuning and debugging
%
% -------------------------------------------------------------------------------------------
%   Maurizio Varanini, Clinical Physiology Institute, CNR, Pisa, Italy
%   For any comment or bug report, please send e-mail to: maurizio.varanini@ifc.cnr.it
% -------------------------------------------------------------------------------------------
% This program is free software; you can redistribute it and/or modify it under the terms
% of the GNU General Public License as published by the Free Software Foundation; either
% version 2 of the License, or (at your option) any later version.
%
% This program is distributed "as is" and "as available" in the hope that it will be useful,
% but WITHOUT ANY WARRANTY of any kind; without even the implied warranty of MERCHANTABILITY
% or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
% -------------------------------------------------------------------------------------------

if(nargin<3), cName=''; end
if(nargin<4), graph=0; end
if(nargin<5), dbFlag=0; end
if(nargin<6), saveFig=0; end
graphD= graph &dbFlag ;
graphSpt= graph &dbFlag ;

if(dbFlag)
fprintf('\n --------------------------------------------------------- \n');
progname = mfilename;
fprintf('Program: %s,   record name: %s\n', progname, cName);
end
if(saveFig), figFmt='png';
    figPath=fullfile('../Figure/',progname);
    if(~exist(figPath,'dir')), mkdir(figPath); end
end
%-------------------------------------------------------------
% recording duration
[ndt, ns]=size(X);
vtime= [1:ndt]/fs;
%-------------------------------------------------------------------------------
fmaxd=30;       
fmaxn = fmaxd/(fs/2);
[b,a]= butter(1,fmaxn,'low');
Xl=filtfilt(b,a,X);

for is=1:ns
%pR(is)=(var(X(:,is)-Xl(:,is))/var(X(:,is)));
    pR(is)=varsc(Xl(:,is),1,1)/(varsc(X(:,is)-Xl(:,is),1,2));
    if(pR(is)<=0), pR(is)=1e-9; end
    if(isnan(pR(is))), pR(is)=1; end
    pR(is)=log(pR(is));
end
%-------------------------------------------------------------------------------

if(graph)
    figure, set(gcf,'Color','white');
    for is=1:ns,
        subplot(ns,1,is), hold on, plot(vtime,X(:,is),'r'), plot(vtime,Xl(:,is),'b');
        wgmimaV=mimaxscG(Xl(:,is),0,0,.4);
        ylim(wgmimaV);
        if(is~=ns), set(gca,'XTickLabel',''); end
        if(is==1), title([cName,': original(r) & filtered(b) ECG']); end
    end
    if(saveFig)
        figName=fullfile(figPath,[cName,'_DetrFilt']);
        print(gcf, ['-d',figFmt],figName);
    end
end

end %== function ================================================================
%

