function [Xb46,pBr]=Ecg4_6bandPass(X,fs,cName,graph,dbFlag,saveFig)
% -------------------------------------------------------------------------------------------
%   Signal filtering in the 4-6Hz range
%   Compute the power in the band 4-6Hz of the residual signal (after QRS cancelinq).
%
%  X      : signal matrix (one signal per column)
%  fs     : sampling frequency
%  cName  : record name
%  graf   : flag enabling figure drawing
%  dbFlag : flag enabling figure drawing for tuning and debugging
% -------------------------------------------------------------------------------------------
%  Xb46  band pass (4-6Hz) filtered signal
%  pbR    : ratio between the 4-6 power and the other frequency range power
% -------------------------------------------------------------------------------------------
%   Maurizio Varanini, Clinical Physiology Institute, CNR, Pisa, Italy
%   For any comment or bug report, please send e-mail to: maurizio.varanini@ifc.cnr.it
% -------------------------------------------------------------------------------------------
% This program is free software; you can redistribute it and/or modify it under the terms
% of the GNU General Public License as published by the Free Software Foundation; either
% version 2 of the License, or (at your option) any later version.
%
% This program is distributed "as is" and "as available" in the hope that it will be useful,
% but WITHOUT ANY WARRANTY of any kind; without even the implied warranty of MERCHANTABILITY
% or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
% -------------------------------------------------------------------------------------------

if(nargin<3), cName=''; end
if(nargin<4), graph=0; end
if(nargin<5), dbFlag=0; end
if(nargin<6), saveFig=0; end
graphD= graph & dbFlag ;
graphSpt= graph & dbFlag ;

if(dbFlag)
fprintf('\n --------------------------------------------------------- \n');
progname = mfilename;
fprintf('Program: %s,   record name: %s\n', progname, cName);
end
if(saveFig), figFmt='png';
    figPath=fullfile('../Figure/',progname);
    if(~exist(figPath,'dir')), mkdir(figPath); end
end
%-------------------------------------------------------------
% recording duration
[ndt, ns]=size(X);
vtime= [1:ndt]/fs;
%-------------------------------------------------------------------------------
fmind=4;  fmaxd=6;      
fminn = fmind/(fs/2); fmaxn = fmaxd/(fs/2);
[b,a]= butter(1,[fminn,fmaxn]);
Xb46=filtfilt(b,a,X);

for is=1:ns
%    pBr(is)=var(Xb46(:,is))/(var(X(:,is)-Xb46(:,is)));
    pBr(is)=varsc(Xb46(:,is),0,0)/(varsc(X(:,is)-Xb46(:,is),0,2));
    if(pBr(is)<=0), pBr(is)=1e-9; end
    if(isnan(pBr(is))), pBr(is)=1; end
    pBr(is)=log(pBr(is));
end
%-------------------------------------------------------------------------------

if(graph)
    figure, set(gcf,'Color','white');
    for is=1:ns,
        subplot(ns,1,is), hold on, plot(vtime,X(:,is),'r'), plot(vtime,Xb46(:,is),'b');
        wgmimaV=mimaxscG(Xb46(:,is),0,0,.4);
        ylim(wgmimaV);
        if(is~=ns), set(gca,'XTickLabel',''); end
        if(is==1), title([cName,': original(r) & filtered(b) ECG']); end
    end
    if(saveFig)
        figName=fullfile(figPath,[cName,'_DetrFilt']);
        print(gcf, ['-d',figFmt],figName);
    end
end

end %== function ================================================================
%

