% Coefficient of sample entropy (CoSEn)
% x       time series
% wlen    Window-length (or "dimension")
% r       tolerance for "similarity"
% shift   Spacing of valid samples
% ------------------------------------------
function CoSEn = CoSEn(x,wlen, r, shift)
if(nargin<4), shift=1; end 
if(nargin<3), r=0.03;  end 
if(nargin<2), wlen=1;  end 

SpEn = sampleEntropy(x,wlen,r,shift);

CoSEn=SpEn+log(2*r)-log(mean(x));

if(isinf(CoSEn)), CoSEn=1; end     % toppa MV
if(isnan(CoSEn)), CoSEn=0; end     % toppa MV
end
