% -------------------------------------------------------------------------------------------------
% function [AtypBeatPr,AtypBeatPrk1] = AtypBeatDetPr(qrsPs,QRSwidths, wLens)
%   Input parameters:
%    qrsPs       : array of pointers to QRS complexes (seconds)
%    QRSwidths   : array of estimated QRS widths
%    wLens       : 
%
%   Ouput parameters:
%   AtypBeatPr    :
%   AtypBeatPrk1  :
% -------------------------------------------------------------------------------------------------
%   Maurizio Varanini,  Clinical Physiology Institute, CNR, Pisa, Italy
%   For any comment or bug report, please send e-mail to: maurizio.varanini@ifc.cnr.it
% -------------------------------------------------------------------------------------------------


function [AtypBeatPr,AtypBeatPrk1] = AtypBeatDetPr(qrsPs,QRSwidths, wLens)
nQRS=length(qrsPs);
if(nQRS<5)
    AtypBeatPr= NaN;
    AtypBeatPrk1= NaN;
    return;
end
% Build RR-interval series
RRs=diff(qrsPs);  RRs=[RRs(1);RRs;RRs(end)];

RRwi = meanWsc(RRs, 5, 1, 1);
[QRSwmean,QRSwstdc]=meanstdsc(QRSwidths,2,2);
QRSwidthwi = meanWsc(QRSwidths, 5, 1,2);
AtypBeatPrv=ones(nQRS,1); AtypBeatPrkv=ones(nQRS,1);
for i=1:nQRS
    Qprei=RRs(i)/RRwi(i);
    QRSwidthr=QRSwidths(i)/QRSwidthwi(i);
    AtypBeatPrv(i)=QRSwidthr/Qprei;
    Qpreki=RRs(i)/RRs(i+1);
    AtypBeatPrkv(i)=QRSwidthr/Qpreki;
end
AtypBeatPrvl=sort(log(AtypBeatPrv),'descend');
AtypBeatPrkvl=sort(log(AtypBeatPrkv),'descend');
nQm=min(5,nQRS);
AtypBeatPr=mean(AtypBeatPrvl(1:nQm));
AtypBeatPrk1=mean(AtypBeatPrkvl(1:nQm));
