% This script will verify that your code is working as you intended, by
% running it on a small subset (300 records) of the training data, then
% comparing the answers.txt file that you submit with your entry with
% answers produced by your code running in our test environment using
% the same records.
%
% In order to run this script, you should have downloaded and extracted
% the validation set into the directory containing this file.
%
%
% Written by: Chengyu Liu and Qiao Li January 20 2017 
%             chengyu.liu@emory.edu  qiao.li@emory.edu
%
% Last modified by:
%
%

clear all;
close all;
clc

data_dir = [pwd filesep 'validation' filesep];

%% Add this directory to the MATLAB path.
addpath(pwd)

%% Load the list of records in the validation set.
fid = fopen([data_dir 'RECORDS'],'r');
if(fid ~= -1)
    RECLIST = textscan(fid,'%s');
else
    error(['Could not open ' data_dir 'RECORDS for scoring. Exiting...'])
end
fclose(fid);
RECORDS = RECLIST{1};

%% Running on the validation set and obtain the score results
classifyResult = zeros(length(RECORDS),1);
% RRm = zeros(length(RECORDS),1);
% RRv = zeros(length(RECORDS),1);
% g = zeros(length(RECORDS),1);
% N_QRS = zeros(length(RECORDS),1);
% AFEv = zeros(length(RECORDS),1);
% mean_var_P = zeros(length(RECORDS),1);

total_time     = 0;

%iniciar totales
RRm_total=[];
RRv_total=[];
g_total=[];
N_QRS_total=[];
AFEv_total=[];
Pxx_max=[];
mean_var_P=[];

% fid=fopen('answers.txt','wt');
for i = 1:length(RECORDS)
    fname = RECORDS{i};
    tic;
%     [classifyResult(i),RRm(i),RRv(i),g(i),N_QRS(i),AFEv(i),mean_var_P(i)]= challenge_4([data_dir fname]);
[classifyResult(i),g(i),N_QRS(i),AFEv(i)]= challenge_4([data_dir fname]);
    
%     if isempty(RRm(i))  
%     else
%         RRm_total=[RRm_total; RRm(i)];
%     end
% RRm_media=mean(RRm_total)
% RRm_std=std(RRm_total)
%     
%  if isempty(RRv(i))  
%     else
%         RRv_total=[RRv_total; RRv(i)];
%  end
% RRv_media=mean(RRv_total)
% RRv_std=std(RRv_total)

 if isempty(g(i))  
    else
        g_total=[g_total; g(i)];
 end
g_media=mean(g_total)
g_std=std(g_total)

 if isempty(N_QRS(i))  
    else
        N_QRS_total=[N_QRS_total; N_QRS(i)];
 end
N_QRS_media=mean(N_QRS_total)
N_QRS_std=std(N_QRS_total)

 if isempty(AFEv(i))  
    else
        AFEv_total=[AFEv_total; AFEv(i)];
 end
AFEv_media=mean(AFEv_total)
AFEv_std=std(AFEv_total)

%  if isempty(mean_var_P(i))  
%     else
%         mean_var_P_total=[mean_var_P_total; mean_var_P(i)];
%  end
% mean_var_P_media=mean(mean_var_P_total)
% mean_var_P_std=std(mean_var_P_total)




%     % write the answer to answers.txt file
%     fprintf(fid,'%s,%s\n',RECORDS{i},classifyResult(i));

    total_time = total_time+toc;
    fprintf(['---Processed ' num2str(i) ' out of ' num2str(length(RECORDS)) ' records.\n'])
end
