function [indP,ISOamp, tm, signalfilt,mean_asimetria,mean_coef_kurtosis,media_var_p]=pwaves_7(tm,signal,QRSref2,fs,v_ant,v_pos)
  

% indP: instante de tiempo en el que se ha localizado el valor mximo en la
        % onda P, es decir, en la ventana (indR-275ms:indR-90ms) (expresado en muestras)
% indR: instante de tiempo en el que se ha localizado la onda R (expresado
        % en muestras)
% ISOamp: la amplitud de la lnea isoelctrica de cada latido cardiaco
% beat (701xN): los N latidos identificados en el registro extendiendo de 275 ms antes al 425 ms despus de cada latido. 
        % Cada columna de la variable corresponde a un latido cardiaco. La
        % matriz tiene una dimensin de 701xN
% tm:  vector de tiempo
% signalfilt: seal ECG filtrada paso bajo 35 Hz

close all;

% filtro paso bajo en 35 Hz
[b,a]=butter(5,35*2/fs,'low'); 
signal=filtfilt(b,a,signal);


% intervalo de tiempo mnimo entre la onda P y la onda R

pw=[];
iso=[];

duracion_PW=(12/100)*fs;
ini_QRS=QRSref2-v_ant;
ini=1;
fin=length(ini_QRS);
 if (ini_QRS(ini)-duracion_PW)<1
% La ventana hacia atrs del primer latido est fuera de la ventana de
% anlisis
         ini=ini+1;
         %disp('primer if')
         %disp('hola')
 end
 
for i=ini:length(QRSref2)
    fin=ini_QRS(i);
    ini=ini_QRS(i)-duracion_PW;
    eval=signal(ini:fin);
    [maximo,indice]=max(eval);%Hacemosvalor absolut por si esta invertido
    
    indice_s=(ini+indice)-1;
    if indice_s==1 && signal(indice_s)>signal(indice_s+1) 
       isoelectric=prctile(eval,25);
        pw=[pw; indice_s];
        iso=[iso;isoelectric]; 
    elseif signal(indice_s)>signal(indice_s+1) && signal(indice_s)>signal(indice_s-1)
        isoelectric=prctile(eval,25);
        pw=[pw; indice_s];
        iso=[iso;isoelectric];
    end
  


%variables de salida
indP=pw;
ISOamp=iso;
signalfilt=signal;

% Eliminar algunos picos
p_amp=signal(pw)-iso;

pw_v=[];
iso_v=[];

for i=1:length(p_amp)
    % Eliminando aquellas que se difiere demasiado al valor mediana 
    if p_amp(i)<=0.25 && p_amp(i)>0
       pw_v=[pw_v;pw(i)]; 
    
       iso_v=[iso_v;iso(i)];
    end
end

% variables de salida
indP=pw_v;
ISOamp=iso_v;
signalfilt=signal;


end
if isempty(indP)|| length(indP)==1
    coef_kurtosis=0;
    asimetria=0;
    varianza=0;
    
else  
    ini=duracion_PW/2;
    fin=ini-1;
    a=1;
  if (indP(a)-ini)<1
% La ventana hacia atrs del primer latido est fuera de la ventana de
% anlisis
         a=a+1;
    
 end
    
for i=a:length(indP)


    Pwaves(i,:)=signal((indP(i)-ini):(indP(i)+fin));
    coef_kurtosis(i)=kurtosis(Pwaves(i,:));
    varianza(i)=var(Pwaves(:));
    asimetria(i)=skewness(Pwaves(:));
    %coef_kurtosis=[coef_kurtosis;coef_kurtosis(i)];
    %varianza=[varianza;varianza(i)];
    %asimetria=[asimetria;asimetria(i)];
end

%          
%    coef_kurtosis
%    varianza
%    asimetria
end
 mean_asimetria=mean(asimetria);
 mean_coef_kurtosis=mean(coef_kurtosis);
 media_var_p=mean(varianza);
end