function mostrarRegistro(datos)
% mostrarRegistro(ECG)
%
% Esta funcin muestra las seales y marcas asociadas a un registro. Si no
% se le pasan parmetros de entrada se abre un cuadro de dilogo para la
% seleccin del archivo.
%
% INPUTS:
%
% ECG es un STRUCT con los siguientes campos:
%   senyal [matriz]:   derivaciones organizadas en filas
%   fs:                Frecuencia de muestreo (por defecto 360Hz).
%   R:                 Vector con las posiciones de los complejos QRS.
%   tipoQRS:           Indica el tipo de complejo en cada posicin

signals = datos.senyal;
n = [];
fs = datos.fs;
pos = datos.R;
tipo = datos.tipoQRS;

n_signals=size(signals,1);
n_pos=length(pos);
n_tipo=length(tipo);
t=(0:1/fs:(size(signals,2)-1)/fs);

if ~isempty(n)
    plot(t,signals(n,:),'k');
    hold on
    if ~isempty(pos)
        plot(t(pos),signals(n,pos),'*r','MarkerSize',10);
    end
    if ~isempty(tipo)
        for j=1:n_tipo
            M=max(signals(n,max(1,pos(j)-25):min(pos(j)+25,size(signals,2))));
            text(t(pos(j))-0.2,1.1*M,tipo(j),'FontName','Times New Roman','FontSize',10)
        end
    end
    hold off
    xlim([0 t(end)]);
    xlabel('Time [s]','FontName','Times New Roman','FontSize',15);
    
else
    for i=1:n_signals
        subplot(n_signals,1,i);
        plot(t,signals(i,:)); 
        M=max(signals(i,:)); %max(1,pos(j)-25):min(pos(j)+25,size(signals,2))))
        v = axis; v(4) = 1.3*M; axis(v);
        hold on
        if ~isempty(pos)
            plot(t(pos),signals(i,pos),'or');
            
        end
        if ~isempty(tipo)
            for j=1:n_tipo
                
               % text(t(pos(j))-0.2,1.1*M,tipo(j),'FontName','Times New Roman','FontSize',10)
               
               text(t(pos(j))-0.2,1.1*M,tipo(j),'FontName','Times New Roman','FontSize',10)
            end
        end
        hold off
        xlim([0 t(end)]);
     end
     xlabel('Time [s]','FontName','Times New Roman','FontSize',15);
end
end

