function ECG = leedatos(fpath)
%ECG = leedatos(fpath)
%
%  Parmetro de entrada:
%       fpath [string]:  'path' de un fichero o carpeta
%
%  Parmetro de salida:
%
%   ECG: struct con los siguientes campos:
%       senyal[matriz]:       derivaciones organizadas en filas
%       fs:                   frecuencia de muestreo
%       R [vector]:           posiciones de los latidos
%       tipoQRS[vector char]: tipo de latido
%       tipo_dominante:       tipo de latido dominante
%       non_beat_ann[vector]: anotaciones distintas a latidos
%       pos_non_beat:         posiciones de anotaciones distintas a latidos
%       nombre:               identificador del ECG (nombre del archivo)
%       filtrado [cell]:      indica la frecuencia de corte de filtro paso alto, filtro paso bajo y notch [vaco]             






[ecg,fs,n_signals,fname,fpath]=leedat(fpath);



fichero = [fpath fname(1:end-4)];

[pos,tipo,pos_non_beat,non_beat_ann] = lee_anotaciones(fichero);

ECG.senyal = ecg;
ECG.R = pos;
ECG.pos_non_beat = pos_non_beat(2:end);
ECG.non_beat_ann = non_beat_ann(2:end);
ECG.tipoQRS= char(tipo);
ECG.nombre = fname;
ECG.fs = fs;
ECG.filtrado{1}{1} = 'Frecuencia corte inferior'; ECG.filtrado{1}{2} = [];
ECG.filtrado{2}{1} = 'Frecuencia filtro notch'; ECG.filtrado{2}{2} = [];
ECG.filtrado{3}{1} = 'Frecuencia corte superior'; ECG.filtrado{3}{2} = [];
ECG.tipo_dominante = char(mode(double(ECG.tipoQRS)));

%cd(path_actual);
