function  [pos,desc,pos_non_beat,non_beat_ann]=lee_anotaciones(nombre)
% 
% [pos,tipo]=lee_anotaciones(path)
%
% Esta funcin lee el archivo .atr asociado a un determinado fichero .dat
% Como argumento se le pasa el nombre del sichero sin extensin
% pos  = Posicion de los complejos
% tipo = Tipo de los complejos

%variable globales
%nombre=sprintf('%s.atr',nombre);
pos=[];
tipo = [];
desc={};
notQRS = [];

nombre=sprintf('%s.atr',nombre);

if exist(nombre,'file')
   fid=fopen(nombre,'r');
else
   errordlg('No se pudo encontrar el fichero .ATR','Error');
   return;
end


%Creamos una tabla con los datos que necesitaremos ms adelante
indice=[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,16,18,19,20,21,22,23,25,26,28,30,31,...
      32,33,34,35,37,38,39,40,41];
clase={'0','N','L','R','a','V','F','J','A','S','E','j','P','Q','~','|','s','T','*',...
      'D','"','=','B','^','C','?','!','[',']','a','n','x','f','`','','r'};

non_beat_annotations = '0[!]x()ptu`^|~+sT*D="@';
%Variable de control
i=1;%Variable contador
ant=0;%Variable auxiliar que contiene el valor de 'pos' anterior
c2=1;

%Bucle que recupera los datos
while c2~=0  %~feof(fid)
   
   %Leemos un par de bytes
   c1=fread(fid,1,'ubit10')+ant;
   c2=fread(fid,1,'ubit6');
   
   %Comprobamos si es latido o cambio de ritmo
   if c2==28 %Cambio de ritmo
      %Incluimos el cambio de ritmo
      
      pos(i)=c1;
      tipo(i) = c2;
      desc(i)=clase(find(indice==c2));
		%Ponemos el nuevo ritmo
      x=fread(fid,2,'uchar');
      s=fread(fid,4,'uchar');
      a1=char(s)'; 
      a2=char(clase(find(indice==c2)));
      cadena=[a2,a1];
      desc(i)=cellstr('+');
      
%   elseif c2==14 %Ruido
%      x=fread(fid,2,'uchar');
%     notQRS = [notQRS i];
   elseif c2==61
      i=i-1;
   elseif c2==0
      i=i-1;
   else %Latidos
      pos(i)=c1;
      tipo(i) = c2;
      desc(i)=clase(find(indice==c2));
   end
   if ~isempty(find(non_beat_annotations==char(desc(i)))) notQRS = [notQRS i]; end;
   ant=pos(i);
   i=i+1;
end
pos_non_beat = pos(notQRS);
non_beat_ann = desc(notQRS);
pos(notQRS) = [];
desc(notQRS) = [];
tipo(notQRS) = [];

fclose(fid); 