function [out, rank] = fscore(data,tags)

% function [out, rank] = fscore(data,tags)
%
% Calculate the Fisher scores
% Uses: 
%
% Inputs_
%       data : data matrix NxD (row: cases, column: variables),
%       tags : label column vector Nx1.
% 
% Outputs_
%       out : vector of scores for each variable Dx1
%       rank: vector with the order of variable importance
%
% Fisher score: 
% Used as a feature extractor for classification problems.
% The Fisher score gives higher value to the variables wich best discriminate among the classes. 
%
% Example of use:
%
% load iris.dat
% trdata = iris([1:40 51:90 101:140], 1:4); 
% trtags = iris([1:40 51:90 101:140], 5);
% out = fscore(trdata,trtags)
%
% Contact: Salvador Tortajada, vesaltor (at) upv.es
%

nclas = size(unique(tags),1);           % number of classes
[~,nvar] = size(data);                  % number of variables

scores = zeros(nvar,1);

for j=1:nvar
    den = 0;
    num = 0;
    mj = mean(data(:,j));               % global mean of variable j 

    for c=1:nclas
        Nc = size(tags==c);             % number of cases for class c
        mjc = mean(data(tags==c,j));    % mean of variable j for class c
        sjc = var(data(tags==c,j));     % variance of variable j for class c
        den = den + (Nc*sjc);           % denominator of Fisher's score
        num = num + (Nc*(mjc - mj)^2);  % numerator of Fisher's score
    end

    scores(j)= num/den;                 % Fisher's score for each variable j
end

out = scores;
[~, rank] = sort(out,'decend');