function [Mean_tr,Coefs_tr, Num_PCA,CM_total,BAR_total,ERR]=experiment(dataset,clase)

%% Definimos el tipo de particin de los datos que vamos a utilizar para
%Clase=reference
%dataset=caractersticas
%evaluar el modelo
K=10;
CVO = cvpartition(clase,'k',K);
%tags(strcmp(species(:),'setosa'))=1;
%% Hacemos un bucle para evaluar cada unos de los bloques en los que hemos separado los datos    
for t=1:K
    
    
    %% SEPARACION DE CASOS DE TRAIN Y TEST
    %Para ese bucle definimos los datos que vamos a utilizar para entrenar
    %y para evaluar
    Train_set=dataset(CVO.training(t),:);
    Test_set=dataset(CVO.test(t),:);
    Train_labels=clase(CVO.training(t));
    Test_labels=clase(CVO.test(t));
    
    %% REDUCCIN DEL NMERO DE VARIABLES
    %Aplicamos un mtodo de seleccin/extraccin de caracteristicas (fscore, relieff, PCA, etc...)
    Num_PCA=1;
    [Mean_tr,Scores_tr,Coefs_tr]=PCA_train(Train_set);
    Train_set_red=Scores_tr(:,1:Num_PCA);
    [Mean_tr,Scores_te]=PCA_test(Mean_tr,Coefs_tr,Test_set);
    Test_set_red=Scores_te(:,1:Num_PCA);
    
   
    %% GENERACIN DEL MODELO DE CLASIFICACIN Y APLICACIN A LAS MUESTRAS DE TEST
    % Entrenamos un clasificador con los casos de train (LDA, QDA, Knn, ANNs, etc..)
    typedis=2; % 1= LDA 2= QDA
    %[Disc_Mdl]=Discriminant_train(Train_set_red,Train_labels,typedis);
    
    k=8
    [Pred_labels]=knnclassify(Test_set_red,Train_set_red,Train_labels,k);
    
    % Aplicamos el modelo entrenado para predecir la clase de las muestras
    % de test
   %[Pred_labels]=Discriminant_test(Disc_Mdl,Test_set_red);
    
%     if Num_PCA==2
%     %% PLOTEAMOS LAS FRONTERAS DE DECISIN SOBRE EL ESPACIO MOSTRAL
%     %Pintamos las fronteras de clasificacin en 2D (DAR ERROR SI
%     %UTILIZAMOS MS DE 2 VARIABLES!!!) En caso de utilizar mas de dos
% %     %variables comentar el bloque entero
%    
%     %Sampleamos las primeras dimensiones de todo el espacio mostra
%     sampling=300;
%     alldata=[Train_set_red;Test_set_red];
%     [X,Y] = meshgrid(linspace(min(alldata(:,1)),max(alldata(:,1)),sampling),linspace(min(alldata(:,1)),max(alldata(:,2)),sampling));
%     X_v=reshape(X,1,sampling^2)';
%     Y_v=reshape(Y,1,sampling^2)';
%     [Pred_labels_all]=Discriminant_test(Disc_Mdl,[X_v,Y_v]);
%     class_map=reshape(Pred_labels_all,sampling,sampling);
%     plot_decision(Train_set_red,Test_set_red, Train_labels,Pred_labels,class_map,X,Y);
%     
%     pause
%     end
    
    %% OBTENEMOS LAS MTRICAS DE EVALUACIN
    out=confusStats(Test_labels,Pred_labels);
    CM(t,:,:)=out.CM;
    BAR(t)=out.BAR;
    err(t)=out.err;
end

%% GENERAMOS LAS METRICAS PROMEDIO DEL MODELO
%Obtenemos la media de los errores para obtener una estimacin del error
%final del modelo

%CM_total=mean(CM,1)
CM_total=sum(CM,1)
BAR_total=mean(BAR);

ERR=mean(err)
end
    
    