function [latidos,QRS_v] = enventanaQRS(signal,QRSref,v_ant,v_pos)
%latidos = enventanaQRS(ECG,v_ant,v_pos);
%
% Esta funcin enventana cada QRS del ECG y los organiza en una matriz. En
% el caso de que no haya suficiente seal para enventanar el primer y/o
% ltimo latido, los elimina. Si hay suficiente seal, los mantiene
% igualmente
%
% Entradas:
%   ECG [struct tipo ECG]: requiere ECG.senyal; ECG.fs; ECG.R
%
% Entradas opcionales
%   v_ant:  ventana anterior al R en ms
%   v_pos:  ventana posterior al R en ms
%
% Salida:
%   latidos [matriz]: QRS extrados, organizados en filas


k=1; %para empezar en la primera fila de latidos a poner el QRS
ini=1; %valor por defecto del primer QRS que se coge
fin=length(QRSref); %nmero de latidos total
QRSref;
ini;
%Cogemos primer R que sea mayor que v_ant
while QRSref(ini) <= v_ant
    ini=ini+1; %cogemos el siguiente latido
end

%Cogemos primer R (por detrs) cuya ventana no sobresalga
while QRSref(fin)+v_pos > length(signal) 
    fin=fin-1; %cogemos el penltimo latido, y as sucesivamente.
end

QRS_v=[];

for i = ini:fin %ventana
    %cogemos de la seal el QRS enventanado 
    latidos(k,:)= signal(QRSref(i)-v_ant : QRSref(i)+v_pos);  
    k=k+1; %para ir escribiendo en cada fila cada QRS
    QRS_v=[QRS_v QRSref(i)];
end
end
