function [classifyResult]= challenge_16(recordName)
%
% Sample entry for the 2017 PhysioNet/CinC Challenge.
%
% INPUTS:
% recordName: string specifying the record name to process
%
% OUTPUTS:
% classifyResult: integer value where
%                     N = normal rhythm
%                     A = AF
%                     O = other rhythm
%                     ~ = noisy recording (poor signal quality)
%1.1 Inicializacin de variables.
 g=[];
 N_QRS=[];
 AFEv=[];
 mean_var_P=[];
%1.2 Cargamos parametros necesarios para los modelos de clasificacin 
  %Modelo 1 ruido de N,FA,OTROS
  load Mean_tr.mat
  load Coefs_tr.mat
  load Num_PCA.mat
  load Disc_Mdl.mat
  %Modelo 2 N de FA y OTROS
  load Mean_tr2.mat
  load Coefs_tr2.mat
  load Num_PCA2.mat
  load Disc_Mdl2.mat
  %Modelo 3 N de FA
  load Mean_tr3.mat
  load Coefs_tr3.mat
  load Num_PCA3.mat
  load Disc_Mdl3.mat
  %Modelo 4 N y OTROS
  load Mean_tr12.mat
  load Coefs_tr12.mat
  load Num_PCA12.mat
  load Disc_Mdl12.mat
  %Modelo 5 FA y OTROS
  load Mean_tr5.mat
  load Coefs_tr5.mat
  load Num_PCA5.mat
  load Disc_Mdl5.mat
  %MModelo 6 FA de NORMAL y OTROS
  load Mean_tr6.mat
  load Coefs_tr6.mat
  load Num_PCA6.mat
  load Disc_Mdl6.mat
%Empezamos la clasificacin y suponemos que cada registros es por defecto N
 classifyResult = 'N'; % default output normal rhythm
%2.Lectura,filtrado,deteccin QRS y refinado,deteccin de P y obtencin de otras caractersticas 
 %2.1 Lectura de la seal y filtrado de componentes de baja frecuencia 
 [tm,signal1,fs,siginfo]=rdmat(recordName);
 %=============Filtro de componentes de baja frecuencia====================
 Wn=(1/fs);
 [b,a] = butter(4,Wn,'high');
 signal = filtfilt(b,a,signal1);
 %=========================================================================
 %2.2 Deteccin de QRS e inversin de la seal si los detecta en negativo 
 [QRS,sign,en_thres] = qrs_detect2(signal',0.25,0.6,fs);
 if isempty(QRS)
      classifyResult = '~';
 else
 %Invierte seal en el caso de que los picos R sean negativos
    for i=1:length(QRS)
        valorQRS(i)=signal(QRS(i));
    end
    media_valores_QRS=mean(valorQRS);
    if media_valores_QRS<0
       signal=signal.*-1;
    end
 %2.3 Refinamos QRS para obtener bien localizados los picos R
 v_ant_ref=4;
 v_pos_ref=4;
 QRSref = refinarQRS(signal,QRS,v_ant_ref,v_pos_ref);
 QRSref2 = refinarQRS_2(signal,QRSref); %Eliminar ondas R =/ a la media
 
 %2.4 Obtenemos parametros del dominio de la frecuencia para toda la seal
 %Calculamos DEP de todos los registros
 window=1200; %4 seg porque las seales suelen ser de 10 seg. 
 %Hay que llegar a un compromiso entre una ventana pequea que se
 %ajusta ms y una grande que da mucha variedad de frecuencias
 [Pxx1,F]=pwelch(signal,window,window*0.5,window,fs);
 [C,I] = max(Pxx1);
 fmax=F(I);
%==========================================================================
%3.Clasificamos como RUIDO sino detecta ningn QRS refinado o pocos(escogemos valor de 3) 
if length(QRSref2)<6 ||isempty(QRSref2) %mirar registro 8485 del training
        classifyResult = '~'; %noisy
else %Seguiran pasando RUIDO que tengan "QRS">3, N, FA y OTROS
 %3.1 Aplicamos modelo para clasificar ms ruido (QRS>3)   
 %Necesitamos media y varianza de la amplitud de la seal
 media_amplitud=mean(signal);
 varianza_amplitud=var(signal);
 %Creamos test_set para aplicar modelo 1
 Test_set_1 =[media_amplitud,varianza_amplitud];
 %Aplicamos modelo
 [Pred_labels]=ruidotest(Mean_tr,Coefs_tr, Num_PCA,Disc_Mdl,Test_set_1);
 %Con los resultados hacemos clasificacin
 if Pred_labels==2
    classifyResult = '~';%Noisy
 else %Seguirn pasando N,AF,O (poco ruido)
 %Aplicaremos un modelo que nos permita diferenciar N del resto
 %Para ello necesitamos g que indica el numero de patrones significativos y 
 %relacion_complejos_P   
  %g
  v_ant=15; v_pos=105; 
  
  [latidos,QRS_v] = enventanaQRS(signal,QRSref2,v_ant,(v_pos-78));%27 muestras
  [tipo_QRS,patrones,num_complejos,N_QRS] = ClasificaComplejos(latidos);
  g=PatronesSignificativos(num_complejos,N_QRS);
  %Quitamos algo de ruido %%cambiar de posicin si falla
  if g==0 
     classifyResult = '~'; %noisy
  else
  %relacion_complejos_P 
  %necesitamos calcular nmero de ondas P y nmero de complejos QRS
    [indP,ISOamp, tm, signalfilt,mean_asimetria,mean_coef_kurtosis,media_var_p]=pwaves_7(tm,signal,QRSref2,fs,v_ant,v_pos);
    n_ondap=length(indP);
    n_complejos=N_QRS;
  %obtenemos relacion_complejos_P
    if 0.85*n_complejos<n_ondap && n_ondap<1.15*n_complejos
        relacion_complejos_P=1;%mismo numero de P y QRS pero estamos dando una tolerancia
    else
        relacion_complejos_P=0;
    end
    
  %Calculamos RR  
     RR=diff(QRSref2')/fs; %muestras entre muestras por tiempo te da la RR en s
     %diff: resta elementos entre s, disminuye en uno el vector
     size(RR);
     RRm=mean(RR);%1.1
     RRv=var(RR);%1.2  
  %Creamos test_set_2 y  aplicamos modelo 2
  Test_set_2=[relacion_complejos_P,g];
  %Con el resultado clasificamos
  [Pred_labels2]=normaltest(Mean_tr2,Coefs_tr2,Num_PCA2,Disc_Mdl2,Test_set_2);
  if Pred_labels2==1  
       
       if RRv<1.0000e-04
       freccardiaca = frec_cardiaca( QRS_v,signal,fs );
            if freccardiaca<61 || freccardiaca>99 
            classifyResult = 'O';

            end 
       else 
           classifyResult = 'N';
           recordName;
           inte=cumsum(Pxx1);
       end
       

  else %Pasarn A y OTROS y algunos N (poco)
     %Aplicamos AFEV
     
     AFEv = comput_AFEv(RR);
     %Para las siguientes clasificaciones usaremos un modelos quenecesita
     %fmaxfibrilatoria la calculamos aqui
     %Necesitamos fmaxfibrilaoria
     
     v_ant=15; v_pos=105; 
            [latidos,QRS_v] = enventanaQRS(signal,QRSref2,v_ant,(v_pos));%27 muestras
            [onda_fibrilatoria, fmaxfibrilatoria ] = onfa_f( latidos, QRS_v , signal,fs,v_ant, v_pos);
     
     if AFEv>1 %Pasarn en su mayora A, pero tambin pocas O y N que debemos detectar
     
    
       classifyResult = 'A';%Por defecto decimos que es A pero vamos a
          
        
        Test_set_3=[relacion_complejos_P,mean_coef_kurtosis,media_var_p];
        Test_set_5=[fmaxfibrilatoria,mean_asimetria,varianza_amplitud];
        %[classifyResult]=ausenciaP(indP,signal, Test_set_5, Test_set_3);
        [classifyResult]=detecFA(mean_coef_kurtosis,Test_set_5, Test_set_3);

    else %Pasarn en su mayora O y N, pero tambin pocas A 
    

  %============================================================challenge_16_2
         %Aplicamos modelos 4
         Test_set_4=[fmax',mean_coef_kurtosis'];
         [Pred_labels4]=normalotrostest(Mean_tr12,Coefs_tr12, Num_PCA12,Disc_Mdl12,Test_set_4); 
         Test_set_5=[fmaxfibrilatoria,mean_asimetria,varianza_amplitud];
         [Pred_labels5]=faotrostest(Mean_tr5,Coefs_tr5, Num_PCA5,Disc_Mdl5,Test_set_5);
         
         if Pred_labels4==2 && Pred_labels5==2         
          classifyResult = 'O';
         else 
          %classifyResult = 'O';
          Test_set_3=[relacion_complejos_P,mean_coef_kurtosis,media_var_p];
          [Pred_labels3]=normalfatest(Mean_tr3,Coefs_tr3,Num_PCA3,Disc_Mdl3,Test_set_3);
          if Pred_labels3==2
             classifyResult = 'A';
          else
             classifyResult = 'N';
          end
         end
     end
  end
  end
 end
end
 end 
end
    
    
    
    
    
    
    
    
    
    
    
    
    
