function p = IdentificaPatron(patrones,QRS,umbral)
%   p = IdentificaPatron(patrones,QRS,umbral)
%
%   Esta funcin identifica el patrn al que corresponde un complejo QRS
%   dado. En el caso de que el QRS no corresponda a ningn tipo de patrn 
%   perteneciente al conjunto de patrones, la funcin devuelve p=0
%   
%   Parmetros de entrada
%       patrones [matriz]:   conjunto de patrones de QRS organizados en filas
%       QRS [vector]:        QRS actual 
%
%   Parmetro de entrada opcional:
%       umbral [real]:       umbral de correlacin para la comparacin de patrones (entre 0 y 1)
%   
%   Parmetro de salida
%       p [entero]:          ndice correspondiente al tipo de patrn identificado
%
%   

%si falta algn input de la funcin establecemos un umbral por defecto
if nargin < 3
    umbral=0.85;
end

%primer complejo QRS a clasificar
%si no existen patrones en el conjunto, devuelve p=0
if isempty (patrones)
   p=0; 
end

%inicializamos p
p=[];
%trasponemos el QRS y el conjunto de patrones para que sean columnas como
%pide la funcin corr
QRS=QRS';
patrones=patrones';
%sacamos N_patrones que es el nmero de patrones que llevamos hasta el
%momento
[N_filas,N_patrones]= size(patrones);

%clasificar el QRS segn la correlacin con cada patrn
for i=1:N_patrones %recorre todos los patrones del conjunto
    % si la correlacin del QRS con cada patrn supera el umbral se le
    % asigna p, el ndice correspondiente.
    if corr(QRS,patrones(:,i)) >= umbral
        p=i;
    end
end
%si no supera el umbral de correlacin con ninguno de los patrones
%existentes, p estar vaca y le asignaremos el valor 0 para que sea un
%nuevo patrn
if isempty (p)
    p=0;
end

