function [tipo_QRS,patrones,num_complejos,N_QRS] = ClasificaComplejos(latidos)
%[tipo_QRS,patrones,num_complejos] = ClasificaComplejos(QRS)
%
%Esta funcin clasifica una serie de complejos QRS en distintos patrones
%segn su morfologa. Para ello emplea el siguiente algoritmo: para cada
%QRS de la matriz de entrada, identifica el patrn correspondiente entre
%los patrones detectados hasta el momento. Si no se corresponde con ningn
%patrn conocido, entonces aade un nuevo patrn y lo asigna al QRS actual.
%En caso contrario, si efectivamente se encuentra entre los patrones
%existentes, actualiza el patrn correspondiente con el QRS actual. 
%
%   Entrada:
%       QRS [matriz]: secuencia de complejos QRS organizados en filas
%
%   Salida:
%       tipo_QRS [vector]:       clasificacin de cada complejo
%       patrones [matriz]:       conjunto de patrones detectados (en filas)
%       num_complejos [vector]:  nmero de complejos identificados de cada patrn
%
%   Llamadas a otras funciones:
%       IdentificaPatron


[N_QRS,N_col] = size(latidos);
patrones = [];
num_complejos = [];


for i=1:N_QRS %recorre todos los complejos que estaban en la matriz latidos
    QRS_actual = latidos(i,:); %hay uno en cada fila
    %llama a la funcin IdentificaPatron y devuelve el grupo al que
    %pertenece el QRS o si ha de ser un nuevo patrn (p=0)
    p = IdentificaPatron(patrones,QRS_actual);
    
    if p>0  % asigna patron a complejo y actualiza patron actual
        %guardamos en tipo_QRS el ndice del grupo al que pertenece el
        %QRS(i)
        tipo_QRS(i) = p;   
        %promedio: patrn del grupo, multiplicado por el nmero de complejos
        %que hay en ese grupo, ms QRS_actual entre el nmero de complejos
        %que haba ms el que se va a aadir (QRS_actual)
        patrones(p,:) = (patrones(p,:)*num_complejos(p)+QRS_actual)/(num_complejos(p)+1);
        %actualizar el valor del nmero de complejos de ese grupo (fila)
        %aade uno
        num_complejos(p) = num_complejos(p)+1;
    else    % p=0, crea nuevo patrn con el QRS y asigna patrn a complejo
        %aade el QRS (nuevo patrn) al conjunto de patrones
        patrones = [patrones; QRS_actual];
        %sacamos el nmero de patrones ahora que est el nuevo aadido
        [N_patrones,N_col] = size(patrones);
        %asignamos N_patrones como ndice del patrn nuevo
        %guardamos en tipo_QRS el ndice del grupo al que pertenece el
        %QRS(i)
        tipo_QRS(i) = N_patrones;
        %aade nueva fila a num_complejos que corresponder a ese nuevo
        %grupo, de momento solo hay un QRS
        num_complejos = [num_complejos; 1];
    end
    N_patrones;
    num_complejos; %%
    N_QRS; %%
end