function [Y,Xf,Af] =classific2(X,~,~)
%MYNEURALNETWORKFUNCTION neural network simulation function.
%
% Generated by Neural Network Toolbox function genFunction, 23-May-2017 13:40:35.
%
% [Y] = myNeuralNetworkFunction(X,~,~) takes these arguments:
%
%   X = 1xTS cell, 1 inputs over TS timesteps
%   Each X{1,ts} = Qx6 matrix, input #1 at timestep ts.
%
% and returns:
%   Y = 1xTS cell of 1 outputs over TS timesteps.
%   Each Y{1,ts} = Qx4 matrix, output #1 at timestep ts.
%
% where Q is number of samples (or series) and TS is the number of timesteps.

%#ok<*RPMT0>

% ===== NEURAL NETWORK CONSTANTS =====

% Input 1
x1_step1.xoffset = [0;-34;1.404;0.259;-4.74329272705041;-1.11581521167115];
x1_step1.gain = [2.09505352935438;0.0263157894736842;1.75284837861525;1.92678227360308;0.353474570288734;0.293333382441567];
x1_step1.ymin = -1;

% Layer 1
b1 = [1.9415021331420002;1.3145698652977369;-0.33852875425798179;1.0734534242375515;-1.6873697486360169;0.57213575566491315;0.29696488839314045;-0.3747876168501062;0.39170750859963743;2.0491678472333121];
IW1_1 = [-0.24171638020021355 -1.085846762565299 0.74165544953700968 -0.715538119509043 -1.0611696094104275 -0.84216030100077133;-0.26248752420187371 1.7417283732510838 1.036839381711028 2.340244572754079 -0.65607721375499006 -1.1199808484455411;0.32893701201795289 2.3484389563443981 0.094535901155942126 -1.2803721273245257 0.52466561163072356 0.049323273520154177;-0.75837864962501533 -1.056383618313707 1.2027551462161157 0.19607475063595506 -0.18644115249648291 -0.95534542226221675;1.5591900425880671 -0.94076340747256593 -0.064679862823594322 1.0199175422652094 -0.70996289233936394 -0.18261788770234319;1.7637593494646697 0.30138636305960187 -1.1533885984485468 -1.2214437675839849 -0.15800959982380275 0.40316076945797763;-0.073916894820986401 1.9517027896396861 -0.19998653635654706 1.5642568016386169 -1.3175704541658049 0.13257828160270343;-0.61155250962074836 -0.041510487472047455 -0.52218845636759781 -2.1977790628043499 0.26065207722481948 -0.28965898621769942;-0.23067638032216742 -1.4228683814867762 -0.46216151716648723 -3.0437819740074032 0.80895974315829111 -0.9031144339350986;0.4318091599651615 1.2911639494023268 0.748662198872179 -0.20843832507750509 -0.46776579599700518 -1.2523843583203171];

% Layer 2
b2 = [-0.88227407213670939;-1.3425652720800798;0.49395728590989485;0.0076804658483422029];
LW2_1 = [0.90190011548707627 1.8960332798737818 -1.871200496111713 0.043941793378089448 1.7996102475142328 -0.53221113094764871 -0.53886473342599273 -1.7307949675613474 1.6480917072037355 0.39303743247909545;-0.7614213602921569 0.27227894576181078 0.36052554839377338 0.66423613599343478 -1.5655143617424727 0.88852868303935351 2.0771381998102112 -0.0080352394126096821 0.16733308805594066 -0.5037949046830682;0.87545022133489037 -1.0099628583277567 -1.2860095495218526 0.93958540491329523 0.13853419215976048 0.41698254295983478 -0.98305917661699682 0.13318305409878048 -1.0329019393070256 0.55510116721486358;-0.022276245327334247 -0.2266049168903034 1.106656153494034 -1.2193915915464824 -0.43707421531108293 -0.4897078051147441 -0.23726511889412988 0.69450996175419311 -0.66501272419898827 0.49920805313369604];

% ===== SIMULATION ========

% Format Input Arguments
isCellX = iscell(X);
if ~isCellX
    X = {X};
end

% Dimensions
TS = size(X,2); % timesteps
if ~isempty(X)
    Q = size(X{1},1); % samples/series
else
    Q = 0;
end

% Allocate Outputs
Y = cell(1,TS);

% Time loop
for ts=1:TS
    
    % Input 1
    X{1,ts} = X{1,ts}';
    Xp1 = mapminmax_apply(X{1,ts},x1_step1);
    
    % Layer 1
    a1 = tansig_apply(repmat(b1,1,Q) + IW1_1*Xp1);
    
    % Layer 2
    a2 = softmax_apply(repmat(b2,1,Q) + LW2_1*a1);
    
    % Output 1
    Y{1,ts} = a2;
    Y{1,ts} = Y{1,ts}';
end

% Final Delay States
Xf = cell(1,0);
Af = cell(2,0);

% Format Output Arguments
if ~isCellX
    Y = cell2mat(Y);
end
end

% ===== MODULE FUNCTIONS ========

% Map Minimum and Maximum Input Processing Function
function y = mapminmax_apply(x,settings)
y = bsxfun(@minus,x,settings.xoffset);
y = bsxfun(@times,y,settings.gain);
y = bsxfun(@plus,y,settings.ymin);
end

% Competitive Soft Transfer Function
function a = softmax_apply(n,~)
if isa(n,'gpuArray')
    a = iSoftmaxApplyGPU(n);
else
    a = iSoftmaxApplyCPU(n);
end
end
function a = iSoftmaxApplyCPU(n)
nmax = max(n,[],1);
n = bsxfun(@minus,n,nmax);
numerator = exp(n);
denominator = sum(numerator,1);
denominator(denominator == 0) = 1;
a = bsxfun(@rdivide,numerator,denominator);
end
function a = iSoftmaxApplyGPU(n)
nmax = max(n,[],1);
numerator = arrayfun(@iSoftmaxApplyGPUHelper1,n,nmax);
denominator = sum(numerator,1);
a = arrayfun(@iSoftmaxApplyGPUHelper2,numerator,denominator);
end
function numerator = iSoftmaxApplyGPUHelper1(n,nmax)
numerator = exp(n - nmax);
end
function a = iSoftmaxApplyGPUHelper2(numerator,denominator)
if (denominator == 0)
    a = numerator;
else
    a = numerator ./ denominator;
end
end

% Sigmoid Symmetric Transfer Function
function a = tansig_apply(n,~)
a = 2 ./ (1 + exp(-2*n)) - 1;
end
