function [Y,Xf,Af] = classfic(X,~,~)
%MYNEURALNETWORKFUNCTION neural network simulation function.
%
% Generated by Neural Network Toolbox function genFunction, 23-May-2017 11:59:51.
%
% [Y] = myNeuralNetworkFunction(X,~,~) takes these arguments:
%
%   X = 1xTS cell, 1 inputs over TS timesteps
%   Each X{1,ts} = Qx4 matrix, input #1 at timestep ts.
%
% and returns:
%   Y = 1xTS cell of 1 outputs over TS timesteps.
%   Each Y{1,ts} = Qx4 matrix, output #1 at timestep ts.
%
% where Q is number of samples (or series) and TS is the number of timesteps.

%#ok<*RPMT0>

% ===== NEURAL NETWORK CONSTANTS =====

% Input 1
x1_step1.xoffset = [0;-34;1.404;0.259];
x1_step1.gain = [2.09505352935438;0.0263157894736842;1.75284837861525;1.92678227360308];
x1_step1.ymin = -1;

% Layer 1
b1 = [2.4192275199311011;-1.4501354364561829;-1.5332793705594132;0.74182841633799512;0.54417459172121452;-0.50385481200152116;-0.66067175662340105;1.5627519680399047;-1.6101711183109595;2.5720081691642731];
IW1_1 = [-0.054162071805921953 -1.0504909266041722 1.6086685222382269 1.6012565687370142;0.53867522294020265 1.5213890512649386 -1.456618859739206 1.5002121101404975;0.43511986238558992 -2.03209026892499 -0.061621920332609353 0.98386005444800184;-0.34207764874818886 -3.1135794696515129 -0.92515082805820081 0.69250620169638744;-1.5070837034033711 0.58062837737555983 0.79037696341141583 1.725981791463276;0.07246184098533523 -1.5733411402162714 1.7982802811145313 -1.3141529761970325;0.015966330895498287 -0.28816045356064901 -0.46667256633148729 -3.1276856704624891;0.71155571936163642 1.1010889553257668 1.9800475620982125 0.4728318936628077;-2.1143706379591634 1.5289046115214255 -0.64282658384903124 -0.3689527102608493;0.66181806548782307 0.8516112360387238 -1.4632383022565387 1.5911348065030504];

% Layer 2
b2 = [0.29749963443778465;0.34577626477082068;0.96475573423961203;-0.4422538493081965];
LW2_1 = [0.86448713394359877 -0.54909038995480863 0.62354997448742044 1.3560760913745151 -0.81409910932361229 1.0854162703905654 -1.9224466428977154 -0.19076639331756171 0.20821539095314384 -0.30644732496417332;-0.090135899952868928 0.75376284936614302 0.23450631391611684 -1.6334113040678193 0.096526614636408131 -1.1401961933413121 0.18618981923819614 -0.054756728912699899 -0.86645315854598381 -0.2578278859187183;0.73805957723133753 0.17583087312661555 0.77714564068451764 1.2857807371625114 -0.36662423877477424 -0.17669754016105144 0.43271488058620111 -0.12286520340442342 -0.84003374204954895 -0.19680221560224526;0.32416971440594078 1.1094035028814819 0.09654162191792226 -0.74083501521900585 -0.29459646891105656 -0.62285294265905311 1.2734311642627985 0.81071637267721153 0.36290113791446044 0.25025892166117603];

% ===== SIMULATION ========

% Format Input Arguments
isCellX = iscell(X);
if ~isCellX
    X = {X};
end

% Dimensions
TS = size(X,2); % timesteps
if ~isempty(X)
    Q = size(X{1},1); % samples/series
else
    Q = 0;
end

% Allocate Outputs
Y = cell(1,TS);

% Time loop
for ts=1:TS
    
    % Input 1
    X{1,ts} = X{1,ts}';
    Xp1 = mapminmax_apply(X{1,ts},x1_step1);
    
    % Layer 1
    a1 = tansig_apply(repmat(b1,1,Q) + IW1_1*Xp1);
    
    % Layer 2
    a2 = softmax_apply(repmat(b2,1,Q) + LW2_1*a1);
    
    % Output 1
    Y{1,ts} = a2;
    Y{1,ts} = Y{1,ts}';
end

% Final Delay States
Xf = cell(1,0);
Af = cell(2,0);

% Format Output Arguments
if ~isCellX
    Y = cell2mat(Y);
end
end

% ===== MODULE FUNCTIONS ========

% Map Minimum and Maximum Input Processing Function
function y = mapminmax_apply(x,settings)
y = bsxfun(@minus,x,settings.xoffset);
y = bsxfun(@times,y,settings.gain);
y = bsxfun(@plus,y,settings.ymin);
end

% Competitive Soft Transfer Function
function a = softmax_apply(n,~)
if isa(n,'gpuArray')
    a = iSoftmaxApplyGPU(n);
else
    a = iSoftmaxApplyCPU(n);
end
end
function a = iSoftmaxApplyCPU(n)
nmax = max(n,[],1);
n = bsxfun(@minus,n,nmax);
numerator = exp(n);
denominator = sum(numerator,1);
denominator(denominator == 0) = 1;
a = bsxfun(@rdivide,numerator,denominator);
end
function a = iSoftmaxApplyGPU(n)
nmax = max(n,[],1);
numerator = arrayfun(@iSoftmaxApplyGPUHelper1,n,nmax);
denominator = sum(numerator,1);
a = arrayfun(@iSoftmaxApplyGPUHelper2,numerator,denominator);
end
function numerator = iSoftmaxApplyGPUHelper1(n,nmax)
numerator = exp(n - nmax);
end
function a = iSoftmaxApplyGPUHelper2(numerator,denominator)
if (denominator == 0)
    a = numerator;
else
    a = numerator ./ denominator;
end
end

% Sigmoid Symmetric Transfer Function
function a = tansig_apply(n,~)
a = 2 ./ (1 + exp(-2*n)) - 1;
end
