function classifyResult= challenge(recordName,label)
%
% Sample entry for the 2017 PhysioNet/CinC Challenge.
%
% INPUTS:
% recordName: string specifying the record name to process
%
% OUTPUTS:
% classifyResult: integer value where
%                     N = normal rhythm
%                     A = AF
%                     O = other rhythm
%                     ~ = noisy recording (poor signal quality)
%
% To run your entry on the entire training set in a format that is
% compatible with PhysioNet's scoring enviroment, run the script
% generateValidationSet.m
%
% The challenge function requires that you have downloaded the challenge
% data 'training_set' in a subdirectory of the current directory.
%    http://physionet.org/physiobank/database/challenge/2017/
%
% This dataset is used by the generateValidationSet.m script to create
% the annotations on your training set that will be used to verify that
% your entry works properly in the PhysioNet testing environment.
%
%
% Version 1.0
%
%
% Written by: Chengyu Liu and Qiao Li January 20 2017
%             chengyu.liu@emory.edu  qiao.li@emory.edu
%
% Last modified by:
%
%

% classifyResult = 'N'; % default output normal rhythm

[tm,ecg,fs,siginfo]=rdmat(recordName);
ecg(ecg>0.5)=0.5;
ecg(ecg<-0.5)=-0.5;
ecg=denoise(ecg,fs);
 N=length(ecg);
 if N>14000
     ecg=ecg(4001:12000);
 end
 if N>10000&&N<=14000
     ecg=ecg(4001:end);
 end
 if N>8000&&N<=10000
     ecg=ecg(2001:8000);
 end
 if N<=8000&&N>5000
         ecg=ecg(1001:5000);
end    
 if N<5000
     ecg=ecg(1:end);
 end

[qrs_amp_raw,QRS,delay,ecg_s]=pt(ecg,fs,0);
P4mean=P4entropy(QRS,ecg,fs);
[signalqrs]= herpre(ecg,QRS,fs);
herimtec= hermitqrs(signalqrs,fs);
Pwave=Pwavecoif(QRS,ecg,fs);
RR=diff(QRS')/fs;
for i=1:length(RR)
   t(i)=sum(RR(1:i)); %time (s)
end    
ibi=[t;RR']';
[OriginCount,IrrEv,PACEv,AFEv]  = comput_AFEv(RR);

[Wave]=Waveform(ecg,QRS);
output = timeDomainHRV(ibi,4,50);
SDNN=output.SDNN;
SDANN=output.SDANN;
NNx=output.NNx;
pNNx=output.pNNx;
RMSSD=output.RMSSD;
SDNNi=output.SDNNi;
sdHR=output.sdHR;
deltRR=diff(RR);
rrtest=RR-mean(RR);
cv=std(deltRR)/mean(RR);
test_cdf = makedist('Normal','mu',0,'sigma',0.1612);
[h,p] = kstest(rrtest,'CDF',test_cdf);
p=-log(p);
InputRR=ibi(:,2).*1000;
alpha=DFA(InputRR,3,length(InputRR));
dfa=alpha.alpha;
dfa=sum(dfa);

HRVTi=output.HRVTi;
input=[Wave,OriginCount,IrrEv,PACEv,AFEv,SDNN,SDANN,NNx,pNNx,RMSSD,SDNNi,sdHR,HRVTi,P4mean,herimtec,Pwave,cv,p,dfa];
result=N628(input);
[c,classifyResultnum]=find(result==max(result));
if length(c)==0
    classifyResult='~';
else
switch classifyResultnum
    case 1
        classifyResult='N';
     case 2
        classifyResult='A';
     case 3
        classifyResult='O';
     case 4
        classifyResult='~';
end
end
end


%% You can add the determination rules for other rhythm and noisy recordings here

