function [Y,Xf,Af] = myNeuralNetworkFunction(X,~,~)
%MYNEURALNETWORKFUNCTION neural network simulation function.
%
% Generated by Neural Network Toolbox function genFunction, 25-May-2017 16:45:57.
%
% [Y] = myNeuralNetworkFunction(X,~,~) takes these arguments:
%
%   X = 1xTS cell, 1 inputs over TS timesteps
%   Each X{1,ts} = Qx10 matrix, input #1 at timestep ts.
%
% and returns:
%   Y = 1xTS cell of 1 outputs over TS timesteps.
%   Each Y{1,ts} = Qx4 matrix, output #1 at timestep ts.
%
% where Q is number of samples (or series) and TS is the number of timesteps.

%#ok<*RPMT0>

% ===== NEURAL NETWORK CONSTANTS =====

% Input 1
x1_step1.xoffset = [0;-34;0;0;0;0;2.6;0;0;1];
x1_step1.gain = [2.09505352935438;0.0263157894736842;0.000738089087352844;0.000903097624853247;0.0476190476190476;0.02;0.00053475935828877;0.000332684598366519;0.0102249488752556;0.142857142857143];
x1_step1.ymin = -1;

% Layer 1
b1 = [1.6775018018069476;-1.3903480351370776;-1.2711187106765276;-0.77728956668867766;-0.25911609999007779;0.63623881288889783;0.3439793210262635;0.77539977868920851;-1.7386573893995876;-1.7975083441529689];
IW1_1 = [0.00055496037464614588 -2.0823048684950187 0.82151642383238133 -0.13223940078470742 1.2254260879428458 0.18610239427739714 0.43041786857038722 -0.51380688624573301 1.1125145822588256 -0.57835821078126737;0.8941467811199737 -0.90178004585885274 -0.12657006899768336 0.32750237872616911 0.37963740165735615 0.60711636005485248 0.78344193582337895 -0.13310599666563772 0.17153553366057947 -0.007562814826634805;1.0268457894718079 -1.6644693633445853 -0.63241030743902049 -0.32919278122021545 0.087967333221247668 -0.33250401195311968 0.41263274495363661 0.56786491363728175 -1.0902644938098354 0.50997719358304472;-0.156238234905723 -2.186889625289028 0.49504333829377828 -0.69555069600722841 -0.099876925516267104 0.07907570954141914 -1.2258268943035835 0.57698539651863978 -0.48972145465372879 0.081570054612874435;1.1463790111676879 0.19907083655386346 0.6063260779632812 -0.22478714202618177 -0.70900978917366331 -0.62750673354850717 0.77905425784118765 0.0050588913672564989 -0.16702976990883406 0.6761279598769423;0.16331993119295649 -0.16051938936205204 -0.81389614444588043 0.45718495686569927 0.46535873873383332 0.15549175144691241 -0.93633669632727179 -0.082627021119261457 -1.2195338422837214 -0.37079474398938073;0.05552913104185881 -0.13466416320713051 -0.042495293905915707 0.56416271315439437 0.97279089998269452 -0.28675626245666408 0.45220744006320734 0.58655520312997411 -3.3198634811708039 0.39376999640271759;1.216353722637322 -0.27060019006960739 0.66109650724288105 0.58105423796112832 -0.57678294220335369 -0.69741497515303896 0.74143261518619397 0.25302207807112742 0.72283479710486565 0.57406309947196155;-0.44356659929101272 -0.40904969851625966 0.27190882371555308 0.87500161180415748 -0.20561991650781331 -0.90908168302924075 0.1140643662320366 0.12665652862092755 1.118147842902218 0.0077331843734871099;0.0075522473041521147 0.048139370841277 0.35092097448890991 0.81834744537025328 0.11633734424860698 0.8651759664598907 -0.17239026585595071 0.85538335806273336 -0.70859754740772041 0.39978216395495203];

% Layer 2
b2 = [-0.1804200808830653;-0.03774910371883454;0.12275024220309184;-1.1751923983721553];
LW2_1 = [-0.35683036020697723 -1.3439084152606708 0.50902316277022519 2.0580146350402457 0.53940340459194991 0.10861857524599573 -1.1279028186245252 1.2263266511226871 -0.66124759312751769 -1.1773294544635673;-1.4897210760551436 -0.20274456097947335 -1.3201125554009925 -0.72471898473049401 -0.20845648682505008 -0.47838387223046436 1.7765558692468009 -0.6738176683839755 1.1993516546103493 0.33373636367256787;2.323552748390656 -0.13434815468795561 1.4233143003088244 0.36319554557247152 -0.2895294387757652 0.16056596494969949 1.0112348869247738 0.45321301750898307 -1.3312473718904327 -0.17050951897870528;0.13945749307424787 -0.014615659841747676 -0.39638486000814716 -0.94593004859158725 0.17634863043509666 0.076071889826773001 -1.4070423978525666 0.35239063087942085 -0.23005816575507393 -0.13423809285974198];

% ===== SIMULATION ========

% Format Input Arguments
isCellX = iscell(X);
if ~isCellX
    X = {X};
end

% Dimensions
TS = size(X,2); % timesteps
if ~isempty(X)
    Q = size(X{1},1); % samples/series
else
    Q = 0;
end

% Allocate Outputs
Y = cell(1,TS);

% Time loop
for ts=1:TS
    
    % Input 1
    X{1,ts} = X{1,ts}';
    Xp1 = mapminmax_apply(X{1,ts},x1_step1);
    
    % Layer 1
    a1 = tansig_apply(repmat(b1,1,Q) + IW1_1*Xp1);
    
    % Layer 2
    a2 = softmax_apply(repmat(b2,1,Q) + LW2_1*a1);
    
    % Output 1
    Y{1,ts} = a2;
    Y{1,ts} = Y{1,ts}';
end

% Final Delay States
Xf = cell(1,0);
Af = cell(2,0);

% Format Output Arguments
if ~isCellX
    Y = cell2mat(Y);
end
end

% ===== MODULE FUNCTIONS ========

% Map Minimum and Maximum Input Processing Function
function y = mapminmax_apply(x,settings)
y = bsxfun(@minus,x,settings.xoffset);
y = bsxfun(@times,y,settings.gain);
y = bsxfun(@plus,y,settings.ymin);
end

% Competitive Soft Transfer Function
function a = softmax_apply(n,~)
if isa(n,'gpuArray')
    a = iSoftmaxApplyGPU(n);
else
    a = iSoftmaxApplyCPU(n);
end
end
function a = iSoftmaxApplyCPU(n)
nmax = max(n,[],1);
n = bsxfun(@minus,n,nmax);
numerator = exp(n);
denominator = sum(numerator,1);
denominator(denominator == 0) = 1;
a = bsxfun(@rdivide,numerator,denominator);
end
function a = iSoftmaxApplyGPU(n)
nmax = max(n,[],1);
numerator = arrayfun(@iSoftmaxApplyGPUHelper1,n,nmax);
denominator = sum(numerator,1);
a = arrayfun(@iSoftmaxApplyGPUHelper2,numerator,denominator);
end
function numerator = iSoftmaxApplyGPUHelper1(n,nmax)
numerator = exp(n - nmax);
end
function a = iSoftmaxApplyGPUHelper2(numerator,denominator)
if (denominator == 0)
    a = numerator;
else
    a = numerator ./ denominator;
end
end

% Sigmoid Symmetric Transfer Function
function a = tansig_apply(n,~)
a = 2 ./ (1 + exp(-2*n)) - 1;
end
