function [Y,Xf,Af] = N6273(X,~,~)
%MYNEURALNETWORKFUNCTION neural network simulation function.
%
% Generated by Neural Network Toolbox function genFunction, 27-Jun-2017 15:27:32.
%
% [Y] = myNeuralNetworkFunction(X,~,~) takes these arguments:
%
%   X = 1xTS cell, 1 inputs over TS timesteps
%   Each X{1,ts} = Qx31 matrix, input #1 at timestep ts.
%
% and returns:
%   Y = 1xTS cell of 1 outputs over TS timesteps.
%   Each Y{1,ts} = Qx4 matrix, output #1 at timestep ts.
%
% where Q is number of samples (or series) and TS is the number of timesteps.

%#ok<*RPMT0>

% ===== NEURAL NETWORK CONSTANTS =====

% Input 1
x1_step1.xoffset = [-1;-1;-1;-1;-1;-1;-1;-1;-1;-1;0;0;-5;-58;0;0;0;0;2.5;0;0;1;0;-0.20942529020453;-0.0917657283431612;-0.0422909493839745;-0.0165114840513681;-0.700403538449283;0.00215949012178452;0;-0.105];
x1_step1.gain = [1;1;1;1;1;1;1;1;1;1;0.0344827586206897;0.0317460317460317;0.0689655172413793;0.0173913043478261;0.000738089087352844;0.000903097624853247;0.0238095238095238;0.02;0.000534745060292506;0.000332684598366519;0.0102249488752556;0.130718954248366;2.09510807643743;4.9233842774666;8.3012808518492;26.0861089914044;41.4139735532702;1.35698980315239;0.818167835561665;0.0599722151738626;0.33101621979477];
x1_step1.ymin = -1;

% Layer 1
b1 = [1.548057708207492;-1.6119705104042987;-1.5550034746691384;-1.6797338951723428;1.6248102701131437;-1.5682590343669323;-1.5884395154021094;-1.5820090676715368;1.5513359441331951;-1.5387436224520652;1.5195481660181556;-1.4182122770759935;1.6003177674526528;-1.443009922027112;1.3818079450341054;1.2348911772221862;-1.4336953265728063;-1.4947211012067561;1.3972437014125112;1.3082248871185027;1.301192014531565;1.3716112170215828;-1.3132852053487329;1.2829636281556409;-1.3564854277122351;-1.229658734541399;-1.2223800178812183;1.1858556755230087;-1.2113008913748733;1.1464588736513732;1.1397931888762451;1.1325072755960706;1.1142887729687954;-1.1693566246119578;1.1185461280794147;-1.0882356108534486;1.1818994012022521;-0.96981649174968831;-1.0894435327015695;1.0192122987024788;-1.0710907938290579;-1.0509608753327748;-0.97097189325408828;-1.0434994273672813;0.90681660817564103;-0.81249538379877784;-0.89641494042890657;-0.86305085247504087;-0.9271891869475789;0.95602391432969114;0.92492168020862831;0.76574196971055819;0.77125270817091041;0.82100000780277083;-0.76674997272971557;0.76691642558657991;0.69367095407172852;0.73738236774723487;0.76804169142087464;0.70878417250745829;-0.66274305980060255;-0.58039698209652268;0.64406939741511238;-0.7600855638717614;0.58977283619120513;0.47422630721703468;-0.60905122252961152;-0.69121194017700005;0.55492306631837229;0.52208404107921702;0.55432526611310118;0.46278370540350017;-0.61473773664640419;0.66845488165957456;0.44441558122638497;0.3501687127499713;0.46135029241109632;0.34493350107931375;0.39195935044533137;-0.19158394456569774;0.32935153875613937;-0.31274972697018172;-0.38088024484596694;0.31026653595666015;-0.30951639410092652;-0.32758117295537503;0.18833961331842913;-0.099521244198002234;-0.07831139912590486;-0.24728985323500724;-0.16774657757804209;0.22435816427165448;-0.27100290797225318;-0.043587027495022378;0.045917632303521631;0.098106242422508247;0.01146757897329344;0.024863378934792221;0.087180570397474538;-0.070494608106453166;-0.13803875065879773;-0.0096407196657844786;-0.21452639832172749;-0.044951283064002978;0.045671470669720771;0.14499972550548387;-0.01143508325238279;0.23131014533948907;-0.0046065574445190525;-0.29793428349763973;-0.22073929545185636;0.2289327668673542;0.29917150897795386;-0.26007029201684445;-0.30395033181916004;0.37229016820632221;-0.26341256084609438;-0.29356332502106552;-0.40440884467708654;-0.28232152630491841;-0.1615416597205519;-0.34140220525194265;-0.34477698636982795;0.33759332650526536;-0.39283374998832793;-0.4049581543092961;-0.48021526370973844;0.47209492605942283;-0.3777996522946544;0.4623649739719311;0.46329906752541622;0.55531466429371223;0.53977163287893382;0.55356792605628358;-0.51020614198218361;-0.55845980866240774;0.62555289322717722;-0.58892679196161202;-0.66120102811151904;-0.63973572856874872;-0.63103784174440425;0.77503999720702521;0.77693862831446281;0.75653819317396942;0.72123026292773806;0.6680784528982513;-0.71873889105549971;-0.79471433574112893;-0.74302416887918477;-0.88154365212508135;0.8660638472607739;-0.89738568091821391;0.79617321519605899;-0.85538496462336866;-0.87952372165786641;0.9724583109149727;-1.0423004255751882;-1.036065781465793;-0.94207662367485812;1.0116863564354046;-0.89920173925000746;-1.093270771846792;1.08862689684132;-1.1545825144354733;-1.0318378134179462;-1.215098480954905;1.09672526743931;1.2286028562009577;1.1642623722465075;-1.0258647388154105;1.2405982481435534;1.1977052079406347;1.209109490925999;-1.1172287169676967;-1.2615503414087845;-1.3831963992212755;1.2965937478221217;1.2896196405835252;-1.3608529571906438;1.4151761612799385;1.4288434218099484;-1.3526751327187403;1.4689080328473985;-1.3872432584980057;1.3925239400700866;1.4673046446788316;1.4911254947794186;-1.4279405208086526;-1.4860324392183639;1.495591726234532;-1.6101437725072318;-1.5928453248351873;-1.5509834468980017;1.6212808136786792;1.5358415340563625;-1.6110429436927305;-1.5069822617352879;-1.6166854873056338;1.6708399602733028;1.6837780441454064];
IW1_1 = [-0.47176301606372317 -0.5844019547567959 0.35755292403257138 0.65233053447877543 -0.26708724562558495 -0.3091742424558504 0.16985406043579548 -0.5225576705949545 -0.18466960244882644 -0.59394526225024791 0.04923391170627206 -0.056526188600481017 0.50100551173692143 -0.10189682080810999 0.4783886799400201 0.36073353636350536 -0.39617078717504622 0.20889959416800272 0.029614257217461214 -0.29382849297633723 0.077325153635560737 -0.37941394327166861 -0.21157022080052307 0.42544063653684894 -0.14134938517744791 0.26950712236917573 -0.2710715067754324 0.32796375880713813 -0.04720259956088798 0.35316684092821499 -0.038252045158408965;0.25126388077925227 -0.46186127950601125 -0.59776827335469152 0.3957803432361735 0.42411897959387812 -0.61859830864960785 -0.29030206443261319 0.064451064875023042 0.53863485938719502 0.099505159868667592 0.44077236858813235 0.38103030250290165 0.23675558057327376 0.15110057529446683 -0.024223379443248764 -0.044061313664137812 -0.3310512054835329 -0.086257152695488032 -0.024215402707994313 -0.2776678945035328 -0.45141871826088908 -0.26766328183339405 -0.0079405190142499173 0.095232590330231057 0.045575671286262116 -0.47055304121053593 0.27546760650247776 0.052087535081493552 -0.20216061312503772 0.31945385291761752 -0.20169843449556868;0.31820189799665222 -0.52760314457185553 -0.13238625750536095 -0.49391294833581284 0.38110348776348829 0.072595705829631388 -0.37538839718608685 0.35401111615812197 -0.33824555357033015 -0.57825794002935293 -0.35270822701715232 0.65046079543786706 0.23824219331181146 0.17088608491806767 -0.088585662061037782 0.28789671411310208 0.40151623546603099 0.4522023529706572 -0.30493404395845347 0.01960685571992779 0.2120988130438525 -0.041827789458077143 -0.015107556346358911 0.13005978500042364 0.48113636160764439 -0.30932159504026119 0.33379868986987343 -0.070888056401447852 -0.024330450405905264 0.30640716144628588 0.29750637730800639;-0.057027571319112624 -0.3905513471610158 -0.1736524272411209 0.026665793782374561 -0.2773640357701177 0.074604868544597649 -0.18585315709643094 -0.20424464832243611 -0.15398563278903107 0.59509770378815641 0.30525767598748044 -0.41147514593809487 -0.010361500467120956 -0.37601186927958619 0.46331030005292279 0.26710017586274254 0.42701405316675134 -0.44571480547342085 -0.24834587175778983 0.42807902920943558 -0.035788737503023055 -0.044410705343427455 -0.10686116080115403 -0.14551476860272905 -0.47224708383908964 0.10069503419372772 0.18967264507256665 0.45697895410535416 -0.11283717419294005 -0.15284946631757274 0.15885820855420768;-0.40888749322372314 -0.34644694958422895 -0.32586348407740701 -0.36625670122014869 -0.046580153030905604 0.38032912108348443 0.22342982705328843 0.34204253175198551 0.3386790974339895 -0.21837085179098514 -0.19653872767370356 -0.37600821932825318 -0.16870760097034426 -0.035713849509879061 -0.46260264617032765 0.070765617703904521 -0.10112969168636396 0.40327938936887014 -0.29562532599280189 -0.047245340400494051 -0.20150321487298273 -0.42052975200768233 -0.46478588489973161 -0.29461690474718899 -0.15546343979218566 0.17474590489252614 -0.26706340047209604 -0.35772802413836891 -0.39981068672771103 0.23887928987852217 -0.17565404175217217;0.42087688451216071 0.38904143744938791 0.074552869659637547 -0.26881252291304164 0.19132798142394652 -0.10498868994923771 -0.02130867879269939 -0.28470611392500539 0.28555153807235734 0.50767389340816171 0.3574833327094718 0.48486815209530792 -0.41293728996173956 0.16000347376546056 -0.21932288988247903 0.095097246531193738 0.45317109868375477 0.0089560840700762864 -0.10328333250035622 -0.31794324338218094 0.26617271061448572 -0.25593061028947395 -0.51389346424373561 -0.32034014535992889 -0.23022595622888745 0.080745178130945908 0.25605027515226852 0.3528735600344497 0.27961489410532037 -0.32546533694738966 -0.2233587191261559;0.30177061580221887 0.20513810566432403 -0.096313334544673779 -0.42586154210072275 -0.099417585373404629 0.018168715392694719 0.13410209450101304 0.39911282055066938 0.4472883506119229 0.05678861449718587 -0.37486669969757708 0.47697349254542065 0.020487831872604678 -0.21551539856292698 0.41601487570583667 0.48933154860693523 -0.24382653755347106 -0.3634567749548499 0.16747179503799658 0.30840032317607785 -0.078201074588707453 0.32415071871686157 0.10638321572321413 -0.46072958032341044 0.11908835466584212 -0.32543096674118716 -0.20105298454309037 0.36668466455681309 0.12893771347371563 0.10435157729969259 0.45974354987145827;0.35500171311652018 -0.16808186911617307 -0.48676491006953215 0.052158610162269144 -0.11042091755630593 -0.40263489461058277 -0.57591075521113178 0.32942549255062376 -0.44757933694810892 0.12007295109271206 -0.25381721411112584 -0.022707148178233924 0.48672341049353435 0.19636064899902178 0.13908255647191828 -0.42303571028177939 0.10388412172534703 0.20930129141233059 -0.24167317205602842 0.10903064466342449 -0.33109307160759632 0.16881030312204306 0.47372695072723181 0.38969657038545186 0.37701620541051112 -0.2491168176624825 0.30073168523904548 0.10142717236796733 0.23972979561406504 -0.083516843065358795 -0.53838240541643811;-0.34179913356807945 -0.13555766925548907 -0.34447181057422832 0.4099937295129315 -0.40697858486189337 0.1305381065381816 -0.53702907911373365 -0.46007655236704087 0.3287650405699904 -0.58187161096751994 -0.12320296780099517 -0.15054144145634463 0.062956795063876025 -0.32120663700239488 0.019050396166821693 0.32419287610275194 0.13227163116631138 0.33081046462470898 -0.30622958746129164 -0.24628760974936589 0.36403211152690412 0.24690016775218682 0.29302642095931652 -0.18965981685197481 0.048278910774351501 0.15378681695772942 -0.36139046319465862 0.004861366274889198 -0.38843965235604511 -0.34995282642789122 0.3535085581038977;0.10720921802845823 0.40129273532813065 0.48501918374348774 -0.17641563463168894 0.058211660067686702 0.36459965925739873 -0.26816554950618643 -0.20065101941356731 0.23228748612314593 -0.11458966192541876 -0.18787576639647902 0.27283571945411955 0.3847020300178603 0.47885458432248973 -0.17677199934653454 0.1053468014842423 0.14676937198127957 -0.29807075515750908 0.55111602302434393 -0.43228714766282139 0.21841745441872951 -0.37471879890172449 -0.42833000538620181 -0.0088609162620565413 -0.0079492824098753214 0.050125298244008916 0.28493595148257611 0.17819488146602769 -0.2652369847254894 0.44488245902358559 0.27044176280339594;-0.14186684956785145 0.44070679551108133 -0.15345828749228296 0.4363026113508135 0.36664334841370944 0.25444363348020232 -0.41261509231348581 -0.026309821062963288 -0.41949431580049784 -0.26671271430425675 0.42591349601396061 0.31399408300131249 0.33639785794897309 0.033463729768543123 -0.38936079730236201 -0.046379681127587689 -0.45971672574401495 -0.33356268146707074 -0.13465670262151139 -0.49750857545629018 -0.36716107838225376 0.23810524025328264 -0.1136546044605833 -0.28701636797580266 0.21668335344607909 -0.2592492028668627 -0.30617964099484679 0.25410831498239178 -0.023043953146448033 0.13370030613800826 0.073628540426113692;0.31175127166018363 -0.2955240262783928 0.22867620812508957 -0.66422726818374067 0.043983426525931103 -0.28268688814079002 0.36323226678179005 0.086297863944685152 0.36032861761457802 -0.34602073625995611 -0.27124592564881045 0.17086911178500033 0.61842065857863948 0.32265537552601875 -0.52319989575358605 0.044182906997797311 -0.093309027629865024 0.31524568314100826 -0.16921018493091874 -0.033323857699284636 -0.52309818136595687 -0.14145165544530594 -0.13175021930219355 0.12376959216870527 -0.34935352101598716 0.33873508852289197 0.010759715962587147 -0.34348706897926834 -0.19434466853671012 0.021599807105600551 -0.42930839574417756;-0.28237645378977633 0.43352848607477878 0.46426947796263995 0.38491382905223859 0.20292695826458945 0.048377978577817636 -0.056023381667885869 0.30421083255287157 0.096173289895207459 0.34191439693083442 -0.2253401315277368 -0.40850594413711683 0.025217553218976778 -0.28509080782535645 0.15442423040369846 -0.41361341885111225 0.29721753107436533 -0.17048270055395123 -0.34582443664577628 -0.41224363388858398 0.090279306465975054 -0.086268292682913306 0.58271647690717077 0.11456624978410232 0.33549870026801293 0.33424553353156139 0.28284443683349397 0.090713795103033845 0.31821193261511199 -0.02459202174214712 -0.40118641327964327;0.47602617881329373 0.26937734320626544 0.39887868982656677 0.12083459254068518 -0.16391746232976107 0.43446241398117624 -0.39833320858644139 -0.055419420361376592 0.18147592164906973 0.25045412803547812 -0.20253652964016178 -0.31330169973482058 0.22937208744120541 -0.45265825184425584 -0.030050217199800167 0.23541899125069529 -0.080894371251993225 -0.14240502769499286 0.32127704290361098 -0.45684824113158584 0.37181214066457458 -0.19259372313919002 0.21210867539928471 0.54564148714237504 -0.3609298782228329 0.52972938287337468 -0.094665086930960152 -0.35301266695228023 0.044932437977540603 -0.18646443812312749 0.067505442575185218;-0.40110909436400033 -0.38232546528038658 0.0040493128715470179 0.56417661044573642 0.10300996173842368 -0.41884373225107696 0.27879155950177426 -0.38834037330486132 -0.20431362380332657 -0.12367922144018811 -0.00022072008716530231 0.12597468467892925 -0.011278490731009646 0.22118505859333085 0.51473365041142916 -0.50692894863998783 -0.19146091780919458 0.045027854129317292 -0.10440325766595553 0.50069159218656756 0.60734275865137644 0.077751479355327183 -0.28726405053061166 -0.34531467521941206 0.10272582015795992 0.21830972131481266 0.12966229408217592 -0.35177133102372932 0.44415484306697034 -0.0012341273141117238 -0.038596871005468623;-0.35558980474978552 0.81397188949397736 0.2390073738348088 0.057287098356423372 -0.1098924373365666 -0.19102222806675556 -0.16687743932739807 0.29951724702580207 0.20443284558655056 -0.25253596571696074 0.3750064368926847 0.14960119147944856 -0.077849494780969683 -0.02845955517559532 0.51945656463383583 0.54880348419983582 0.52415574292676836 0.33272268260444271 0.258328522445543 0.075312672180065113 0.10565815877390833 0.23806080495760865 0.25496879799680133 0.11099706856330487 0.4802940399358282 -0.37303726963709566 0.080384502809600522 -0.18767518879177814 0.26056064905531268 -0.13121752854374424 -0.3904754890181078;0.30074655358523272 -0.29189654389120784 0.4553637073446708 0.19637658401787444 -0.12602029110409146 0.026439588232726047 0.010128883826995725 -0.50019098494865877 -0.19848600250194115 0.22835925148364167 -0.091810854228989699 -0.062807677997238742 0.18491089316992632 0.037652237165500729 -0.30868429218036664 0.48116533649390258 0.095085913873752731 0.27784767354653006 0.33808526317571019 -0.507808057079841 -0.28414294994340811 -0.20702431554678549 0.079538272774222929 -0.1508659125344978 -0.2309059211357142 -0.5236150516254513 -0.10797539410820883 -0.48910473499868534 0.031904191158774256 0.20797860926947087 0.45640749194233748;0.16584165164801024 -0.26374715402014814 -0.057252199272250663 -0.49090166128255047 -0.40257774251313794 -0.032378950264824839 -0.6066151258166228 -0.56968052496877253 0.20696487156265422 0.35419994306005709 -0.3444162120531597 -0.18358751878194332 -0.36796316087933523 -0.11836601603355112 -0.01019706527186987 0.19283597319453472 0.17125133173928792 0.13738909777633931 -0.25840225494295788 -0.27281705345984891 -0.087935496707035446 0.5093000391327196 -0.54255043993092189 -0.022199613127740499 0.26042986065213175 -0.26176600496149305 -0.4108016461215786 -0.41299370442954531 -0.19419863867895365 -0.018584009725319588 -0.031398770942205514;-0.35954489231964509 0.16800488857811621 0.31372661931039025 0.23260709496990606 0.11317138815591342 0.37564832470478793 0.2046193842928645 0.12972985968208617 -0.26282368520528893 -0.0477154324375655 -0.31370604830399645 0.19264399949483665 -0.4111105953333169 0.41157867109697566 -0.4066366806195208 0.10353138677215232 -0.30262721896432282 -0.31550892034623967 0.26568505763524081 -0.4557753296036659 0.12131338651821234 0.0032884460115052555 0.26327675281452723 -0.35886988464279856 -0.11807992491044494 -0.16924906252831434 -0.46510252001503266 -0.23398621749550372 0.5149220128579487 0.3685239476762629 -0.13270162351196541;-0.48863454353170982 0.18275566257213538 0.036596159373298062 -0.4274958631949225 0.14779395717198793 -0.3886538564422003 0.26841314004533728 -0.44545010865848667 -0.19295357312287553 -0.32699189350468205 0.051491221505333182 -0.092907664078083652 -0.10912729822832942 0.40712225200765745 -0.20333926706499741 -0.23515769130162706 0.12704305165061416 -0.46123261765905083 -0.1917175520594302 0.1990175209605313 -0.5310660403153864 0.58355080362074152 -0.46265135637144966 -0.054030967981733222 -0.21039007473463051 -0.2935078373802722 0.10272509150855447 0.29772011067929266 -0.086090226210420617 0.25785681896034068 0.30234410080547386;-0.10243934993823019 0.51938934147883942 0.1508845499109597 -0.29434595378593698 0.46697198556567959 -0.084776968711432116 -0.19474302907556901 0.51166149629279878 -0.15317336496706288 0.023188313114868603 0.077759842810867161 -0.023145313376857577 0.14154455345209599 0.035603599387873219 -0.51299921323700226 -0.12026430834703479 0.42387643051932494 0.32102451907021079 -0.36248472608648735 -0.30465827941846696 0.37991704899534134 0.25691290526054228 -0.4232598785023447 0.1759361635858345 0.19590983209539217 -0.11308174499332185 0.31150557740480606 -0.010344960113582533 0.23300312938139239 0.50136174445859638 -0.41952351687307182;-0.40785280510528377 -0.095156231944762235 -0.49711140890443162 0.10519088019657448 0.48887765025639646 0.31890840300009521 0.093729677448366411 -0.24874541772721878 -0.068650405274704215 -0.40938988237134649 -0.39732786711820878 -0.23813891707196749 0.39263037165696862 -0.4206206179143836 0.16834023761251599 -0.54900869157164545 -0.00082366478685550382 0.06842574630886282 -0.15692190710661785 0.29723656478394939 -0.0079961048807763915 0.064173693677384527 -0.38095240735911123 -0.014583200376337632 -0.1435613383950515 -0.041926228870197681 0.46457959737816784 0.081857113619043714 0.41386359605382217 -0.27780293800892131 0.11364135892471286;0.071064512558890125 -0.045745460697707997 -0.075469697175296127 -0.031735381365196658 0.24211232680980155 0.35723962806337456 0.16090371140877233 0.18435320829305424 0.025130992368030184 -0.10158103670700699 -0.15275105105003223 -0.427623504132358 0.46829789084955004 -0.17553133726998249 -0.29303321326050769 0.22309384454519265 0.14638743563785503 0.057449697546285386 -0.6254456258472797 -0.26893842342584678 -0.37268178712501404 -0.06605043138775181 -0.45627803552103191 -0.29542437940093774 -0.49936816655726046 0.18379084280286387 -0.28185924536797641 0.2381670323298867 -0.67448102764877715 0.56795871634548967 -0.067763257183800399;-0.30574364770710161 0.31956757418641063 0.46015430082469344 0.17520960445017478 -0.2522477141957144 -0.23491569124504352 -0.24499099101313485 0.37095480870083197 0.057690157514188468 -0.22436610054863446 -0.43288339293300904 -0.31249175185174044 -0.27407396967227404 -0.22713351749433477 -0.46512714466856742 -0.28257034116092383 0.20803925105739474 0.23195968597632755 0.22109533389390221 -0.22264011035362002 -0.13462214255601787 0.20739058602490901 0.51000077966314039 -0.086607406215947716 -0.50804440108827542 -0.18614172507792381 -0.40019779458210702 0.31781024757440701 -0.2055349908363413 0.10414008432490909 -0.32580852391014781;0.056281958508567424 0.42497178406413372 0.23984443981381667 0.008099348020592893 0.095563414422746934 -0.21317317325341728 0.10114535730622135 0.49642822196942338 0.28557858451845319 -0.32354248318060375 -0.36371271022692747 -0.0534208024563054 -0.19269087086200071 0.48942058259227922 0.59177855615861452 0.16470940813232793 0.16673751649270457 0.15592026168614961 -0.21608971529831905 0.59409392566557984 -0.10139612478690307 0.31850126500285053 0.20860115169771448 -0.20997766845044349 -0.47875786369969348 -0.026127063331252455 -0.30042795177035159 0.030105977714007911 -0.27663403851469781 -0.36914756108929792 0.15819525959099809;0.27670186214947484 0.36345290575740336 0.025931508115495182 -0.24190393396618817 0.20386246601808136 0.42667631556877139 -0.46069536402934663 0.44841802608380144 -0.30332921699374549 0.4096821133469708 -0.18761844212289516 0.15689856716466685 0.26006595766210339 -0.33402126091935336 0.058295284787001252 -0.32747236884610637 0.025473222700164118 0.36134415013946625 0.14599729330677685 0.34916269281184459 0.45529415270751428 0.21795216949428015 -0.39547723642248817 -0.31843229813079471 0.2634336302466368 -0.20168036990174851 0.1649396946995757 0.13941699068826444 0.30503831332699444 -0.45430250131487504 0.050937540070276635;0.37081578673387838 -0.52270921779120227 -0.020457535514270018 0.28579305971856278 0.14659072880232177 -0.15901929554679065 -0.56095704604364316 -0.55786523625994577 0.46881355542432035 0.34889154292919644 -0.0086476242311505618 -0.46745825309203548 -0.0081159515357651195 0.17325627222770154 0.18103358254084723 0.44449510495198635 0.094524976933742025 -0.12429447965009216 0.46485481494715003 0.25056151890957573 0.053036349632921191 -0.38116248777881317 0.36586787415618682 0.23471064656722546 -0.24741847631276803 -0.43865599967552366 -0.011805175233796046 -0.24958197024644527 0.37700384931909886 0.48786559264802654 -0.04274421380624125;-0.11369971575979042 0.34456189996100134 -0.56880851384506981 -0.20937774909168125 -0.19588155338487059 -0.1053270338921431 -0.48055664714182761 -0.25116628776975158 -0.20981657690747008 -0.31961845884601114 -0.1314005234037211 0.32877042125126599 0.14847247671221994 -0.37664299988808075 0.019756586219902599 -0.17652648093335818 -0.48372884032949531 -0.54168284435544556 -0.26298318146518146 0.17829765848412274 -0.29066015444437959 -0.038737185368354875 -0.31840946976494844 0.3141593493617465 0.33756960271050335 -0.47756128031176143 0.40908864837269088 0.10835576473174215 -0.20387539779148431 -0.16562446162462494 -0.22186926893123984;0.52005033288435065 -0.20656406460709137 -0.27577773351623752 -0.1372186444663854 -0.091139907613249221 0.23934853346682089 0.074131551216821703 -0.088234853039143815 0.39951672845294289 0.60978581123655784 -0.20462800368796105 -0.21862545920167145 0.013349668202211831 -0.23669207258962655 -0.53141536383100063 -0.19674704503010743 0.49113697607940854 0.092946342164012846 -0.56213974867135719 -0.182326354438692 0.19050978115058678 0.43325404253621813 0.23701398038141111 -0.34326132978030599 -0.32920998850840089 -0.054049370519150208 0.074874112926136493 -0.21146629231221212 0.15216811411037731 -0.095218873659214345 -0.048367176431040632;-0.24381309520456138 -0.21900613438181282 -0.097331488436820754 -0.029330667761821874 0.53298402343822981 -0.18283605836027064 -0.08169991406866757 -0.035754163453754484 0.14580409031462746 -0.13414519234101682 0.39009491266465046 -0.11099923098264936 0.026318618598749993 -0.40651235905254413 0.00705350030554611 0.20162333044271136 -0.70381892751465325 -0.38170577980128539 0.55991004464275351 -0.39385796790811045 -0.53559018713154083 -0.44530157569135781 -0.12023113802725879 0.25371421596447757 -0.40226599908803495 -0.34752374012375392 0.55945718841965764 0.36783164178288513 0.036329175746683956 0.086457691283140223 0.10260636924039622;-0.34355492787647773 0.3294458721103265 0.29024336223069447 -0.5633069350229376 0.49715587631192248 -0.069635760875652 -0.10913107008573457 -0.33013063471934639 0.1223484487605242 0.14752259617390484 0.38539419828591637 0.58570035580005686 -0.3731780834733251 -0.069579011028254173 -0.25055783407566057 -0.410450069128794 -0.45964400237524033 0.25074759783206363 0.19252759723162602 -0.22418521612677039 0.42214712170568092 0.37175824560169574 0.32385909105121519 0.17808019345048803 0.32562384198534189 0.40200474688058313 -0.29644322070392864 -0.0043923920415178145 0.35735508956254269 0.085712802001915306 -0.20033554789040503;-0.39601890960373087 0.36737995585579508 0.47152837245868495 -0.39157949415501409 0.28742020866291651 -0.19926767429972223 -0.17215686812086781 -0.21063139465807429 0.034338300188705193 -0.0065157898381918286 0.21606250990944253 -0.33615581115582244 0.52032476564680918 -0.44498708692698913 -0.063030248718338761 0.019165416301593567 0.58010343995029834 0.27524317389926012 0.18899926244205667 0.3616015377058226 0.36916536175529369 0.1917919502469414 -0.1753579905758105 -0.10382359750874992 -0.29942699900152864 0.045086709049222025 0.42738109558837623 0.44227144663089796 -0.096715263243938088 0.25126617544825125 0.14378200922593035;-0.15174143299345233 0.42066813513628398 -0.43129063629248193 -0.063938015427510861 0.42534924324966639 -0.26105468628661005 -0.10863390289727375 -0.52408698309833657 -0.17828043454710185 -0.019460949782268543 -0.19504688232105644 -0.064484989946099969 -0.46222249707122587 0.03836534284259014 0.29867964225391802 -0.20811812353986758 0.020334891095667766 -0.41590422658520287 -0.34101706922681307 0.17217141258626917 0.26812166356635814 -0.48944876947421256 0.37901824624017449 0.32663536633347928 -0.44312539649779165 -0.061973790316968355 0.29297874998593204 0.23866073709690519 0.46289159590827289 0.11350927222934222 0.065635555509059418;0.21817443894855357 0.40230373525905205 0.13980002467713848 0.10035716111175676 -0.29275991614456953 -0.027433183520565754 -0.077115136529754894 0.16201168707640143 0.5555701440843499 0.23871525725863166 -0.34382326643753713 0.12348388307022502 -0.071862290257352635 -0.2966978937686196 0.38875186811841361 0.25186748058525649 -0.34716055076823843 0.53854314615267806 0.34423778441577313 -0.43556217556001214 -0.4018284762424908 0.098279563367998785 -0.27565058139300952 0.18671129616678173 -0.013095446441750038 -0.32865487679615851 -0.15703247122024794 -0.04498651723321237 -0.39292996710280714 -0.45336578006923511 0.42954322106227866;-0.50468333418476707 -0.015474034335840825 -0.58686622062404159 -0.10536411388888539 -0.023053613666191623 0.5210389198936114 0.57620237792463647 -0.17228083115923437 0.18894901933754729 0.5654475062985076 -0.14915359679422116 0.39101015974187747 -0.3886472345501174 0.081665441348661785 -0.29418686377590036 0.23789493616010396 0.094200840356900545 -0.11649409902723966 0.11748819918182861 0.49658917675104547 -0.34108508543904859 0.62649951451288577 -0.29405406269551876 -0.20606361002130194 0.0033844996737021856 0.29055830355411877 0.24786863690168962 -0.15303205126405361 -0.25566828967608435 -0.29978686217860251 0.2661880855673589;0.060709271252464864 0.24406601611217499 0.02926251499717783 0.56078831682710861 0.30226841955304629 -0.5302106017523216 -0.44575537556112366 0.063201945621707015 0.47085035072788034 -0.26302507620788557 -0.032563093742686726 -0.41237628976289453 -0.45911196718290309 -0.15109579589151503 0.17005641797835699 0.64560892798622127 -0.16577992018638257 0.14940349913759993 0.50030702750908185 0.43826187682658491 0.10512477780693794 0.14208166641652167 0.086268171377997541 0.25714970194191961 -0.29115354094267254 0.14834565016105311 -0.27107319644308153 -0.16424016559642313 0.13551278690068769 0.32463081308797664 0.031601098638992263;-0.025093736038044098 -0.25066331852236984 -0.41734059638542942 -0.45762136079808546 0.21383533703988986 0.42310067949643876 -0.17242559817497227 0.15986651972113394 0.033931140360911605 -0.51981847318911001 -0.18454686373859683 0.3523823971239391 0.28950225906093591 -0.45398641670248735 0.10697907066693225 -0.30100607806376745 -0.014690055850784856 -0.38117305063268303 0.22428357246095798 -0.55569057051423476 -0.18440164857146416 -0.057806149045034935 -0.22512438916665606 -0.2572254401655461 0.40010713901260253 -0.35370914097223349 -0.0065617270876599512 -0.39789120216460394 0.28916711098237996 -0.023123337719356277 -0.2429925910844058;0.3358452164815896 -0.079181379607289937 -0.10539908717034939 -0.2942383132331084 0.50053061131769638 0.27794283490320004 -0.21479275642168708 -0.19371572205873214 0.015574610337076156 -0.43115153182980875 0.092207780398425296 -0.54971471266782523 -0.28752939669126304 -0.48569971252691135 0.42372909561396938 0.12604335281013071 -0.010923977681491438 -0.68461046757145949 0.33905599986931495 -0.19070231325800202 0.32872805114971559 0.24712807506403939 0.23371135783825178 0.4066607588525637 0.15813470875492242 0.27770791954862378 -0.21867106346355059 -0.021778182893314301 0.19476191587625502 -0.34904350698521869 -0.25374609940056064;0.21324929118085584 0.32701055692945225 0.49976861243402038 0.29274476023536922 0.11174416365907051 -0.2133509226728017 0.094491005446274284 -0.065690520671856836 0.039708065975633991 -0.44078386515386569 -0.4225580384469797 0.037584548972820965 0.3836344137641311 -0.19467249525182634 -0.10428766688165789 0.47759781662345785 -0.050490869666178211 -0.2387602692447251 0.078438754794756135 0.5081339180942861 0.28803583019213824 -0.49036553296313223 -0.13969763833001889 0.022998712729545501 0.40797910131005838 -0.18445246170145169 -0.34776206724468828 -0.13562500574291697 -0.096427869832148155 -0.37504086709491574 0.030749178332379244;-0.43808693535211668 -0.28971828705318359 -0.29119777833090754 0.26281897516385239 -0.43424272123076796 0.14473813238547278 -0.22464823754216903 -0.042527071624752319 -0.33175342900920318 0.23374654330844799 -0.044102555866017579 -0.44184424017149909 0.19837496902020099 0.087256982291788049 0.092307306657941138 -0.45039700275370842 -0.37702375563139445 -0.36652370722899213 -0.28249673738064912 -0.028478007593883272 -0.37033281941679347 -0.40120991422217056 0.24002582118415608 0.41560569071908005 0.29113784792005504 -0.11878345281256088 -0.26867096834661403 -0.063229841126448139 0.40327496658700801 -0.22607208984566218 -0.45572064060542994;0.2145699446444764 -0.27132441103471522 -0.26852022388395647 -0.42709121603130673 -0.07880201147101959 0.06921557386606067 -0.37430632405869319 0.33666927037197447 0.013679263144062521 0.44016564935417346 0.45223312383116493 0.43481981091304833 -0.072354181501784728 -0.16881275000463059 -0.26168776427030838 0.14232917277898099 0.41754699976647852 -0.34050248192535271 -0.35111660554248353 -0.36007832021980352 -0.24335260474928086 0.18236822930114652 -0.139228203266341 0.41625811935089368 0.27832798185937047 -0.22216511920117751 0.32749854535400097 0.13290183710238776 0.046381311687761557 0.24885647421696272 0.42976153199988393;0.20855732966916654 0.079323012401564405 -0.094313579519642102 -0.081237156542527639 0.055386031995174244 -0.25605449549871084 0.12075868809933708 0.42259500251876453 -0.091925231569267157 0.29958783981247294 -0.044446537108361189 -0.22546407323311635 0.5721022919848282 -0.087883451900268875 0.2165811012811259 0.55521388512385528 -0.36251376476679287 -0.37015602837734723 -0.28168370103109808 -0.14052022942589421 0.41549999239755198 -0.33390587542540734 0.23312821769219041 -0.04139341363354225 0.11963477787491511 0.5324572909419788 0.52610417420588806 0.36970175630213886 0.14580451271653422 0.25098705525196197 -0.20501753041434942;0.45874064371236939 -0.34008844948629702 0.36255707886997351 0.34378615413374713 -0.52033603968867337 -0.11132009468827662 0.29514609097270406 0.071473566596949409 0.32030090414393975 -0.095899743972228391 0.55350658256028973 0.21340927469080787 0.37318443924402628 0.077544184471785585 -0.24680375459558929 0.0098300800351534164 -0.44044635450855041 -0.0031413761448878435 0.037203182229883329 -0.2053623839497011 0.05391448025893824 0.090803027972652731 -0.19276354804209361 -0.58010929311760695 -0.42252849930428932 -0.4217217231974742 -0.46420517999858096 -0.16386538767594375 0.26167244529428763 -0.045626194899057816 -0.097698339669870224;0.37397728470359037 -0.031468483367431292 -0.17108752154776422 -0.0693795476209325 0.28390449844908561 -0.41844450843378128 -0.36025845743266671 -0.38366102262171675 -0.095407085370249167 -0.015778854296872074 -0.38864215344706177 -0.47049051640356238 0.3706698822349811 -0.076566997530075467 0.055362114222512401 0.46750209333374454 -0.26109417084713582 0.042350575632159958 -0.057758392531668659 -0.1126330286615527 0.14981998596388568 0.36520649371862846 -0.34283662417060506 -0.35017919961697974 0.39961877936176682 -0.030999415647322 0.23539940284441591 0.37778501710056395 -0.28218215010446968 0.17978682137277513 0.37872531633027612;-0.21492280366799343 0.25276714960263252 0.56964218781950682 0.21265229429983457 -0.21760386042775692 -0.39839418575065039 0.22682631258437688 -0.057376707637015634 -0.15052384331446791 0.023680379614676728 0.55100187672229151 0.38979730331241352 0.56063498465999384 0.050550892318353198 0.27496761822603327 -0.42231932513950182 -0.50215585300358467 -0.45432787919781242 -0.41642013251247018 -0.13962740614682884 -0.19594477717714395 -0.14947245569564349 0.13156836819791562 0.33304922638972229 -0.22565431175143219 -0.028141512045751053 0.15942581117539134 0.45006682615116594 -0.2947241477222417 -0.2521942050548045 -0.021272289703660525;0.20438973362818419 0.097076176794684915 -0.43583312490293391 -0.29879107872061483 -0.077666858046171947 -0.4416984083779838 0.026708707720316444 -0.22954028923499409 -0.063879309579923355 0.3164767463091841 -0.39180816361215981 -0.65666859392335419 -0.21370098401269086 0.23613137535915746 0.23642917685842077 0.10526630983339499 0.17237555716815997 0.23718037994141336 -0.48137231496795951 0.28673551073447384 -0.18918037586069164 -0.14175134539457099 0.48632703412344347 0.38554628732312357 -0.47399715427600592 -0.40149025823771672 0.23853205655672829 0.28398109751677642 0.24912608731939631 -0.51878443264286644 0.023143261566193708;0.53047231639503989 0.13453668226883478 -0.082135123870742843 -0.017481819207121316 0.17517218071773 -0.50854813638421925 -0.040516850221879223 0.17857561067691613 -0.15212048797949457 -0.37233071464568296 0.4435934136434791 -0.1394879167105251 0.5378117009200698 -0.15875757890802633 0.24527728478023675 -0.12901647261476254 0.13207497270076496 -0.0018125042344129152 -0.057232557580340189 0.032005017472065835 -0.44144738587022531 -0.053835095433835134 0.25488889982350965 -0.20393576150031745 -0.15714455839318531 0.38912201816152719 0.067482590500976547 0.41405814805331226 0.040686754157322702 -0.051467220600094662 0.3160301723778533;0.39394518028998182 -0.3423674443257006 -0.044334566889373893 0.400212338176269 -0.11833910575769413 -0.45064726872666483 -0.32823508300508963 0.19941048008236051 0.52363277273709519 -0.37250713535749252 -0.25851822374391231 -0.51003755105742676 -0.086843113974036379 0.094771620147986735 -0.3127730601192224 0.2275034889646477 -0.54234541171758377 -0.34196742896112214 0.021478458517290307 -0.33189647031139619 -0.0071978318718335993 0.0075420536903916206 0.02442842888556809 -0.29070323829734201 0.28642382314713227 0.22167925896075402 -0.39546816467193174 0.058570837333618953 -0.022332828435163276 0.27330067811810005 0.078014399775555632;0.36767846433547907 -0.12171211799273038 -0.016693490072893814 0.0040132988697243518 0.31818359142241537 0.46580893313890265 0.17574012301597558 -0.15744715656697181 0.0316710902215648 -0.073661000866949114 0.075823479540123764 -0.40060565717378671 0.11061597912135603 -0.37006278515751306 -0.069165338495308051 0.063792566279572777 0.26388598040684019 -0.40216638629032231 -0.51725858897285892 -0.18835563937052635 -0.44763083540652604 -0.026386765432535896 -0.51101047688311974 -0.54262049340610974 -0.15147999234008322 -0.26969337184255665 0.061510626614682942 0.093098440666546323 0.38857551317656736 -0.13094376467268462 0.18955620592777245;-0.070655177707969807 -0.14752327153940178 0.42698563782305593 0.3082345932233258 -0.033538602212261709 -0.29520646864588973 0.14694132192864842 0.10554868929102898 0.20101827110559967 -0.53608202019556406 -0.012439856291231226 -0.15067116929041713 -0.060483303455202905 -0.0026269571495958002 0.24653062096735387 -0.085921398721964776 0.03356539701663349 -0.19406454979427681 -0.27380797225952402 -0.55048424227692383 -0.46518604064228802 0.26206734682864224 -0.056632440759807189 -0.26096918933256946 -0.47765933120953358 -0.1220220047094821 0.40545847386648309 0.476735284816871 -0.16078391762701014 -0.35779575086313992 0.44419899337054763;-0.12739789157854209 0.11673847429561443 0.42985617085018246 -0.41697005957031141 0.14396077998664975 -0.048230095218217167 0.50158853456577468 -0.31820614654263102 0.43344703381278621 -0.27969192240662927 -0.75445050536018743 -0.035356899578283016 -0.060877571892857127 -0.19268447336317601 0.051403611668501985 0.19568716112289494 0.057158897410666175 0.81012853150547037 -0.36209724683145472 0.43655464962538032 0.36712213581515868 -0.21569153740625907 0.28553599107361416 -0.27137372594445042 0.056344649230258177 0.36734714184664319 -0.0097860518083821638 -0.43157011848775922 -0.099173367728272122 0.18239178865965991 0.47573681214429392;-0.43263368800477714 -0.41835187055802603 -0.063366445906705371 0.24773416282805083 -0.44719949749424093 0.040318919288819664 0.43827115626667812 -0.41430726221332287 0.3066398091699078 0.28024829563376591 -0.3447364049392011 0.13231618064556233 -0.0032463931324511887 -0.2307545739732651 0.5484603256894468 -0.17945885463405464 -0.24101816237615908 -0.026164491633894688 0.17720742378095686 0.54204856457033035 0.23523363241018799 0.31511807684856358 -0.2282547025348178 -0.25380116140969167 0.52359503891918302 -0.056484459623743877 -0.055395606519120608 0.26923458085913216 -0.080071377754379724 0.062638711744440662 -0.47206718248787088;-0.15214955325245805 0.49002387945618614 -0.40552926546473805 0.053207380131659619 0.25185456486871383 -0.24997059419073162 0.5325842289481757 0.10331483477219409 -0.37252841088979444 0.38641504785451269 0.45863231937419324 0.010830504113444562 0.24581842018104788 -0.014815308368413866 -0.0012347786309488112 -0.32177909289645795 -0.35733246111576045 0.28726166509617546 -0.39570473768969167 0.038292778165021024 0.50921413439063379 -0.36424849838056772 0.049524898910096898 -0.044263032418952859 0.13909878837295472 0.02714738416495014 -0.30069981273324142 -0.52257089165653714 0.11960369221942906 -0.29530958537976776 -0.39316816094853563;-0.014420408451489251 -0.30076271900039853 -0.14635735688076967 -0.19703840533838488 0.30338911941878294 0.019769118510899297 0.28357569407283134 -0.32616538571216447 -0.4707035722224851 -0.14385418404254691 0.1303756863174351 0.19676423198094964 0.52087744624448862 0.081182167819167719 0.44863689580349364 -0.60742087626717023 -0.18929064777479779 0.039052869557451665 -0.45630515796908017 -0.25189941102712377 0.041802644191966276 -0.10386202697288437 -0.038414996846864169 0.23823591729061389 -0.22990955644712185 -0.26738555075976217 -0.45897424867926495 0.34392635264067178 -0.59533825573556853 0.038047562445121808 0.0070555135517232446;0.33771701524012843 -0.6068660553224513 0.27883480681607964 -0.15798923217088481 0.086566550349731056 0.15769053562138644 0.23571137164358197 0.21845840592365029 -0.25634874935870039 -0.42105199167591612 0.45099970211573442 0.25252835157427711 0.15962136669238511 0.0050046597846115908 -0.072653550377153084 0.29636919758602687 0.15996491125191031 -0.0031771068582622458 -0.42337380562273669 0.4742374837706565 -0.24854814799812749 0.36424715199427954 -0.2982158805477807 0.1949799088303312 0.40204239217524046 0.44544298310888902 0.016762087515705213 -0.37176422041387502 -0.089823206467398012 0.1547451507851523 -0.18262119930417939;-0.23347888778120451 -0.35904676900242261 -0.34646998101522269 -0.31851354121171849 0.27487695626115638 -0.39498564476855252 -0.14806803260981957 -0.42163835896172969 -0.29665030269263576 0.25279228110779506 -0.22683235030711182 -0.038058207754134946 -0.22655075206943998 0.36690020854665684 -0.4595787973150679 -0.22289591148459797 -0.44863926492466427 0.27065515950714841 -0.25754597433192283 -0.17583567732878796 0.42580683041967843 -0.064382802049367735 0.21694633772563579 -0.033631910382660127 0.12763143565188723 -0.35874314474654911 -0.072834851511438869 0.27622789196578085 -0.40743841168097844 0.42673504340151286 -0.17267193552583329;-0.27652937903931241 -0.053795705385800335 0.42406750022995343 -0.040406472997571809 0.10889989722039548 0.17305011486190572 0.27129081498357632 -0.26075858368248633 -0.15137615473612223 -0.1971315676164026 0.20280786693225597 -0.23778311750380218 0.52204140567386825 0.30604537918512875 -0.61221494404306098 0.33943292989678703 0.68336446018969765 -0.24626321886988883 -0.39897769816137496 -0.039087067677907074 0.072341198158689307 0.50560934318643402 -0.10434013964048669 0.12868720257313926 -0.29156864370109115 0.420703339251215 -0.023783139838411758 -0.1275116803025711 -0.21799212086531131 -0.2648804668546737 0.20389437887101289;-0.17381878035641474 -0.37336270442036518 0.47898497982082122 -0.47188181397833284 0.062058713424174822 -0.27674153491956044 0.45189384702130253 0.031126444860090301 -0.22154712020434822 0.28296436617831328 -0.52580566011312169 0.073812769006372181 -0.23228818894770747 0.34045793954719361 0.410885178506669 -0.16121308146179517 -0.052067746188660072 -0.41570063487545533 -0.083362190484016579 0.10014392858812005 -0.031057232083937403 0.35474430371713028 -0.09522425193489506 0.17564535526185199 0.38295853602096208 0.3408483335481875 -0.3826596992541616 -0.056662153945041094 0.43661673668345885 -0.20087508094466211 -0.0011489208753882568;-0.18063120515253756 0.70777342039910851 -0.43346950554254232 0.24277230228737404 -0.21243394811718377 0.24687753167105872 0.15941255638869287 -0.37234512681936116 0.31067039938379382 0.23925937640660072 -0.052306292636479505 -0.46489493949013988 -0.33104470950120346 -0.29966470467602035 0.44524261468378012 0.11251466080088017 0.17364333726571854 -0.055335769685195504 -0.6316069757207321 -0.36066915705399555 0.96257175659618022 0.016177988600760942 -0.23630092403892763 -0.12374380162404025 0.38777269523148511 0.22733819915753181 -0.26016918864543281 -0.15797554658506935 -0.57469596479480267 -0.17508217113468721 0.090338606432885757;-0.42385337864129852 -0.32981907353237711 0.49679858684856965 -0.075560274050913437 0.0031029720238529889 0.24580540053176955 -0.04013195165384463 0.57521467792691217 0.54128326053947673 0.12374895122370931 -0.23941725691128013 0.18301729879602044 -0.24547260126214854 -0.1389898981665737 -0.40681926540462759 0.062574251570037681 0.034259153869316203 -0.20820486666686916 -0.38261562921699588 -0.39436938764652107 0.31999579239545795 0.038689527332195849 -0.061895454248860948 0.5618208126626747 0.027114347095999355 -0.18509298874404057 0.33670692890755016 -0.14708675323790593 0.65349349616238561 0.25066510502212164 -0.19319283392596068;0.50910041731312472 0.34547945604383989 0.14423064868922639 0.10862264037440825 -0.43426806992420153 0.17157985888605765 -0.41701052564062663 -0.13064862961189588 -0.050881153105307754 0.093926702235093446 -0.30762886325275396 0.27209492001539892 -0.060656715129917743 -0.13502539404443673 -0.47673212377590474 -0.031545403989164528 -0.20955216632787518 0.25507493978255641 0.46091515149350676 0.21279316855230684 -0.13799760485597437 0.18641600653635526 -0.12851717853913586 -0.33213319387316581 0.4895673797831574 0.20960412265448841 0.25115640525910815 0.24528469455107482 0.39315006180174511 -0.35625640281194371 -0.092684094321488331;0.49924933998537152 0.59920710653307674 0.13971368138078979 -0.56116920928032432 0.36347916403907377 -0.3808477929179202 -0.025365592966655102 -0.11036016575336748 0.45155996451023289 -0.59220350394951093 0.38804630429817288 0.19409939004407112 -0.25072836043703373 -0.25879660119609277 -0.060356814230938867 0.25671325742143369 0.081476528354885683 -0.089969453644012043 -0.3007169852225689 0.15332675630426329 -0.044340512155378695 -0.48407559519051807 -0.38271163631986549 0.10941808336034768 0.23065799302381129 -0.43925473691771111 0.0031354874887365301 -0.060821169845339307 -0.21682291725115391 0.36637676605755232 0.3615235842592166;-0.20124818899333924 0.12631637322127928 -0.1150187036362309 0.33205675562969444 0.12530031287461307 0.36054386530505578 -0.033525844237168395 -0.50928791977888976 -0.47626761253765626 0.085743152197282929 0.41585924126319479 -0.39622545141601639 -0.50504977131685558 0.041895825811697651 -0.10124048267340655 0.21787404356036691 -0.11387615207103054 0.004353482512411003 -0.21463459265898568 -0.46177922827799683 0.041098794870281237 -0.39806543794444399 0.29158397825503996 -0.3238213926758125 0.33214916706588532 0.28273551428109089 0.061371512078594079 0.18352846492881136 0.22999119825474509 -0.49922353451448431 -0.38309203506917006;0.23351265056305928 -0.35961668355664395 0.22405471981384009 -0.23879031144630411 0.4535381311664145 -0.32250157085313153 -0.39246009041020452 -0.019157658261481046 -0.073771167006805569 0.33963961144442789 -0.12480769012354702 0.49737385468503764 -0.38910890513280205 -0.06414464102615397 -0.24883091017737213 0.38908595469807661 0.2121278627354552 0.21835457747809711 0.43430180851646261 0.16476738401416854 -0.0054356565494957871 0.2994029687052962 0.28129620304433517 0.2382977117537686 -0.078375602472381414 -0.41462136495455076 0.29456413288528482 -0.35319413750007361 0.37300281508726696 -0.37482660035564519 -0.31414135893983275;-0.48025030997886275 0.33579604163930005 -0.34018216856226735 -0.23166390310571139 0.097061004909975934 -0.34445710188582074 0.15523534203320893 -0.47006674401512166 0.19359005445754857 -0.41689927811291239 0.17647361083600777 0.0389102686130431 -0.4286283539071627 -0.075531460192674718 0.23577989915101066 0.017517541179254047 0.31049930541561582 0.43028684385417726 0.12538943810215683 -0.19434225260573831 0.17587523402622884 0.46819895505376474 -0.24503772841686455 0.26455188195179713 0.15263799567880268 -0.11836808055938433 -0.1557971990628772 -0.44837293401334166 0.44824716851770513 0.44507323508425733 0.22931254686776195;-0.25924633999962693 0.64062498933764678 -0.49612067028282297 0.35692977727462544 -0.45355632965810866 -0.29035499362997919 0.40238404461890831 -0.061933716313954619 -0.075126225894713003 0.14173348752353992 0.36719808930242342 0.1650598768348005 0.62028931675603716 0.16664221547319907 -0.31719287870326823 0.34521612522595158 -0.084497404594869804 -0.46485843159858414 0.5195361269026072 0.10058007723194765 0.54114147623202613 -0.087379930866495245 0.3404033840901638 -0.14733851494811842 -0.29726711310467691 -0.085105261218006378 -0.36931845221870019 -0.091830388744462338 -0.031020698298638388 -0.31868077559452995 0.31791549496184235;0.077851789808371846 -0.23249785302632267 -0.057592791728371596 -0.24265564409153645 -0.35695515435481079 0.01208365001543487 0.41899034590644335 -0.28236569788303212 0.36275448962810375 0.12127485255029319 -0.046720024625608342 -0.49387835651406065 -0.16908188000560262 -0.11057804658391678 -0.23740989480719998 -0.24041551099369898 0.31014787698338242 -0.32426165677390867 0.19618022235766952 0.30307818229979072 -0.485268325179738 -0.18043565349400945 0.42767968155019975 0.11471390256791394 0.15992698416613407 0.31960057315254414 0.44499530192932701 0.48132902589385479 -0.38906593553151053 -0.40453755208541226 0.20470504208227253;0.13110090632299742 0.13995832661679664 0.45674662799724247 -0.098997758925634963 -0.090004142081699712 0.13489045232027702 -0.026278489448676702 0.52031428038838468 0.25671816957405891 0.29935379955182023 0.53257933756270059 -0.26150989391826279 0.16032523734529963 0.40991170547128492 0.35984571493084672 0.059799206077663543 -0.059957299454803006 -0.23839632842522965 0.46671862294825067 -0.31484326964846221 0.32592016216305053 0.11734637158091976 0.41919873086631426 0.35777210370599538 0.18686748974395787 0.21281164980651829 -0.28960388672744852 -0.16568219129500278 0.39113986451791433 0.43668192580039644 -0.31775113986531706;-0.12235422923452063 -0.64458689184685281 0.10642974341120981 -0.013416961280106783 0.29203429669486425 -0.20380060657959589 0.13819809175702572 0.27563548355433504 -0.31827942456385866 -0.095485718460660798 0.070725707827775763 0.20579408227575258 -0.27760974100241326 0.23041094370153825 0.64040344507227154 0.11994553648851036 0.41653650831682343 0.15414208782771457 -0.36561051324298338 0.31525570981037965 -0.33570954351013527 0.05564851385966231 0.38565440264719736 0.25309203396754409 0.050551116452950524 0.49841369675102315 0.017347300268732702 0.41450725132319444 -0.23857595555791378 0.53000781992559065 -0.14164307368152801;-0.44328372953945455 0.48873537525601385 0.33122036068583488 -0.094156271610788572 0.17385778140513797 -0.45393809801185131 0.17613558520214229 0.39348310807781339 -0.14546544813561693 -0.45771284020204028 -0.28772855668851965 0.43696099020558965 0.14620591915389125 -0.36649694586722487 -0.39220146933480454 -0.071464418794040627 -0.61847653914844047 0.040464729140010057 -0.11009425544854866 -0.29890109071707233 0.088070643533045959 -0.12783696077559967 0.052214436773944016 -0.10189551469811001 -0.33586630595754779 0.0057660484070729242 0.5912735958963824 -0.54706589189087695 0.069381090661571207 -0.2445506896808321 0.087243593089847651;-0.27798476399539396 0.39366984799076449 -0.29348459741821564 -0.2471690091647292 0.23041426208363233 0.42739133211666408 -0.2614686867440395 -0.2987312919967528 -0.25653713211606832 -0.46130533580477467 0.032551571339878405 0.28022294697730149 -0.49785697211305557 0.22805645116975193 -0.26495178181954687 0.37151392633178121 0.22155994310098531 0.013388561326695527 -0.22529195614709568 0.42251768364200937 -0.21388455925363578 0.33691350415501481 0.031692386144679757 0.29724374250029068 0.29445445020560568 0.45998445941130017 0.1943148529107917 0.053508400802246718 -0.19159240303734529 0.41099944211094741 -0.30513963109084918;-0.24752425004234335 -0.2833941498233094 0.39427208785596579 -0.38110166061468759 -0.29620994562745961 0.29826379291044225 0.3568530863710101 0.17332317572349989 0.38377596886674487 -0.15108825954246866 0.38462439487667993 -0.54744021029296097 -0.4390199243647806 -0.0055474572637752148 -0.20989655023425235 -0.12676421632675999 -0.40629057527724138 0.30345339803952864 0.07715705489247203 0.26611331171167674 -0.20166617126900449 -0.32864675947773631 0.36395423990160075 0.053127387528181365 0.39440812018698318 0.26110444966350776 0.38041879442103615 0.1532585937105258 -0.38711469459480013 -0.23501134238782642 -0.03340364155980844;0.25655534736351476 0.49301302416087317 0.23523592739635901 0.17107713022371995 -0.16591693563717214 0.41299549748519154 0.044894542756876682 -0.019079098022483677 0.37104485932092629 0.1164973763700605 0.39406416737076111 0.40344199427134653 0.35199743621574192 0.38446735037508956 0.55259153512419978 0.47735351908288043 0.089426285857773249 0.25609764280769232 -0.33646682650452486 0.011456958735772347 0.3979082222253903 0.037940968544821728 -0.17666367380689432 0.11557276166011994 -0.37406515129457912 -0.46917345977826785 0.14941136666782126 -0.15110362891128062 -0.29110009679464782 -0.21490993609163347 -0.24322335226173253;0.21191956148327715 0.016147635970673545 -0.083194839308955063 -0.18709765196535252 -0.26623839916357328 -0.28191064831353607 -0.56225005578575915 0.23657148066955214 0.18530043382226052 0.27745033234662553 -0.35825318556632052 0.004574780900077206 -0.55730332461977006 -0.1949694678473593 -0.44522653351616059 0.15910718920300801 -0.59542977128521457 0.4967909616447061 -0.42557276770682517 -0.10076912165419148 0.023447399598658259 -0.06268696033245548 -0.10591004331535775 0.019618632135321216 0.29206993737895598 0.37713250288753436 0.39444426678609773 0.15345611448399069 -0.67359692903514878 -0.17280640804963118 -0.28019535747205276;-0.41141890351825144 -0.42023855213828559 0.11800086827557084 -0.17885639114452853 0.084336454912566916 -0.1831285724995026 0.4091512099996612 0.32927293184052031 -0.025048998685120095 -0.51960747220706649 0.25600738043662974 -0.052166826626223843 -0.024045805355047821 -0.44270143945214979 0.48572835489288474 0.55126155597104698 0.37094984820177551 -0.4051695475441785 -0.29540781929054327 -0.14163528518215535 -0.12701179236468166 0.47068824767798134 0.37558705439350354 -0.2672686781570201 0.23779728168695771 -0.18128418358105278 0.11713888279808801 -0.020294492093923401 -0.16862667746692184 0.10178754916651653 -0.37438219146539042;-0.17785146632124099 -0.21464912905953618 0.36388837950183733 -0.52844239079517719 0.26188534670774688 0.46018521524698519 -0.092824754897899098 0.28897380134913619 0.10806886425385441 -0.32345535578258927 0.19361119091142961 0.25320874131946824 0.36779305290480996 0.36768753068826632 -0.27647293734228301 -0.14310043235272987 -0.41893568422439731 0.26897299502520594 0.054910902298174039 -0.041949427885110094 0.33322085657672507 -0.029549535090264867 -0.48645618885028702 0.3181678867755533 0.4986987016887765 0.20627457746710923 0.064338298327420856 0.41043923199768911 0.24092765053337731 0.073219455523409332 -0.43116434144437793;-0.29819177762759436 0.049802855829220838 0.4241024836347192 -0.20063861548006351 0.077250607521267445 -0.25507548900864635 0.1947442955359307 -0.22910395377943424 -0.1882537004587633 -0.53077828818989692 0.3622545902894691 -0.036050396105864871 -0.450024499397637 0.025834450271986373 0.47213750930939052 -0.29572926466444793 -0.33530090864523376 -0.30143493575146901 -0.59279353049847439 0.34806914856726157 0.34807509607998804 0.48271224652507211 -0.32415990163626351 -0.077980957138140392 0.20845002288478312 -0.13606488335034811 0.29801034380076402 -0.019407351066765326 -0.23286806117505857 0.12627157875594258 -0.1144179121146892;-0.53763198088588049 0.21216623224083897 -0.099815258400569234 -0.37171019857104859 0.15800909641757654 -0.11166714855119131 0.26464180441757784 -0.32715216351701876 0.42697019299418643 -0.14703644690678933 0.47562308183368718 0.28493285863690909 0.020991796040854473 -0.14757472241721176 -0.15651480655507322 0.2951700824433145 0.067144395600816795 0.4479383676353873 -0.16963787917411866 -0.15587321568958531 -0.2869682102062141 -0.26947142855768064 -0.45649012639594655 0.043429467917394063 -0.20339506316241343 -0.34030617123966478 -0.13341842987857153 -0.47182876648471789 0.16356283888912337 0.5405866569865061 -0.31155259302519878;0.030588985088363836 0.17260492088585094 0.32335661625399936 0.0079677888729035324 -0.31360990255707 0.54284550250395414 0.50648728487092887 0.34478228719527398 0.44445186727700298 0.062541218085438471 -0.2358543217851696 0.40157997740024626 0.32339043826867792 -0.084674486679695446 0.231504014245244 -0.61308904857960012 -0.42027480431327457 -0.18751917074712141 0.24861595223938307 -0.27014727690357343 0.20344611243075011 0.19834146506450454 0.35023601531794885 0.22108614111450481 -0.17145003330343728 0.40039612533039637 0.15470766629679181 -0.37415062399533422 -0.20371688758329443 0.51825891856209871 -0.33974397549746127;0.5735768089890998 -0.47844179907919249 0.0052171495918828595 -0.036971253588235449 -0.22706790911491068 -0.080736823625201543 0.2861683976169524 -0.25822731473183991 0.23197080076892523 -0.36632225674830604 -0.057883383151230219 -0.34150014102792225 0.30146451192753593 -0.35690846925721659 0.24012378110375501 -0.49842549426254301 -0.23861409882068968 0.11813105163611726 0.062805086720075148 -0.13580556943351946 -0.071746658852185508 0.22528675320873656 0.1620093972468285 -0.43292584839105375 -0.63270784857629891 0.60890136426537633 -0.37670948938116305 -0.094069182327847736 0.11670755643527682 -0.24730139654136418 -0.17081332649899;-0.31767451559925691 -0.2665620766902439 0.33513387700032005 -0.43146139230313807 0.27501922161770964 0.11400644687240578 0.35004031583914935 0.23400246131740154 -0.031717617481871838 -0.28095494644540442 0.14208933278269278 -0.43694481336824093 0.083771915067655883 -0.052261608846673288 -0.47259490058328407 -0.0063158604508157549 0.061344220828895714 -0.24439651503216461 0.61802262903321692 0.36325278825137203 0.14360923578549389 -0.14608311079859509 0.010129572279999052 -0.13321743278243445 -0.35043836652688271 -0.39225538615613986 0.52179620600041854 -0.23831803118100178 -0.3101821193218639 -0.23484006921429962 0.33060317745715057;0.24086461177626292 0.40084863339714905 -0.21222255385022351 0.22747141473812849 0.22953914161520228 -0.11780372421957448 0.25359896502324131 -0.034623308682000711 -0.39137240273271184 0.19843878675694485 0.19107059305966803 0.31252541072326895 0.071046944964108086 -0.053203594896342632 -0.3265181899026609 -0.038716548981143246 -0.33951934334422423 0.22307275617144937 -0.58158336670226884 -0.23318192728632953 -0.5746042907849277 0.60970296386395673 -0.27258742400558073 -0.075293091754759997 -0.037829295483550462 -0.39335844556499533 0.14895241439684928 -0.22021525024611116 -0.55856577888496817 -0.16429591637772722 -0.47401562347416626;0.30019480375688445 -0.093927506825817561 0.4436809094923751 0.0035195628070549402 0.35578606785321709 -0.29349239198381588 0.32204116239087771 -0.24802201071644803 0.12644855967729626 0.39454630419759723 0.40417386748051826 0.28724698306629515 -0.43911846027801377 0.11534265285526678 -0.046921925623489506 -0.14606003705700141 -0.10871821138937987 0.41241911486723865 -0.35157969985190951 0.25199399510050879 0.18788075793814188 0.58355690278473105 -0.28462887854614738 0.16826786701231286 0.57305082838767851 0.23107996854625629 0.4407255772105485 0.26460680712627938 0.49389099668603997 -0.27131176999417417 0.45220043620833839;0.013045596562504532 -0.041675171624424717 0.30587723479037332 0.45775159628799217 -0.26350632434524585 -0.12328396347794619 0.1056369320096935 -0.28844219108883806 -0.093027797068933868 -0.25712039615466992 -0.25412236912685809 0.438088641572285 -0.16119565526544938 0.21404859358623751 0.14581338026522531 0.36203457124038141 0.21405184371571184 0.077918268604992735 0.2570337207727475 -0.42124992129365924 -0.45231812341527433 -0.41458095891456792 0.10082042633918631 -0.032130829761830584 -0.10070986140335045 -0.17638314827124962 0.58462343930899929 -0.11789930539598382 -0.51673048125675203 0.52159543438110667 -0.24329665172827883;0.37730481647803743 -0.52977747216919702 0.37282471011937873 -0.56100150438240903 0.4831737299022994 -0.12063161351886428 -0.22831814727320399 0.24884637268046389 -0.24341127562909454 0.041398556551863808 0.34924673087270042 0.56054192735645891 0.080633785999020088 -0.17470913622812226 0.20375637849878972 0.041015881865264066 -0.3019582287936618 0.37115478010791647 0.18419271961447214 -0.40911734848561465 -0.47270547581889794 0.08443871501668497 -0.19567230514155703 -0.13112601676858932 -0.17482626711631549 0.36137198516738417 0.49286843025994576 0.26617611774382566 0.46613502412604885 0.3557805742493243 -0.44081222661980685;0.24496393638771297 -0.071673800039213212 0.27912872353609292 0.3301308064489718 0.55067190698507362 0.19883670166650835 0.01443852854325873 -0.37393657962812421 0.35570874700434302 -0.28219896424037688 -0.14745158276551967 -0.14050071636596353 -0.19236159535605607 -0.38770033115597652 -0.12580119445458751 0.1669509604226781 0.15583097703993903 0.14639858854104368 -0.25133346766678283 -0.20420595299549857 0.2804792766553233 0.3004304006126165 0.12980325665467071 -0.031389769840736562 -0.017513893998366406 -0.37190425083867806 -0.16040428902436785 -0.43569225900074449 -0.13034624333446052 -0.44538621873971856 0.44607054989899125;-0.25553462318952275 -0.050513322938407233 0.2243867830183342 -0.040312943709585769 0.46565282715495748 -0.41629618239486266 0.22079148206009874 -0.36431695408601367 0.17560834182317561 0.065538311755051107 0.12632576510367419 -0.76292597101576798 0.096823664614298713 -0.31237002285534687 0.024259387658033801 0.4040083206367116 0.72018526831713503 0.15952962493531056 -0.45903082953873753 -0.0023398218674635699 0.27215385613786258 0.041503046161938457 0.46178173317202681 0.33994039206174315 0.21782505601763871 -0.18426500800899701 0.22664272250985493 0.40433493145037497 -0.27831821381434596 0.48456789480175327 -0.46693034778484688;0.47458236719144048 0.093732942370375799 -0.0020464586078082687 -0.45041274910215989 0.062603242462514336 0.062083505968580477 0.37598976003431078 -0.44611615254059173 -0.43340259154272603 0.20448135357411301 -0.28070535832534044 -0.3665732039344603 -0.39404787522433871 0.51413364849295362 0.21792505755378838 -0.38706271923607749 -0.18781770318905158 -0.39941529579688761 0.30228401999092075 -0.19988793791151435 0.077879115055999121 -0.10150924355652453 0.36980800989942264 0.40397417337389491 -0.21828413819153034 0.22798023581250168 0.36406207576439797 0.23556538514946623 -0.19517649780905846 -0.059741994138470728 -0.2199944511717972;0.4177643397336675 0.30326251494131723 0.23516350818523071 -0.59502058193775376 0.4004766485655808 0.26519444096190653 0.46304833743309576 0.57125757036329616 0.15077983898544284 0.10269653036994537 0.13638486765659791 0.50296664336957297 -0.36345244032663548 0.249537067086881 -0.48574069340840353 0.34764813630650393 -0.062211829188225404 0.061068913641581159 0.34292069850190177 0.29427936051581172 0.16168358995777421 -0.32106266467147948 -0.23529792442480343 -0.51674504145345257 0.25743049078004576 0.049866519373769083 -0.2554942545697943 -0.32145515063587249 -0.31092318630863541 -0.23491632027688228 -0.31297612950044429;0.37634939584295352 0.1931539146863567 0.65269661261508882 -0.3347784585747216 -0.47221696420143744 0.01220632676073175 0.17108721562106033 0.33407708002331965 -0.55546855561686004 -0.19483261379614539 0.10968134751938091 0.30261695765974445 0.37345155369634686 -0.14773166237825092 -0.068743241050714526 0.032213304694058621 -0.063804915182153726 0.26303581079113691 0.12660566731408385 0.025120804849671809 0.42304244369963911 0.13410316467619193 0.22482641576250889 -0.31326343038274218 -0.041328778698297756 0.34202665229909224 0.43144627410119224 -0.66935475666100763 0.46829939759164896 -0.14473470170743119 -0.33561010723470147;0.45461984933063515 0.21838007852416913 0.14282767596092055 -0.22531824741557305 0.29615580089731897 -0.36761116436090879 0.029550020877786222 -0.26595729563636161 -0.013743674356788565 0.17821402326615471 0.033756244491629971 0.11824339553799242 0.4930834436347652 0.067414127885697062 -0.47837591833673759 -0.27481037238509565 0.71600062982668833 -0.11862302337952105 0.49900154671728653 -0.13064842436704499 0.61948065648737372 -0.12182813136109874 0.14080444916682 0.15396566748662086 0.57474262421055478 -0.52297507135772225 -0.3657617935262602 0.21612087999790885 0.069406796548323504 -0.24914994532485676 0.17428461864028916;-0.38218837342694095 -0.02803381457750646 -0.049850620566612762 0.37771309988976393 -0.37179077575912667 -0.57450637103697122 0.11506802118935715 -0.42685302601870506 0.44492363184488126 0.059542521884462768 0.31473033211256612 -0.43654810019733292 -0.29977612714791424 0.29666050878236377 0.13969544469668993 0.081359033661416461 -0.29525117993367228 0.036182912073431099 -0.25575692446552556 -0.54648322616848299 0.081514667554622264 0.04533249716178582 0.49050203889525357 0.3744890810638315 0.14587607684513684 0.058812094915231969 0.012211994773703596 0.2561220527609086 -0.19583856832500879 -0.113362599694845 0.24087558783205065;0.010382203789899933 0.27677370852851374 0.10015565516611405 0.19696472963956374 -0.24619342793419244 0.21146991457693146 -0.2945507666296393 0.44386396223076791 0.36126119024065062 0.045330262231113062 0.6086710343094266 0.1859690515984472 -0.25206974576106955 0.33598880361831346 -0.26448539732157961 -0.2248851779080305 0.38735975872684048 -0.33976061009170661 0.2638031173984039 0.31348401663150471 0.39107872251016557 0.35047059099411371 -0.27275782302182883 0.47490210831709273 -0.33150016375132191 0.42204500455474947 0.033203236226363113 0.29207538295983593 0.095349234248148673 0.36673096408184941 0.01154871829259347;0.24847760278700878 0.11609691138803004 0.42014921614708184 0.08613789802760094 0.32383913552951166 -0.30543123725411681 -0.28312939919937113 -0.42903153236526093 0.19502729148490847 -0.29915573030471698 0.39496393362632953 -0.41395338872458504 0.41389415378655497 0.0053204037281411008 -0.37610329211889387 -0.38615709134093074 0.31415643125651316 -0.27589280570475672 -0.13822094573603416 0.091537824411094884 -0.12138219466145386 0.09935705141816098 0.28277694398997721 -0.35236574576347923 0.15691866391860002 -0.30522953185787383 -0.012911748578483795 0.32220610815155293 0.16448289029229396 0.30863356200285585 -0.036509076139810706;0.28907093005830431 -0.21529209898814949 0.37695468905420132 0.41591751407998395 0.070124192534478297 0.15505450336052243 0.087176383449949671 -0.23738457997048384 0.12766879369179515 0.30245026918428547 0.35180152813319987 -0.18430160145628777 -0.27634133621246243 -0.21964900922980529 -0.24845860844853548 -0.0082108529109645376 0.43112655235261171 0.39433600540075991 -0.09133591232494645 -0.39831825370077772 -0.33466007503020678 0.2710382905062988 0.25481005612663266 -0.14942820987733771 0.32226270820250741 0.44370790979084895 -0.54354732932972849 -0.35575120168317753 -0.37597570145890291 0.01113164271576193 0.31144546253245847;-0.27845439629026641 0.40323651540243899 -0.047607104858213407 -0.0051604215877201435 -0.17902379940999669 0.50624186653842196 0.28293760158785553 -0.10530793971743636 -0.28854987245437574 -0.0051440004122217898 -0.48487389091940203 -0.3071627026829486 0.29290265474514376 0.25563925670251486 -0.4632022585671085 0.13529038479000338 0.024166748577695862 0.39199455828567803 0.25367570162026082 0.074116221396258369 0.068721925590926977 -0.0030396335700912732 -0.091356645279195375 0.44702791444267503 -0.52012587750169792 0.34628376929006321 0.18991009321285957 0.36206167321030908 0.42713480095935868 -0.59183752615193863 0.088970355526194589;0.10335816680381231 0.42625254570405169 0.035687656381162607 -0.52334806360615127 0.27767432812961107 0.24149967367361955 -0.17595439384740194 0.51940100433026559 -0.20400324009361312 0.47731910434917624 0.25783896288501174 -0.38248814053797309 0.050779544882094928 0.23808899808365797 -0.55398530597706575 -0.17300086454601313 -0.14912378620248681 0.24385733521348257 -0.38053437072901475 -0.44784021373271438 -0.30314331243861292 -0.12157298070650251 -0.15961827110180712 -0.29426031211393994 -0.19758824979450906 0.4143522079027912 -0.31126814420542021 -0.52189441645240209 0.25239901988896341 0.066731601193544765 0.32228677960265262;0.2886587509873923 0.25927741875091354 0.076234194616002643 -0.10725154355825034 -0.51849813749328322 -0.017485976229195715 -0.066017358456030614 0.50500207322269797 -0.33490435696475257 -0.38256813923892069 -0.28696471246914734 -0.32641616537601398 -0.14216915815764242 -0.034435464669649453 -0.036969173990164535 -0.23184083597546662 0.14893708796162905 -0.35541127329605071 0.054814730703279808 -0.52429397066294603 0.10095154658053679 0.35466679443938554 -0.39477405288839745 -0.30063326418853398 0.31754079539662794 0.17870655583847708 -0.31486188150710198 -0.31978985577112951 -0.59186753267230541 0.20426611172343512 0.13765389587945864;0.43524713832925849 -0.038644227695852434 -0.27059377578006283 -0.12498330705697498 -0.066901185989355849 0.13555520974138022 -0.2314724940250707 -0.54212576704439053 -0.54842236615657558 0.033676917161964734 0.36298151878983276 0.35479121089550175 -0.32604416989054769 -0.12699125468506406 -0.03202605405667211 0.03643277690315222 -0.38260795039247497 -0.093426776958692101 0.14899725817448967 -0.21999389000640041 -0.13781391927536235 0.50917186264116499 -0.46069530604250719 -0.11251897327034883 -0.26638713886907772 0.013615795957486684 0.57542218674311207 -0.079544285431536868 0.19651867876784904 -0.28153189261939038 -0.3225243077441185;0.24468936322447546 -0.32321104790694294 0.0083192585740027442 -0.023090063093286414 0.040327708809809668 0.42727511686876607 -0.17456903329671775 -0.26454014164315642 0.041712527812829067 -0.010980462584730396 -0.33905325436956996 0.68308028835122736 0.29826249774610791 -0.43460316491043699 0.17449296991199129 0.11373976979364311 0.10968316232971423 -0.7076034266750153 0.27562243734142761 -0.015527477507286017 0.059245213039823816 -0.30835476868749462 -0.20174618020060134 -0.30120807197051436 -0.17542274671102825 -0.19859654422182921 -0.3575222477724383 -0.47877027345979217 -0.14057642454207386 0.5421635440495618 -0.68586637908101133;-0.56990479491641877 0.069391234648526021 0.068104730879237463 0.22497217300910027 0.036998525378637459 0.042242452786764043 -0.075931173751072181 0.28347482407374158 -0.21704584726797685 0.35164279006859284 -0.10071019166292933 -0.11883368317641833 0.55723385756942057 -0.55956556115246758 0.39400495993144641 -0.19377857017889658 -0.11356639066634412 0.095446707943007789 0.53809103333950048 -0.34714640725806711 0.55721688711981543 0.16065329253197291 -0.29662805145924376 -0.47893945594382414 -0.40994106552933407 -0.030483492646306592 -0.17203331452976006 -0.21034877815707384 -0.039825278780069882 -0.058948191991819755 -0.12964915381089973;0.1554377588044778 0.41029159597815679 0.41750660483879515 -0.079572753891053144 0.47578096645843349 -0.45104007110066846 -0.51626038732401636 -0.3168562060281962 -0.012804441618313758 0.18953678066747973 -0.3319713170324784 0.23266649850363771 -0.38612497948126595 -0.0011496931326931978 -0.23090883989206878 0.25390961475816942 -0.22815827676572525 -0.0022549720568775296 0.14398583100740128 0.68174287029348835 0.25324433523313372 -0.067950402479942829 -0.58109302261186968 -0.039479470929122434 -0.080248259550283516 0.25459918591211084 -0.28663036777694417 0.22937758660767638 0.55114001169325988 -0.57035668108785686 0.25723026431599733;-0.65935983395740261 0.36231267739167511 0.26143853335661077 0.35641412332906997 0.031988356293855214 -0.35177616826841179 -0.34493124780845846 0.046288653307087188 -0.35660773620135572 0.031637116806644536 0.36809739581356127 -0.10918457297303608 0.43215288560703974 0.12383572637378291 -0.12656357097724918 0.10377587582344519 -0.14144230405611949 0.37493873143500733 0.45852281072644824 0.3898886695894152 -0.25857526379094625 0.20862838041732099 -0.50682288519209484 -0.040983397589797924 0.021222063491747861 0.17101917392551882 0.22710279359051433 0.52035149495769073 -0.18776585704003151 0.32157957289961464 -0.34216865708826955;-0.4188607281724786 0.45962655258213053 0.472157993798691 0.38466379970301307 -0.15522275741441241 -0.42086009777407124 -0.37185917966600751 -0.46626525096539229 -0.68562406930644282 -0.23776177911061033 -0.22347881867285799 -0.19102989757309377 -0.20305709906626151 -0.60383667954726361 0.0085519284405720167 0.59872611170284362 -0.1828705577727153 0.23853731049435728 0.26773747468871084 -0.1255836541677943 0.35449144729683801 0.022184086063428594 0.16053496362946537 -0.39074587864138366 -0.33662623438424893 0.14238654838961651 -0.15977927096932398 -0.10081137581723545 -0.43776391002435927 -0.49058690736303306 0.44208623733710767;0.23922830624268424 0.23082993409163385 -0.31972787548138393 -0.32504766440943378 -0.40236015662030922 0.06661255801444077 -0.23848295528278687 -0.088958774974838256 0.13903553416795214 0.4602426831041565 0.34575001983430997 -0.46790572850142415 -0.17611939593430029 0.12014473847283638 0.51335975829077629 0.53077673947528781 0.45293355095401999 0.45373960813986225 -0.22411938535017104 -0.3528504802454866 -0.17037686383280518 0.27919105288445933 0.032825051750037589 -0.16695761677249404 -0.011822182463020463 0.16188873375851834 0.11138757217327243 -0.35277336318999269 0.58932448419524819 0.0059815183183842286 0.11595989763753606;0.45773362389586725 0.51179367520891184 -0.1297915247348024 0.092509181897430029 -0.35894612363329415 -0.20755674965769425 0.40151280374879161 0.27700504499481426 -0.02111447231243551 -0.010492472363446222 0.27471066519101595 -0.46028604514270788 -0.06417426456217501 -0.42693315544445687 0.039476707850484398 -0.14645396205334762 0.3216406533904968 -0.59325941275518279 -0.044250624191257436 0.25744013545400901 0.020802597108364927 -0.65536691697231808 -0.44860047385252955 0.23116205970928619 0.36235839243810825 0.62726008483021967 -0.49901078782241592 0.26990644911308154 0.35995750614985911 -0.072318054418984257 -0.022097092554846352;0.12341859073966802 -0.1811684482091962 0.44149877633902174 0.25362827664090781 -0.34255979992577001 -0.028468562616753363 -0.23625544469645174 0.31244683763261744 -0.65819031642619874 -0.33649150766915453 -0.54595460241469829 -0.55578354363322746 0.075608410601652853 -0.18029737318054537 0.19057466867129941 0.35741469659319774 0.25830870994850275 0.15855825493856102 -0.22385232091656371 -0.14942907549921722 -0.62708480101395625 -0.19683546137096161 -0.060175634851448133 0.28595109739388475 0.06359879661239802 -0.5400236694357522 -0.043269885794835164 0.4108314561373419 -0.084994184285189942 -0.12744450425767348 -0.14807308339901246;-0.067720357011254284 -0.09075123781538065 -0.21843461638920669 -0.38269502650558618 -0.37811359018977869 0.092406171157371819 -0.28296937896234464 0.1893413505072416 -0.34554739442112392 -0.06019352976788879 -0.38180743251258753 -0.25120024793989615 0.34923918989783787 0.36168453831249181 -0.075879150218357477 0.056118543990506864 -0.37005111307548749 0.046290079888421792 -0.77848912512102542 -0.44349207849789452 -0.82919229473477341 0.08790480820517925 0.60277076783031691 0.36992308639983623 -0.097418381422454514 0.16754324771070916 -0.39341238266312684 -0.26843413522803017 -0.35536077078656886 -0.64573620309730095 -0.49184149646000613;-0.039284960342640229 0.49072056052126106 0.20063740997387447 -0.24493014523668061 -0.25249091759785841 -0.17536324310032944 0.27462036156244218 -0.20616281324648736 0.68835029748089338 0.49721403124374303 -0.2808869642738856 -0.24088185872259191 -0.040286455595360669 0.15876352636754676 0.02252975404539594 0.32701038465956084 0.25686890778582094 0.076243949941495442 0.10987374693425127 0.35654327141504794 0.26440040872367171 0.31964367377806813 0.43405536332328643 -0.3257900798757889 0.10885780627489292 0.17803759869982103 -0.21232637213844238 -0.48083683368251268 0.56722345863511037 0.26468678735866191 0.44017011160815767;-0.14515590998862493 0.39317587885603711 0.41966868381969602 -0.36306094187663812 0.085305784598362536 0.046071512210938401 -0.38452322993763915 0.24956274416544894 -0.42323071583790428 0.084141698985635408 0.17941151273759876 -0.0041930385443468693 0.037002138073395245 0.28020375776213796 0.54066744112385301 0.29518145528468487 -0.27285259916445564 -0.35038236405923001 0.080445589806829088 0.34536497181396725 0.20966827495317458 -0.44760471484575853 0.35624723965097072 -0.2413312465912052 -0.43669754652337939 -0.50321075619593514 -0.034213903787853772 -0.086432094177908841 0.090485549630685391 -0.03584852870715502 -0.26815341769075651;-0.32112249047316521 0.38657838989513371 -0.19392888518276349 0.26847848021041149 0.13121278547578585 0.29993311314089027 -0.093332240910734096 0.5214812660399557 -0.44467674403702412 -0.01947040191967235 -0.30936095428074584 0.44422889082563832 0.38713399866558318 -0.039580887375087415 -0.1084138404220478 0.55765344703338815 -0.17133060054212917 0.16968566333712129 0.1070623827366053 -0.0098107801780543402 0.38485018293990314 0.408161722033345 -0.0025615545206549573 -0.50552398419707167 0.25358748213245674 0.21568293269636907 -0.059968637464331856 -0.20123335000925083 -0.31389962793324339 0.38325185198859568 -0.19144889440894111;0.074437236370230475 -0.093025910817952695 -0.34554802499842735 0.28391187558256376 -0.34821475208529884 0.025636083783491224 0.42243680380831888 -0.26317567291887012 -0.28373194133514845 0.12019069463259353 -0.059112079691341378 0.34422044979945104 -0.48148768732469804 -0.21913100436447427 0.47885105523416682 0.49503983640993959 -0.53138312783602559 0.36988132314956179 -0.22531343982956545 -0.25609103531130084 -0.057465415620990619 -0.06556050787449258 0.31786835665850283 -0.35053965488244226 -0.31483385028408384 -0.37480006382459674 0.25138656403495213 0.21418629885568585 -0.23604045356872921 -0.30378038837840338 0.13702663381850566;0.25777386824387793 -0.29383394086733422 -0.0051395457714793471 -0.33126778562765669 0.23893744762715094 0.30673098675140065 -0.26432541287131373 0.53296739527909165 0.52188090223210404 0.29616142788136118 -0.48767430003040052 -0.4399739179166654 -0.16265205932691898 0.19036381401701566 0.42544033130181846 0.26681820187791505 0.17820740740596097 0.054057724966794597 0.52736995102876216 -0.57979935528245052 0.29267593752805127 0.23200520325982257 0.42250222661771292 0.42582442684144933 0.023419415425324584 -0.23242213684073268 0.21587731517483244 0.22637385955811867 -0.16285559533613386 -0.05157805014405404 -0.17009752808024753;-0.24270064377080006 -0.070456814924538577 -0.43054906843983948 -0.34759401572061188 -0.50010862338461692 -0.12947624534239865 0.17760779783052069 -0.10011329032532877 0.54965650780041486 -0.30179399930283834 0.13278158448052599 0.1417452680380771 0.032960789800696527 0.45228235080704859 0.10151957101642338 0.062256467570066115 -0.52893109939597349 0.58293200754010688 -0.39606061602511083 0.077507016694577199 0.15865422923531317 0.13761567540669159 0.44015080060918704 0.11282654242362343 -0.00055272804131321592 0.4260164675394742 0.13885274565123407 0.40367579670161635 -0.20773032176161937 0.40636820468601248 -0.40326003310854297;-0.046151425269625221 -0.32457519519668887 0.05139834814813244 0.48176044699403131 0.16926577434843246 0.29530184351943273 -0.34765960107527 0.49627982727475672 -0.15462110995627512 0.052098120565984139 -0.17279923222512292 -0.43517189152114188 -0.34646267263046754 0.25921242356176316 -0.12768129366635148 -0.064958734650290631 0.25703004577348199 -0.10838550508336471 -0.080239614870391524 0.35763503497234556 0.16207604776707576 0.4905191923074671 -0.49749448387570822 0.25497305259585473 -0.12779342327300769 -0.44275595280091257 0.14523953095711656 -0.7001322734882176 -0.25886753328186751 0.54289903531055461 -0.38049057964455246;0.16765635651078109 -0.0077272833285952974 -0.13968894747189106 -0.06622559820954417 -0.52318169688150318 -0.23893877148424783 0.27589838523180377 0.087964576972320102 0.22507919156171893 -0.27619816015082627 -0.13173173067020652 -0.49548288854948552 0.36437500188445876 -0.012412853308535672 -0.46354115410620339 0.48281447812913136 -0.51917653603118374 0.049282410551933047 -0.33060813756665336 0.26185676844439087 -0.54715531304765563 -0.23387152381963092 -0.036383156904936952 -0.32817065243907623 0.14318814938469807 0.38400930232163938 -0.19421562848703999 0.39414354455414813 -0.100124563247 -0.037329343611532104 -0.39216100632586459;-0.15840978923548749 0.050048292507236303 0.22036287259724557 -0.27755156311973955 -0.25562022955530733 -0.098002644983458717 -0.12168553671897124 -0.33224927376308927 -0.12277419766898995 0.2444004974596386 0.029710982567068465 0.59693280575272578 -0.020529413114523123 0.36029675564493824 -0.39779157816375044 -0.26055114440244159 0.37531767440444364 0.23018333965640894 0.18002159316057204 -0.065019482632521983 0.77219493004603734 -0.4909036290420043 0.17112819894461265 0.21184814074555119 0.49079127854717641 -0.44938025214448901 -0.5610535923144111 0.12282947492380643 0.43889333775237327 0.35291319747326999 0.16351937290258636;-0.075580639726662013 -0.035627755626262386 0.46528116307352729 0.36736533303009006 0.22990134337004425 -0.021346657123789293 0.16205467940090995 -0.40543211041855864 -0.35974816359512946 0.38099685838669728 -0.19008114237950924 -0.42989094962826407 -0.27712646914002492 0.0262613185867497 0.47199134094207029 -0.39201506597424807 -0.16299805318376295 -0.57438525160098652 -0.16301924821917652 0.26920421788217835 -0.26537105954196566 -0.27043204589081921 0.44597790667425968 0.38705322387562296 -0.35118182035293682 0.23551890108378601 -0.06472709733118065 0.41420005283148814 0.25695953558877299 0.069592220757933101 -0.015192697371586197;-0.59620658344997868 0.25339684004101842 -0.04648345968239203 0.3491470269312294 -0.55685267350945744 0.26710891736882891 0.014565963756205835 -0.35314213249536885 -0.081803454667421657 -0.28538703808842003 -0.38466836552156108 0.24025287730927294 0.024889223245658763 0.036891322434028311 -0.16899054683979445 0.58968204512346711 -0.18618019842742403 0.013593249186895773 -0.34358197361345744 0.23033859739471915 -0.0073988437510039817 0.4386096191252653 -0.54295710278777598 -0.0013520577636850824 0.084581473696507051 -0.20427702548474244 -0.20743485671374876 -0.15093838128261938 0.2910164455494334 0.20549077208499936 0.089809475060639007;-0.063397005798381964 0.19827689284020811 0.39354654300912006 -0.74058576708354906 0.34879349660588843 -0.20414945528524553 0.26168327721369405 0.25174344628258188 0.26386492502826409 0.13498511318561807 0.2413742948678253 0.11673076807121444 0.27831348733627348 -0.18011527380946266 0.35263813799282984 -0.36588623768354045 0.3946956773524089 0.31183866431520979 -0.027548483968256762 0.30716689326825214 -0.42364170973381338 -0.51264968722178839 0.49738671754965308 0.066813796515607718 -0.2484264723716576 0.36898883632561735 0.14295162845028173 -0.22318345995452471 -0.30594449364736376 -0.29352731600091281 -0.39177497968734043;-0.040409592022188079 0.25376086444585672 -0.24356805435267109 0.58915688512087672 0.41656494635815794 0.041470940338657031 -0.28730054977867114 0.20213635236199476 -0.40845897644655443 -0.18917378712852823 -0.57164174736886608 -0.29449167563238887 -0.10048911126639649 0.10405836481228201 -0.56108442050450003 -0.46428159043667139 0.12774769066312328 -0.079911155007020895 -0.34028508233158816 0.025627794946165915 -0.12076355239024503 -0.50903786023518682 -0.28175667555417799 -0.13727302247148565 -0.47685032010895184 0.25721795518143226 -0.29689292809033774 -0.31535984646317405 0.20573570800236718 -0.21653903841402217 -0.41247096057753241;-0.13944476812825421 0.33335222626574373 0.22929994573150922 -0.22960348858361701 0.27633990461640362 0.12899602246074096 -0.23904547868319026 0.17483289520998099 0.36658294329912372 -0.41275111795272762 0.29102367737552981 -0.5152707580805751 0.29160084169023204 0.17614184059890711 0.46464824933845228 -0.51506977128255305 -0.33557700306295041 -0.18393920895536681 0.46294723756398981 -0.30598596532541206 0.34394958216170524 -0.17150845969153189 -0.022483747277455869 -0.22361119808311025 -0.011634320498879457 0.49200189603365213 -0.10983048437941567 0.031864231437475625 0.31520296958535665 -0.058492307461213477 -0.28370113417208909;-0.12780076800983473 -0.36311558867868865 0.39686029379196991 0.19793728571831418 -0.12678929066249753 -0.53196912707011457 -0.28992550453800686 0.24945362427596215 -0.14331735050684669 -0.017197439547837083 -0.35018755822808162 -0.39459127642825753 0.18588237638329097 0.22518659069800653 -0.27790986467311868 -0.50808472488544931 0.45349377437993688 -0.40516432086290316 0.12599822755038834 -0.21418878368632563 0.078742664125322021 -0.057678542030629908 -0.3588812913252532 -0.21089633439477545 0.039197921274946153 -0.53184836355176668 -0.094193684697516919 -0.33447668153788962 -0.18514465706330849 0.22895021344852673 0.10160757355792842;0.074519362104832829 0.46407238465826067 0.099464124814723456 0.48140849180169232 0.30111271464261941 -0.14643905333163632 -0.095846550776328435 -0.057458902613724078 -0.1902828943270124 -0.34790418327412714 0.32040705083381055 0.46159751737979754 0.32764515146265238 0.41082176144954363 0.32508365995436589 -0.41458112680450526 0.21278291255402407 0.14313445040424772 0.3555036027205688 0.43876611476802863 0.27355765462321502 -0.20187596409423744 -0.45298690150106619 0.30508491051573972 0.29647682518526736 -0.59314978840293353 0.21886617131388381 0.090697842716630131 -0.018700097967669155 0.23452251501420748 -0.33028952019889313;-0.072739582646801249 -0.16416810972856943 0.5196555962394952 -0.48407457014808636 -0.26309435416958671 0.041460858520437516 0.025916082331437648 -0.042453041432167035 -0.22049467498702646 0.14612066121287026 0.37787356100917358 -0.083601347110430241 -0.15352232527510751 0.50641737590391322 0.5203676586860756 -0.389968180697711 0.14616583301834327 0.38309146193355748 -0.28523786212524616 0.58488572633732749 0.15160677966844133 0.22696106748476078 0.064920050685309247 -0.28042649310209367 -0.34006362611878277 0.21007468086873335 -0.59652776208114267 -0.018208201961251003 0.068945831089242515 -0.39758915446201515 -0.027267620421196834;-0.3212250340445908 -0.23781146770577907 0.36905265823402655 -0.35428047670902574 -0.30853962291233866 -0.25620782816388604 0.23418433516917223 -0.39974463789754966 0.16069617832556604 0.19538178083210975 -0.29550798685334778 0.16580128665663366 -0.12240943107604524 -0.444551393766286 -0.26375317324359004 0.438250457811382 0.097657722886239889 -0.078891665217898782 -0.074740317877746057 -0.19207017642851543 0.49645611660661226 0.22742516553637449 -0.42526252507669088 -0.27328113187363995 0.059912288217395415 -0.41756320764119642 -0.30018893053296486 -0.63016729347980005 0.34125128668146548 -0.20418139454716344 -0.29451107361364637;-0.42377110788369454 0.10368307478960316 0.15938759109203704 0.23766224279681372 0.127173466249385 0.32478477982728587 -0.47294451401003917 -0.075293228167519655 0.27959322517667612 0.45473452475757548 -0.20294235870629684 0.36723448577818091 -0.095123570500563887 -0.10776576474543113 -0.27837992397840944 0.42778932863540364 -0.14181094022128657 0.041554655960904796 0.01168464208214889 0.14387316592738975 0.20938289955720837 -0.11693065530935914 0.2308661182973677 -0.49245917165355269 -0.44445965436343327 -0.35916758752005795 0.44582579538237616 -0.39315541968484585 0.40673979020414469 -0.20779294160582984 -0.30421182564315435;0.42273352212395904 -0.39535136103888985 0.36904369816480537 0.41433351941899405 -0.1872163570468757 -0.24415083079291117 0.044131478284543356 0.31295861782453188 -0.52281145140787866 0.16573475043691299 0.15150298833527681 0.21116927033680361 0.26212429931222642 -0.28811226565243142 -0.074957226709870414 0.43130263055167539 0.3002558132582348 -0.19113227052767529 -0.41162739041735019 -0.31468862177766072 0.32020768233890551 -0.10850833875387439 -0.22920750507359838 0.1970827048577681 0.02336852894202103 -0.3045173774366432 -0.25908528678414805 0.35727160068482322 0.13694391022323249 -0.38041257589023991 -0.20471591940293735;-0.037169043875699859 0.20901366037632424 -0.1175432400196265 0.33432439582178508 -0.46553185678234693 0.18431945199493524 -0.45683788445915896 0.44413918884352371 -0.0058550349326184862 -0.15654852363398825 -0.2966890909394867 -0.47881397395898306 0.16672893088172669 -0.27599852911429401 -0.031099415434031823 0.39123150423285002 0.0073208732757206931 0.016638874806461888 -0.42044339184149515 -0.67844577563131803 -0.094200402193283989 -0.49399440208000017 -0.07055229639708667 0.44784603201986789 0.15600804565794141 0.045854864055119064 -0.31917113340064107 0.18925400352181687 0.031669689091054651 0.16972279139299373 0.072126268269600988;0.4091492919900136 -0.63481998411284746 0.26331559149183209 -0.39761770923130146 0.063312930311236429 -0.42738574154847969 0.12107234352524134 -0.4784097159838534 0.17444429987182128 0.52303264200897348 -0.0056130358233245064 -0.34784869093820886 -0.14267259493554296 0.45019687675076725 -0.10680215484349311 0.11288968685170142 0.096629726470376598 0.25357923408818261 0.23561237031268292 -0.28616019319229724 -0.40621574726365117 0.030460402111928193 -0.23541751470957453 -0.10226369542449167 0.10427890736551805 0.38967777602383596 0.17761427031353702 0.41375413291907132 -0.01198748647877136 -0.050108064286356592 -0.46025943367945404;0.017495106170576265 -0.30608902696732482 0.39166731846677827 -0.049112628607309444 0.26772653868822066 0.11515866287334697 0.12851128790104871 -0.31973850006372984 0.585008890580481 0.17471027415509302 0.19719386484966508 -0.19582287771328552 0.14849167155357337 0.58327232888776159 0.22870135205439729 -0.017593217718427843 -0.0509723369897217 -0.33279588977196572 -0.47788876782334905 0.43733552246664792 0.44754684198323258 0.45946940918092977 -0.3839993085801362 0.38622273638570631 0.43936219945452021 -0.21577359105813021 0.16528081942820891 0.17509997923946971 -0.18763003697856037 0.32989663466778774 0.46020393586189862;0.25695169540740848 -0.38015068741272812 0.32449272407608681 -0.1666023584554884 -0.050528944152620242 0.12433032812405663 -0.41984838982693456 0.40557910167434524 -0.14176334861392922 0.013547493557748045 0.53721418298818568 -0.17572202491953129 0.53168882618517066 0.25626003383986667 -0.1264778561395235 0.31208166288359057 -0.32567341605486033 -0.27370860707154593 -0.59171597914741969 0.039598003513848873 -0.13726274742372108 0.40258623154578049 0.075820471574343018 -0.16732218865978457 -0.28396048487849801 -0.049862807065276654 0.38014562493640058 0.17665454997185864 0.35898957245332452 -0.10665161382067613 0.35643106877067654;0.4051474171309799 0.30613603302520248 0.12061857770911523 0.28246167439251191 0.20839164437613075 0.11773193921645188 -0.17919598945785728 -0.44027630058363199 0.18608308350692687 0.0098837023246685519 0.35693743245931631 0.30414737749504378 0.057944843764248223 0.091879151155155561 0.31398952638904931 0.3467705902149904 -0.16607779077861734 0.43133870977626981 -0.18161860884372458 -0.21417669962380459 0.42544701319921985 -0.012878383525991067 -0.42479166028177939 0.073290535477733648 0.4967205196853996 -0.57104278813752907 0.28468646715532459 0.34168146440131741 0.082028581595389602 -0.28526433608980328 -0.28709914497725308;0.025312115449974366 0.39811855557893278 0.19647766080732171 -0.27667364763976532 0.31103160450581613 -0.068244854270690727 -0.3276759618983025 -0.42886252906856803 -0.010319117985319627 -0.13163250857427078 0.18680105482834458 0.18202184725483025 0.22078060341126871 -0.40243984182473896 0.39082282015816339 0.24998273967404266 0.010704770843335529 -0.34225761150262463 -0.19933821881309818 -0.2369179261571637 -0.32413324002024624 0.061921886355921468 -0.19523001093280828 -0.29549859381502991 0.32829054619466802 0.040064843911493939 -0.14025395393981949 -0.26990092046221781 -0.37700365490231647 0.25818524129396686 -0.16626933501732299;-0.28662919294018585 0.47008998478792186 -0.60617289445426836 -0.038782799269834703 -0.23285387457013562 -0.04136213570523261 0.074559181554869861 -0.13092642068779073 0.26682573149222066 -0.083968979612878761 -0.40633169640625155 0.17509293864950884 -0.63273639657560998 0.1033327539188397 -0.49487147452625868 0.23342082019522833 0.27652502724034733 -0.18948125937119509 -0.51853545419652325 -0.52348392820134249 -0.10962041164956665 0.44559693288593416 -0.21046137094140416 0.19701036797298599 0.39906595642383685 -0.15470976873604605 -0.19045762770715846 0.31206455116335863 -0.036370016320787193 0.27533147582526468 0.01211489760576721;-0.54549658720361993 -0.21830300738587444 0.2368152977820922 -0.16188318999901935 -0.089747324779038823 -0.088786394633703844 -0.50236840821710105 0.30089892715685274 -0.42292761092847847 -0.59661774500613873 0.22896459472615827 0.5757209813687364 0.010108697923725452 0.34278599968955448 -0.54095288955341247 0.26477871632737704 -0.40014665267896599 -0.65339605045470517 -0.65924456805465992 -0.01471385478661371 -0.39198378995094463 -0.14885761203138279 -0.050889012874564835 0.27966746861016417 -0.025588226824980558 0.14587189599542452 0.40493134813662357 -0.1616621434651867 0.0035895160713986622 -0.27687224189835163 0.20118260146476502;0.36893181697293315 0.050766193532681941 0.11227683808500921 0.39964359326199839 0.39075045129145247 -0.39671105236904242 -0.21747330047024657 0.0091931194076147055 0.28390301465125467 0.20145441822716523 -0.42216101159512515 -0.083231786557915424 -0.48057436164998285 0.0095605831663871585 -0.059028920152217744 0.052548642979213724 -0.45975505171365427 -0.29938802205254988 -0.44277715396103212 -0.1214203129460706 -0.29843730467599949 0.031766549668907768 0.13033337854050966 0.30487409932342768 -0.2269654800619926 0.41722521966558185 0.26985280905735654 -0.087754174025986342 0.44508795647344168 -0.39518739900013838 -0.12244714869397819;0.04190969057015928 0.17060295178345403 -0.3252735426261904 0.20037732118342177 0.53614192891338863 0.21668269532686008 0.0043889252638203858 -0.15784639689622162 0.39430930746490134 -0.21841366480412047 0.3373647350603326 0.27637015750115107 -0.61904900731157364 -0.30745011749948881 -0.27076597895173915 0.26263663062362153 0.054264413097382509 0.43168944953930677 -0.49691753228704216 -0.31441265147647623 0.044275007433045389 -0.31688615478529397 -0.030490626433321094 0.34521330105922449 0.057576211728443148 -0.26824620845892305 0.48024497718773201 -0.098386023799737765 -0.11502014104460148 0.15673587589821281 -0.29733632567763479;-0.42868302033005246 0.38935765650286597 0.40611052106795564 0.078361524029368301 -0.41202507866326243 -0.23443608879834257 -0.34282820050757407 0.13587177552035568 0.52410110085240913 -0.40857284788666498 -0.32905476564291136 0.0065775603995023527 -0.026636168245808917 0.042308438708322273 0.33949707050910904 -0.44636009593533299 0.21653314627883141 -0.20703667040799884 0.11366256083320257 0.20604152729493019 0.24900100362000435 0.066030437362060102 -0.44951200607293251 -0.50808124513881314 0.059163871104521704 -0.49420949484381443 -0.064551169553525828 -0.13639524249488919 -0.17718765843732079 0.34129902870090667 -0.0089532090793303151;-0.21116986295859405 0.471746582950197 0.068180527845610822 0.020610226126845137 0.44355954010418502 0.22495865429293921 0.32917710218665952 0.13965985930781599 0.35500442722934283 0.4384310305598294 0.014820717305811686 0.39831017736629443 0.30775335969650536 -0.11405496374404488 0.21301981464517084 -0.017376576172420697 -0.35159403464584821 0.2282872694791358 0.29602068651542468 0.1182987947123903 -0.4727888988972771 0.36229251566314169 -0.13678415849736655 -0.20583826330701618 -0.41163584521883523 0.23468214869732762 -0.45805704338615605 -0.2260765737818701 0.45329653412057075 0.30328263529894345 0.12386238314035314;-0.14444454477108196 -0.10346382356863508 0.51247995589277129 -0.33705797052251246 -0.3205722612361348 -0.3544811493852324 0.29716572097018823 0.10723347846482012 -0.25742017971323944 0.089596287458409557 -0.35316314645690883 0.18104238397428221 -0.34044797785204672 -0.57832710267664122 0.10079969207076922 0.066013150934042947 -0.17645045904912118 0.25797309128045165 -0.25084524199640101 -0.43429800540868413 0.23221426134412873 -0.029685276416812498 0.34038283395573132 -0.41362993844935897 -0.17413304849133299 -0.047817412116768217 0.35305157899497908 -0.42900589669892825 -0.22890716414149628 -0.028303470376914622 0.11631076904780893;0.24156151786047625 -0.15040886171814169 0.29410305065974957 -0.02623083711981735 -0.19547590337153853 0.43705887879968058 -0.3153686225899025 0.076645726422717678 0.30421856860296342 -0.52647730177352492 0.32843474194505956 0.22938231683350549 0.031876523122251997 -0.56133666620220246 0.026110909187759917 0.13715674670855921 0.39385803045531176 0.42600213122873354 0.040753627684508902 -0.067074053500628714 0.38989957369860706 0.16833313643458481 -0.15448798595026147 0.26491346299381152 0.27547819377710625 -0.057786784476633525 0.33997876222879564 0.43728697407748157 0.24139511075807904 0.61299054367272032 -0.52100041482949255;0.33499962498832786 0.24110625373063083 -0.42070606521641291 -0.61880637273689354 0.3223814186671754 0.37086489589306332 -0.53225793521835463 0.3972985952562495 -0.21241028051004551 0.056396653202252137 -0.077439883106190266 0.26307862666454407 0.43369260899173545 -0.12063486153469562 -0.18642528030294697 0.30029948643300436 0.22355459283337648 0.35674062336589629 -0.17521515812299429 -0.020123345851980178 -0.046355021815789883 -0.31994687591012122 0.45623332935565164 0.093691577076506993 0.15961100147319085 -0.44952420976315716 0.08674687762959539 0.20411820843547762 0.19883611159917064 -0.21601010099909992 -0.41710843416756166;0.43555267280337917 -0.56573027842631229 -0.16707477760124212 0.44208919495956878 -0.46457936747079354 -0.32933102164650319 -0.17706581520027237 -0.37620167432437218 -0.2918818121968903 -0.52168502079308798 -0.50504129875669923 0.30859782886470677 0.21192100021499027 0.27540448060725281 -0.3533599108718396 0.45100809785804635 -0.022222683299145996 0.092816768459833762 0.1371735300849955 -0.32582915339784868 0.25664013403353414 0.082743446460138384 0.13455413031275446 -0.44150355838336963 0.38940813364609811 -0.21038184698527437 0.30700793357261164 0.41296535866798945 -0.089319790174342467 0.16699294818614993 0.3044706843186149;0.37802435869413148 -0.20365319137266236 0.26364875318782927 -0.51309878732302527 0.20760610815607244 -0.23413395986300597 -0.19573355814704477 0.34731420227947335 0.32513441089967604 0.10453174710055244 0.21951753118802703 -0.2328222822147954 -0.18321247620214318 -0.44057160898296749 -0.056038879126199523 0.41883213895949811 -0.5173814791864485 -0.27512329321874529 -0.15700405745360771 0.029742721718443332 0.52546012749381843 0.24496930780106263 0.1000078735846593 0.33590874078071253 -0.30142869874586092 0.35383041264682608 -0.27360247459444287 -0.23915727466142134 0.34953349788362836 -0.17912624908005342 -0.36914045348665547;0.25843241447772763 -0.0244388037899484 0.44094811199412004 0.20260187955259296 0.10169101486887265 0.28715322110996006 0.085553532595268031 0.45720471805074764 -0.47759481463584846 -0.32526713066033147 0.32224632373064438 -0.22617499702611765 0.052800125510310679 -0.018472367563857707 0.12518421725086148 0.055239218400730518 0.049281019699631182 -0.21701453292860698 -0.47964255192856065 0.67538989219395618 0.16482017972788648 0.024232396563794577 0.12867185794920194 0.23321159422906346 -0.06833468951604478 0.48848665991374129 0.44870597341097335 0.27088377852817352 -0.36626690867629363 0.44258248395926048 -0.29562749858585224;-0.34875963654975711 -0.58303153588331136 -0.44017247533367349 -0.24068923903406078 -0.39699713797264741 0.040053488048526702 -0.27535171952258691 -0.3729871315418487 0.73390830526455708 -0.20408406111855321 -0.083627734853690572 0.060625367042224446 -0.1745213374449501 0.0061542677163247102 0.07693341602726525 -0.11863287636398541 0.094336441018564948 -0.34371627079840666 0.081887733716336494 -0.45559524232654225 0.034130041315254496 -0.30133839501802751 -0.10271308094508086 0.49030915643217288 0.42974692426346822 0.11548319370225112 0.34722565608301753 0.17743100871841022 -0.050384993389178005 0.14259832912397208 -0.23766807098875969;-0.19929666825419942 -0.21837637198070564 0.24941024910515541 -0.44712951649737526 0.20451220981060705 0.4273787342273862 0.43557629024513728 -0.18366742262324801 -0.47632106630809157 -0.41044943534765382 -0.43947164153835344 0.0099468734775556029 -0.43038280756175529 0.44185416063627359 0.24049492025455213 -0.13396813843047115 0.51473288203876078 0.51916646613936523 -0.08770018865404737 -0.26682055236510477 0.50506934334426956 0.15069670235195157 -0.47614968926545459 0.26123608658144176 0.2654780071806313 0.2207292070822911 -0.032642485136793381 -0.41961547698061846 0.25631555466730777 0.0215340727079462 -0.21915267305725333;-0.025940967235358617 -0.22210190340521049 -0.34737849909461938 0.048217949791618808 -0.44054892860493972 0.17994522796750001 -0.48152934715100271 -0.54955186795869548 0.36079184386442581 0.24573583063174734 0.00055564336478874346 0.366463024064342 -0.0032356428361829596 0.069855324810378955 0.23666046372252325 -0.5020839248059108 -0.16680614638876201 0.16055181275219799 0.41758429451496648 -0.29504756359986012 0.073655187530074884 -0.4239266341438534 0.55701217393593494 -0.042476594336141586 -0.49086011255011441 -0.34147295597314681 0.22172890213762805 -0.19777181080359138 -0.03569201893926021 0.075850975633445339 0.36627892929779249;-0.0522770486882847 -0.70880460753302554 0.27127158064715584 0.37823343064526971 0.070929408943911906 0.16805819220953128 -0.62915474503291946 0.066154528033461169 -0.41251713303039622 0.38063988137709664 -0.059532925618642825 0.57172193053972442 0.61651687454999782 0.16285108696687284 -0.48415783006910046 0.0077231001819277265 0.1773431221331562 0.10817086043445362 0.65076468546839472 0.074105709155553964 -0.75552085661437451 -0.45965470052252821 -0.10801745080300923 -0.30223322385467299 0.63418193343639651 0.45346540443830624 0.056599833647601606 0.16030621399957401 0.29678166111851922 -0.27915328160816261 -0.29373202087957528;0.43452449159924261 -0.16848339088408937 -0.13286372940008195 0.22800435003335315 0.053352683678897672 -0.34285125408889416 -0.46309504051291128 0.031191883802578872 0.010194255827521249 -0.032515068815670442 -0.48166711164385623 -0.47752546434974358 0.33013240234784752 0.27143067978275631 0.27851544511795673 -0.32240185519590897 0.32286767439696556 -0.054041295412029303 0.096638546307722104 -0.0099728114840217132 0.19397669098858328 -0.1306520770591402 -0.30830686999715584 0.46247786977755595 -0.23743460048119813 0.47704823447442085 -0.16640945370012619 0.12389017833911861 0.077287031851922761 0.41282695061219199 -0.48969285287568293;-0.062443127424421034 0.11199801953560939 -0.28729927087697854 0.074217458589258559 -0.052970855454899712 0.43403109621719432 -0.4599065256103399 -0.26984257178232457 -0.052701777217949414 -0.33082606075093884 0.013104593326097902 0.26775774208989483 0.47294296224907995 -0.02399724441495725 0.41864880818454581 -0.33954840562833671 0.56537509920979112 -0.22204876577235144 -0.24368853808449201 -0.11194126319674563 -0.067918432506274981 0.19840508304833274 0.30586741602507861 -0.19587561447016411 -0.36589711624890858 -0.18091453445583411 0.38148366798658234 0.50412423088178249 0.15446494919485196 0.28654832412831838 0.33109756128629625;0.093633658636260081 -0.25513037667219779 -0.09798868669997568 0.40493829903254264 -0.36416409346402662 -0.64563408461111904 -0.59723820508564307 -0.25998481431512149 0.15316541901591207 -0.23930581571006063 -0.21383815465945435 -0.11010723923905327 -0.0043084672969153203 -0.4531906117212281 0.49924901629580742 0.20146723407508452 -0.56633516470658718 0.033943434991449875 0.34103577653881773 0.58922053288039722 0.1178037430632479 -0.47088986279969702 -0.38928200385059186 -0.43326314121704879 0.36850604804074139 -0.36494351029285338 0.061641293474333905 0.3317737796062345 0.051675103669873566 -0.078600139881999584 -0.27180313662093014;-0.3684626861878097 -0.025382288223714376 -0.51492760036033458 -0.47366184926107396 -0.34813884805016859 0.41130685159814523 0.4826037740575283 -0.41942055251158822 0.18456471830722551 -0.037942332622379296 0.035652237699224619 -0.25891519959652415 -0.33608263575708075 -0.26600310438725872 0.038942694167253343 0.33869082076187867 0.29449357025772255 -0.15949106952432476 0.33466427909816354 -0.17537506451499155 0.50736565074874307 0.33482931184245068 -0.020503955524692922 0.12992526134084678 0.31245262696090631 -0.41215376623769473 -0.29829891192458885 0.2251237214838053 -0.15617906231891604 -0.37351720862392329 0.0099259003514107214;-0.33081510450030427 -0.29196601789520221 0.13552995609400106 -0.42799743080413133 -0.36098795122707489 -0.35124142016305016 0.24714831061229028 0.40264978613531277 0.13920225251555784 -0.36477991764002254 -0.057902792642485809 0.30420069585241777 -0.27810382102110159 -0.30446109340447119 -0.30171199913380919 -0.20313821457098399 0.097397244744775888 -0.34841120624348326 0.37548304855096465 -0.14635323231890143 0.44996297388651785 0.27230610306722891 -0.21858251154064215 -0.09113635694275618 -0.4912340288503742 -0.037455209833273766 0.39483760814126656 -0.40094546167006984 -0.070512090400078595 0.39265881646819212 0.070129211958768894;0.20122932707003671 -0.27578720469252416 0.34643414904748743 0.20448075080708272 0.083689250160771902 0.20864340210876789 0.4432309505486226 0.2755254236763211 0.3405061817721704 -0.27835331562358706 -0.078871386707190419 0.12683318728773371 0.48619394717672454 0.29812913144167474 -0.45907039043612674 -0.42960629366565112 -0.23293021742127951 -0.41733768135673144 0.20723412117412729 -0.31125346075775379 -0.033874491769359021 0.042222501344607581 0.37626006418831914 -0.26205022491994434 -0.34672670383493676 -0.1603364554418239 -0.36136116565452925 0.36156464109716308 -0.30794630459522648 -0.002105087374431137 0.1982146406887845;-0.16045680702423953 0.47119471423476667 0.076965312496883945 -0.26943908208837924 0.0070982289120849248 -0.39212056474692158 0.24461318977397714 0.072509184123242101 -0.2186103841634863 0.23480661149885945 0.3887902044897163 -0.34351243806128789 0.27191729413671922 -0.23834593458736872 -0.26408582448632284 -0.20529720704135349 0.19957689047632912 0.29416130345227975 0.35667810364341546 0.57899598664876817 0.26699026403112991 -0.33252874761855555 -0.57629053218987336 0.17866291260483633 -0.0038046826091571269 0.13079054848767013 0.2016344164856036 -0.44323354444144669 0.30547792579681898 0.077640614870405592 0.36333748746204719;-0.48257150436096996 -0.44725632468257492 -0.46726431698609627 -0.12682739105957389 -0.080182926903801299 0.27399663801573715 -0.50117123100403604 -0.61041246772330171 -0.56137861116392929 -0.16103744874857012 -0.16494516241260146 -0.14117362396794886 -0.16923272121411387 0.012764296569960622 0.23434374170184041 0.47052673029106223 0.33099712722137364 0.10950421741888505 0.28520126594193773 0.37077907054373532 -0.62885140556896968 0.29610155306828767 -0.23970809962668557 -0.13118100054299855 0.38746845703565563 0.16415975362608617 -0.1640084943371527 -0.13460676273339961 -0.17163676886428048 0.017650369102337363 0.18323080107679057;-0.35695305344155265 0.3387018763594456 0.33877071950929838 0.29549996198139228 0.4610294947151099 0.41566126851280838 -0.023280475378927124 0.1328218982843492 -0.14924014308477773 0.076857468102083618 0.074766485139490024 -0.11297299440787875 -0.37896693959282196 0.30164512977239044 -0.017296807144725968 0.27341371463043351 -0.24301242566543221 -0.3855151803302273 -0.071286112736922286 0.22508229593452225 0.090019796752266498 -0.21784613041214293 -0.13304533469889107 -0.28472585504925618 0.535872237856441 0.017236950935579295 0.25704665697298229 0.40841317503127167 -0.36736870463335214 0.47552983499877061 -0.54336611851498595;0.51097484200267729 0.091594019838723173 0.14728371552431332 0.47881968243639167 0.32532850771171462 0.041403054547497806 0.30808850967403412 -0.37931713081237939 -0.036470182942603589 -0.62895631024135557 -0.15566531245321008 0.2707697782851029 0.3931155704418885 -0.34251173634010867 0.32609074588504322 -0.11185546948067193 -0.025827394195863346 -0.015290381062401898 0.6015209874597558 0.29187187139616849 -0.20218608430376309 -0.54157110801647812 -0.35392266868413763 0.24713140766704389 -0.25511019990696809 0.50466742213058924 -0.24453618459064683 -0.020052468230266456 0.38272855253487287 -0.21502662827869123 -0.06033755170068747;-0.18143659228979689 0.31934719800548228 0.29234699794301527 -0.12994044188844012 -0.3832742224687366 -0.27344665884246283 0.20505491887210292 -0.43376609752681572 -0.40798319695634483 -0.40996818963838838 0.11891547973910062 -0.40444401045763057 0.087028900593615649 -0.39919720554486798 -0.26159893540223478 0.47127511170142966 -0.46997901537947789 -0.28597001760088003 -0.43244631696786517 -0.40686223424723494 0.32317476285540381 -0.11944229509423111 -0.097645551005850553 -0.47362804499670313 0.18158909641163873 -0.081525677188568721 0.077004414050246175 -0.027450023856427544 0.093908349243613451 -0.034289391862418389 -0.068086713499049004;-0.3157680295938059 -0.15739665917521903 -0.49543441384870157 -0.42363390964325526 0.012859138857667655 -0.39467462602909803 -0.47309519020799906 0.094491973235390075 0.1575486496213705 -0.097050214136439078 -0.26777789508416694 -0.23559403952426858 0.1792947218893583 -0.12842839225630387 -0.30012634081173434 -0.16805191582251319 -0.028444977628295006 -0.38197669578687193 -0.41464412780504462 -0.236312625582208 0.53750446188363898 -0.082669520995618861 -0.28199896106237315 -0.39565720314840808 0.38402839231398855 0.24492906701865913 0.40970748186711464 -0.25887557850095516 -0.36364795273696832 -0.19949084335796152 0.22580666890191717;0.36066870345371049 0.092352898130562716 -0.19810999343993826 -0.34080297582434316 -0.27086349194567866 -0.32924327856784108 0.54686971574220655 0.1223615910889337 0.3746483117305357 0.11748238493030612 0.37394846628927153 0.28212299582429012 -0.1381278496014873 0.12614291771241928 0.4004228410189406 -0.011484212254776095 -0.13017183258491763 -0.16234036072016197 0.015312012633450903 -0.34815587427952865 0.32659504784296417 0.074506565609467557 0.087499783997163336 -0.35837610861194213 -0.33628872652696462 0.23370795495103333 -0.037411855784568945 0.32641800645135083 -0.041004460531715393 -0.49395783195726334 -0.39121371434915608;-0.3611278576235486 -0.38816394833852064 -0.27730951626811134 -0.02073080983039257 0.4281766724216195 -0.20377737687609015 -0.29177864957424426 -0.088601633564097781 -0.23298898087485223 -0.34068362378916162 0.37572958277800672 -0.39038005518652263 0.41623897895467038 0.0027037982299014697 -0.10561403832025311 0.010314479177912931 0.21723776984104368 -0.36358660092888956 -0.2369649338133169 0.50870371687517069 -0.39985384718571954 0.11166155964905944 -0.16827950830250757 0.39223764281061879 0.2448700434371682 -0.35102341561582268 -0.23555721818173531 0.061505123100603069 -0.30111352570747485 0.33926507827235186 0.036502302513500735;-0.38106426315755104 -0.049831853824365772 -0.22321269945368616 -0.52052223159984401 -0.086838149642366996 -0.52092102340355895 0.10478629508343376 0.052261320742934214 -0.2030682756515968 0.051779074899554932 -0.51552222043567075 0.38154894286456664 -0.44913113636517571 -0.13946305327127292 0.43663010265790608 -0.35900179185579661 0.075745725335497463 0.31762979990911266 -0.065251024141768948 -0.056888319872908363 0.20515405025299097 -0.48300799695311813 0.072202911760518379 -0.088156043363812553 0.020231700990840974 -0.44442469299255732 -0.53846846931362802 -0.21928375765274477 -0.1909083149388642 0.11001071445032083 0.28726077518397625;-0.20947488472181996 0.44017989074529057 0.37768996951219375 -0.36208079199358917 -0.099191194834736332 -0.12023753727315292 -0.17516094968422172 0.20273879776636344 0.41960004439063836 -0.13484359078924704 0.050344507802079802 0.13618491908783123 0.032300451245849598 0.28527837174034676 -0.32831647181963464 -0.16859231093485999 0.41667341579747669 -0.05150981707994827 -0.12580271777009294 -0.27362445474122554 0.48141645418088752 0.20763564842856008 -0.16846253356449978 0.20802767143062267 0.46366848430838781 -0.097339650752310436 -0.27333646037197806 -0.55900127016310508 0.18645358277787441 0.4002702388537574 -0.33330752156531818;0.3881698481255208 0.4251004539931193 0.038436164639966096 0.026884740844850621 0.060757385722558274 0.4092102326408148 -0.60020224495979935 0.067346103069279753 -0.51386042103722995 0.06232785322092 -0.26434279318993831 0.27369021549803701 -0.11846338141069956 0.34684304758963458 0.33553354130879526 0.28632249497197421 0.091972898893812147 0.18631384053109185 0.43517624329544474 -0.058945979362405101 -0.55847957636877044 -0.037099758073075063 -0.17590191398420768 0.0029403760380205318 0.40614483927233969 -0.30779756820376408 -0.39323939652722445 0.0652327663936101 0.035216629653962529 0.32751587311133956 -0.42387588157031425;0.46572330830489944 0.17279657156085576 -0.24207504685365791 -0.047477358094147111 -0.33989073756720078 -0.10896177187801244 0.35458124325667478 -0.10575644437168857 -0.34135024064185754 -0.016232238377812652 -0.090041894344588841 0.32534717626083109 0.044457608640504187 0.36640193102907004 0.1552229791642428 0.067679538571990702 -0.50300173053255648 -0.38250398176891187 0.25807079506447839 0.18056396233628219 -0.52525956892937797 -0.36100833108214814 0.36756085272484307 -0.19195701049320707 -0.32610640459128476 0.13427360153360626 0.2171832247843106 -0.10579198123347215 -0.46445819242469816 0.32872676212477958 -0.21173672029077353;0.096676758434109264 -0.45534396740888988 0.20281940101066726 0.12852806237144701 -0.43284009022292919 -0.45221411544263229 -0.12905206159348931 0.37191909052411148 -0.46620547993989903 -0.07818220269088616 -0.28159734354103494 0.19062555629256783 -0.064846182404295738 -0.052787975931572591 -0.37549958107263615 0.34901793505747186 -0.26131503577527032 -0.17683929487913838 0.19524560244998379 0.15326253113761817 -0.34779425296139826 -0.34505924998917664 0.44554323628580456 0.40969815972071438 -0.35810008381090536 -0.1446671748289515 -0.36688808777644044 0.26193258907072736 -0.26276299303820305 -0.1272630274096061 -0.36816810150424767;-0.056376073984294117 -0.19166024724673464 -0.32717796277606881 0.20057949938824221 -0.39100605629923085 -0.2650142989509357 -0.087870964941427793 -0.17823132019458462 0.38256626605397137 0.30768175999064867 -0.50359480991444805 -0.49290036651373098 -0.32462512202643373 0.36380928954254593 -0.57533390122700856 0.21642075876561043 -0.37252289904512237 -0.050917166790305446 0.25807323135537286 0.0012564549849180782 -0.089700022034556876 -0.2133045297375957 0.35695623175149499 -0.45858971792028852 0.26167700684292783 0.035267018442983571 0.35074855709207109 -0.21024831435216462 -0.50797792217015891 0.094168318685990765 0.06042179595434774;0.26777200561471232 -0.51985846031302463 -0.051827090343935595 -0.29320834403741552 0.38557420218809385 -0.2084601121361446 -0.15445024480921987 0.34239123066322941 0.38148744186228661 0.013490363264355263 0.25408384661562822 0.23041993190374754 0.075074111016872877 0.099777257522433632 -0.37506348232981312 -0.37386209396610565 0.28608853092986136 -0.10276657940221051 0.30633133810493618 0.014026142260002653 -0.1359754130654256 -0.36927507521632441 0.3192922535112242 -0.5349111480719948 0.07759743432181343 0.22772336075429869 0.30107022572319275 0.35101125865053168 -0.19849955351611356 -0.4647959090300961 -0.38161089744177995;0.14376009812097368 -0.25600765287493071 0.46994733588879545 -0.5175252651238047 0.23862699560947878 -0.36221188852829667 -0.039888133101441077 -0.33131495106226938 0.08772629901298748 -0.26378094582750428 -0.14931098396190229 0.21221699532789548 -0.54330828017532751 -0.21722505062206934 -0.49780475087610715 0.31462302228298872 0.01832633462928793 -0.15516447961525495 0.056668026281735444 0.033421853289729846 0.34418929304566498 0.10785019443774813 0.18454658861477122 0.42265969680744053 -0.038206314032120485 -0.56366647575890994 0.33775949571199015 0.37851063410951358 0.26035454454901041 0.22358504152191089 0.21136285489710571;0.44605121845707824 0.45582911251649522 -0.23907432352269456 0.23337827381577911 0.20649498397158303 -0.53811401053335883 -0.058486337551849156 -0.020005680202648052 -0.10058005814036508 0.0049565245162357038 0.47957216858718832 -0.36084557550608132 0.61228923239987765 0.21996280203473234 -0.057414848329002559 0.27962763671158641 0.065562346862751475 -0.17709544409682754 -0.16467836322952192 -0.055108686536577342 0.16096367599516001 -0.1552865104917589 -0.51038655849602388 0.093882493111223 -0.023749055083185758 -0.37678296074655837 -0.28187907257826783 -0.020692579435986624 -0.032188048255231312 -0.36852947264230618 0.50453477298963278;0.022100294188353277 -0.23591396773755524 0.43307029440103523 0.079614450436498896 0.045053048988682336 0.23553059342493413 0.23793687633491609 0.490493898567046 -0.0063328596785276236 -0.065688530717548488 -0.68733127593461629 0.65357591272089388 0.057197103911471113 0.52971933188120135 -0.30944730829657907 -0.39817760773034661 -0.63803187949190576 -0.062714098628901191 0.18537120017845932 0.13688527939121947 -0.39449299802652638 -0.17299435231859364 0.44902761435308691 -0.29784093000790079 -0.54041763984385893 -0.14062363182377308 -0.28411589739105714 -0.0065426373593187861 0.5305209529462237 0.27446343942516388 0.24236438975572225;-0.44586777945010231 -0.46816168714450895 0.1768487215387361 0.097634306684156971 0.089834101620939896 -0.086388785588382921 -0.046958142381941848 -0.35112662178700499 -0.3340756989446772 -0.30299329901966326 -0.41222386079360596 -0.22757762164429748 0.42517364660208401 0.63001684927916679 -0.16200368249081362 0.020057241960843658 0.16048488759094995 0.22419152743074294 -0.0079500829268294854 0.45920537768272385 -0.43742861354343354 0.26182565470455937 -0.3604754787602818 0.40830298552595706 0.1714093494315661 0.20237322048787704 0.3331082907698355 -0.18670304140081279 -0.13467210623747561 0.22709377037870082 0.13154665899440485;-0.2089512224968475 -0.096347576037846189 0.38650895864998092 -0.18598149770166122 0.36176315919223656 0.39264209079450602 -0.063274171097447582 -0.23753423783062708 0.020238111082581875 0.036103504345216697 -0.31699815309021545 -0.21673987514468279 -0.40662027933209127 0.010894650687531152 0.38137860780048621 0.034635845655258776 0.11677020197295619 0.47550016889334557 -0.010314011986439761 0.20490213823322484 0.14976177010009353 0.5316314333981812 -0.61356467922483193 0.42016483538290283 -0.0083347921715656165 0.33197570573167734 -0.17430603590146079 0.28743060435950218 -0.13687382106225041 0.21398992429605385 0.1870766243777949;0.046782076408198689 -0.33444841146193122 -0.26389262011109799 -0.49706612240305109 0.05299058665792334 0.35268033956894507 0.31639989396064128 -0.056284342919081597 0.10984532081533536 0.046533512788856798 0.062767915366709767 -0.47505018708378277 0.0030664731069754308 0.40516936233199968 -0.3315023758268959 -0.1667872671797207 -0.22443896261291216 -0.30635517436001442 -0.4270117708484315 0.19605165759351703 -0.43095061169394855 -0.048885470299034881 0.37770871752292984 0.25675866643868589 -0.28911641558155632 -0.36287716410577464 -0.2116939998872121 -0.50961624289560692 0.29351123563608555 -0.23733854883110536 -0.37687704420802531;0.38202410183102448 -0.0016795176821009514 0.26620786979420397 0.17356902318465345 -0.21473954443317159 -0.36668705246380645 0.31327789420806856 -0.40508168107088527 -0.11550940748740368 0.14164121856735506 -0.41692251945820791 0.010785773419382428 -0.17443138467096508 -0.42656598865842377 0.093402398699047429 -0.40876193610745737 -0.11475776336853986 0.19598282376285356 -0.053773033176153777 0.38747717370520179 -0.29599025295737791 -0.50042744086232094 0.11534318853277925 0.47832386866268195 -0.041180252059510203 -0.44505280195877744 -0.22212646012148005 -0.011147015182916518 -0.44282370862093923 0.22456580875777934 0.44793891904279648;-0.12980207016882223 -0.58521503646378759 0.35646338281098505 0.59924891788662615 -0.59014412657462822 0.096486486687254139 0.21348746950192349 -0.15131955407984823 0.46627931205436141 0.06714117979239409 -0.45902186203873496 -0.55726294295768575 0.19167485613384289 0.29478237926937634 0.0072801425604701892 -0.33308750078244509 -0.017887097907586916 -0.2525081177683286 0.02001918330175028 -0.36532768810124749 0.047294497942098779 0.39621681476900639 -0.18348668760696704 0.44594113595974022 -0.20060266390868506 0.41669099741465249 0.17871241676206137 0.41064273030118525 -0.045244581567272138 -0.135003150900708 0.030611564692051445;0.09247658957689224 0.36635114422584059 0.19875909546083026 0.207253729167754 0.35426082068097176 -0.094446393319849165 0.40498551394926885 0.32671658449290403 -0.35788775761860414 0.33330353159499293 0.29546264939587608 0.21117134927044068 -0.30818033712404719 0.33132414072347016 -0.40196524190835586 -0.24898419469654198 -0.56453224455280671 -0.13981795519348017 -0.014165224301610022 -0.15727775053103493 -0.18903984383520184 0.43707220058282753 -0.072505560385652632 -0.32856094083811627 0.17282023988686421 -0.13423586938972035 -0.37778060846563633 0.16581616069963495 0.32827689181937159 0.11827469886910467 0.27921520338380101;0.27037765540077552 0.44993675692583834 -0.45993531364333173 0.1315712692027029 -0.29505468370255339 0.087076059914146353 0.244839198352656 -0.24147327508826846 -0.36711729716355129 -0.37619532502900443 -0.2361804092075413 0.33142762184845126 0.32890168632444483 0.34220973512389991 0.34561280836484359 0.36112508371831781 0.36067868218563381 0.37092967201683824 0.2009230057191084 -0.050981876403418364 0.10751460098505131 0.2964829519919901 -0.17759582861266354 0.4329075513123023 0.083797263109407744 0.33361600627804944 0.14370492681388528 -0.28880225217180283 -0.14313842949050845 0.050948675811560214 0.25388749264165855;-0.54058005273850773 0.085846478127456965 0.011129550259447965 0.49652249514104596 0.26197142708178484 -0.085414229849595624 -0.27559753604672188 0.21089236080033305 0.0084215942287027452 0.32469312550656376 0.53303845067517142 -0.059336472409146961 -0.053194154640343758 0.15708097502912319 0.32200670328421588 0.22141667306790225 -0.52306478088022179 0.10496407965174638 -0.12755629018509457 0.27725113407937951 0.49291871407168264 0.068650968960067338 0.16143037321041531 -0.25252792227630322 0.3348517976723045 0.28801377551649499 0.45034020981075129 -0.45647338863099801 -0.20572189573711988 -0.29468478331770215 -0.080791506929709211;0.26609606613693393 0.39421966721517626 -0.29896436875663956 0.12501663706774052 -0.29249634043914557 -0.41206513042784126 0.056633224346841704 0.10111752225971146 -0.32270243923894204 -0.096435734073551244 -0.40605668598095529 -0.32707464655037843 0.1386010193717736 -0.49188928025575496 -0.14068321656724214 0.083300431885760168 0.14241594322400239 0.35795206250871103 -0.17254719776819338 0.20841440146959447 -0.5174268566910365 0.21311750460858306 0.45828522709054387 0.24293884371133673 0.39539486626179293 0.12083446630321798 -0.19624544902720018 0.48469869180655301 0.01843993581567753 -0.31272476258187026 -0.26752977056742738;-0.49636679216891039 -0.14296827240523449 0.0056335283956338231 -0.49760470253502226 0.39488706401488483 -0.12117057861460344 0.37848515593297644 0.46809175565647654 -0.26735075609703751 0.36334815409217136 0.52122437931568955 -0.22207629601964254 0.18138040429320917 0.097020880620693487 -0.074889729922003934 -0.18750397733534213 0.44202759901138805 -0.44701834619868841 0.19955149796242438 0.035618185614179662 0.18603169673696129 0.3240424689321969 0.17544307888417526 -0.23975448258464127 0.26554019226702952 0.043696618116054985 -0.22914883904867434 0.51533438004750065 0.20360507695651786 0.10939404773257418 -0.033850459791684502;0.36527088653650369 -0.24359971043107218 -0.43171246714081818 0.2647557386615777 0.2853438410187083 0.30568907415635654 0.40020968826634779 0.43357852653115875 -0.11915642925518743 -0.091938987195001473 -0.37339483221616288 -0.37800095072760587 -0.34898631437976702 0.038888664164371013 0.033230691086469699 -0.095149728317430432 -0.2592558252437076 0.05497740269642664 -0.13349697944516203 -0.34374547666136634 0.44786680025689563 0.41442561240238096 0.40307493510257064 -0.20029629763797174 -0.10940434790679229 -0.11141444372818786 0.13959811674079453 -0.40955511840301717 0.1128910497244579 0.43966251267535111 -0.40448438084767074;0.34329143423813879 0.010342875284195207 0.292000115097863 -0.33672185698269463 -0.501658320087639 -0.4431023421504961 -0.54900015059710716 0.21454413447976309 -0.085787654510280018 0.16368230697252484 0.30675328491192749 -0.49301212143455042 0.2217585536555306 0.12993557613259937 0.027482068576512045 0.033186943939315913 0.10187362194823793 0.013646067478823302 0.094669372284551828 0.21500721914841261 -0.38648956957020397 -0.052191751016693246 0.59950843002334886 -0.22960208105135552 0.071738512877949606 -0.30154161978141147 0.57060683809703205 -0.28113337591548065 -0.0056269223727044917 -0.22095394419469327 -0.098734691877963118;0.17322039578025855 0.3204263340697236 0.37884394602378157 0.45234248208754418 0.27614467986148622 -0.28746242448264642 0.012570413003474896 -0.095030732856716232 0.34132072915631545 -0.16880401825513791 -0.28622363457517003 0.05885166637773033 -0.1999321862523219 0.02535693402497385 -0.15262415880194344 0.69139607759675437 0.60204832797885899 -0.17304218944699179 0.027091177506165985 0.15261592081960396 -0.12524864717184733 -0.17352566696372909 0.52110764082537442 0.1181822187003643 0.70653498583167063 0.25780189199866499 -0.11554025283544993 0.2693340837957906 -0.090027085655785308 0.3321819468617484 -0.34211251659343217;-0.37381336968214274 -0.53293738248536837 -0.067602928276739999 -0.29843993559970144 0.29810959837946405 -0.44158768722146896 0.22376852055072532 -0.40331117520251075 -0.37963508601880508 0.13084786974024668 0.057520474347029733 0.17915280472488168 0.3130784027354962 -0.40326531522472175 -0.10972303547854483 -0.34307065388240343 0.26059261029296255 -0.13031246219635242 0.42531336641230416 0.19362606790460007 0.29117401033004797 0.39787719607170691 0.28722857299272941 0.015590110378497713 -0.24253569990986495 0.27303080249681244 -0.11891246329038266 -0.32869927691741574 0.082434143319346384 -0.32446933299282654 -0.23375098747737749;-0.46507108367485783 0.082433286305651776 -0.0019818072233045714 0.26997236149104764 0.49248658316159222 0.30596378081348058 -0.278058835607712 0.50393202070861365 -0.09208288071120839 0.22198417332511267 -0.0086687243408816953 -0.45134617954006956 0.33142968813382395 0.0060047597364242629 -0.55833747283376922 -0.11929868558055096 0.024480057809674709 0.14011280887365082 0.017971924164218771 -0.26994265333098555 -0.2774888979271008 0.45770562426532274 -0.54293582115835437 -0.054025532620990198 0.13001699836111025 -0.24547226199785777 0.35422375508434373 -0.27181087089004208 0.076008259443245782 -0.27334553972955866 0.20820105755077251;0.42926571177981004 0.41659265592450712 -0.21006603441091881 0.19954384896359445 0.51744150334155559 -0.027796442969296797 -0.38658975335490359 0.58568674341769922 0.40973479512665018 -0.23548365781750505 0.098886962277141263 0.079976690696958383 -0.28909110227981094 -0.13333064180990362 -0.020299026083769666 0.10412295107341062 0.29009392536428719 0.24769291327481546 -0.30549411266276399 -0.15428392550351136 0.69064459238433229 -0.0087071634290351342 0.22728291057408168 0.14209857013695298 -0.14018627864655861 0.3622156461496735 0.10527072356518535 -0.68034481874058772 0.37603042711689122 0.18470461458668319 -0.26847492561851999;-0.085535268075926166 0.47398763675272021 0.20485619233904112 -0.099181056315785013 -0.11953961317576957 -0.12032188773275956 -0.050165987906292467 0.25590476196484568 -0.40371713386730967 -0.072380881197105215 -0.22333844788678434 0.41091361117040481 0.29430108664956067 -0.43575074746709203 -0.30861984814670018 -0.2037793647471598 0.44986066001845287 0.11401194416481136 0.30653126362555416 0.44791198869713117 -0.29358814628962948 0.37868856283539543 0.091130982460203791 -0.024086350138356756 -0.3157890952245811 0.41315978092228139 0.44786615489572323 -0.08731889186421736 -0.23383428047359234 0.050990023920309352 -0.28150593281737823;-0.22288634027582729 0.22597316065710388 0.19414690095132281 -0.15943098150172724 -0.42293287383218781 -0.30054224099751731 0.049432082062173914 0.3281523198812063 0.31326916781283148 0.27423356120788894 -0.0074300781226781963 -0.17643523317099449 0.48350485537449939 0.21388044087260907 0.25175659848794119 0.41518095033306085 0.32401020023234034 -0.23600130712938167 -0.49191076131593281 -0.31371535954624269 0.43484805966278411 -0.15080942656582269 0.33575398782955107 -0.15486512233367331 -0.44468349657437556 0.13937955091561458 -0.18266193815463011 0.014276606981173372 0.27155313244501517 -0.26709845474914612 -0.35029550616994376;-0.46198253744049766 0.060637808767536293 0.028535807237414019 -0.25962856867914114 0.1375760113048137 0.21232043127136443 0.13438829421348977 0.27221062448879585 -0.36743220161372608 0.4100974701222288 -0.39606332837525626 0.16421372776135065 -0.26198212832589995 0.15743802817902991 -0.243600198475729 0.36929071922149426 0.25366282083708264 0.3079020107747209 0.3788378289369933 -0.16752159848765552 0.32970194771032552 -0.43118758149857472 0.38025218887321494 -0.11112215459685325 -0.37073055155229123 -0.2021599616427337 0.36926654251107771 0.13630411661852909 0.45931765427532428 0.19277692076939568 0.42748323321970377;0.31238769443251002 -0.089433955187548902 0.052214809566911241 -0.058305476327808872 0.42208486719606192 -0.062561884484608685 0.4332389469861615 0.46804036411705136 -0.36980475399732249 -0.06913932029548131 0.41876460496996826 -0.029904042410857163 -0.44154036128133739 -0.51987398681256158 -0.048149543226906649 0.2378975855245104 0.31681690052464662 -0.00050569676588901554 0.39168092729793391 0.39513956702249975 -0.50009074137823417 -0.27504506513520627 0.036497790022635486 0.31809749694405437 0.025918433174452801 0.22656657112280551 0.024213542222657411 -0.40576559257272277 0.21830362117538152 0.046066758367873668 0.15097262549438864;0.073247934741938941 -0.13124104811379847 0.49018662720107287 -0.071504570633167064 0.32995295144474479 0.46996824701323842 0.27532992183095334 -0.39176413605835964 0.14311211613175548 0.31003806824103036 0.15648679547968897 0.4411252644663704 -0.1363700536590888 0.15957550604248935 -0.20217226231481006 -0.41231676387963384 -0.34671738958111792 0.29785747141271651 0.30577802366223056 -0.08523064322089445 -0.38979823537465436 0.11780483433604448 -0.13943994929605186 0.52897987812409952 -0.27756792264212604 0.47275207265818736 -0.33666948913924039 -0.10752154397670551 0.072305965018289495 -0.36790982993685012 0.2293886783618187;-0.19651266801604969 -0.33220556580232002 -0.10551094515615468 0.17507076142163427 -0.29174155293940041 -0.03066098653002057 0.27318797420382379 -0.47639919184110008 0.27944565313390113 0.3551010252395711 0.061337328124970891 -0.13578861535000247 0.11876587072678971 -0.15375679229074524 0.53765228644247098 0.3265842014554497 -0.36372258879847758 -0.47960529327325657 0.36537588756723949 0.21882851876937975 -0.043210538146217697 0.04157855492926963 -0.35199842320871944 0.19028467611145397 -0.40452741396771214 0.19902458827295619 0.24584164721603799 -0.45815373041559287 0.13762060003414059 0.43571391074358862 0.31069640381714553;-0.27022149355964609 -0.35679740151119549 0.039270219437553086 0.13847398670334685 -0.36636095108397393 -0.21104476798617797 -0.28315498389723603 0.51236024087748588 0.44028927891886688 0.10432482140220374 0.30080957494049987 -0.60186091968754563 -0.088611988296733515 -0.36556092369774656 -0.39944784951075457 -0.11849672250048707 0.61159440957513134 0.19511099184566258 -0.058245745863139492 -0.39173762010866736 0.33925497061024973 -0.1593925195057749 0.16492769389311468 -0.019116104768264659 0.29149377672573529 -0.36025090880318239 -0.18837281998061839 -0.31423019544390024 -0.57417692831212186 -0.40624926541316214 -0.064395684535545325;-0.077837048584709023 -0.24082166859119639 0.23090243983471995 -0.30621727437664703 0.17182056614651145 0.18118563426735787 -0.32486775830474685 -0.51438082284010045 0.098029120891343968 0.16621829768902857 -0.14607181055450746 0.22141414807227777 -0.081132855410769519 0.52272310295940683 0.39107256671544915 0.51444815543139122 -0.035252943731244948 -0.12525991330939196 -0.2175780243704811 0.5259253219274681 -0.42934152844930329 0.10626214248946959 0.4872313732755264 -0.21217521268643638 0.2455426548712486 0.21189019412008497 -0.058055056678567918 0.054665842614052412 0.10338962068327578 0.46924214139352305 0.4152978209424063;0.11171756501069273 -0.21502580641335334 -0.44429605392244298 0.38309084925850778 -0.23110349411124173 -0.45851452084065497 -0.43953853462043868 0.35670314954168059 0.40024907318374175 0.028582114459712791 0.10737104330073484 -0.1915086868038185 0.10697935334361477 -0.45700370480754793 -0.21521805186853007 -0.29959025445075793 0.040492749430587283 0.33331953421994737 -0.13323358136432784 0.2789589670940873 0.038360746841100968 0.062075387805064136 0.48852708975352566 -0.39423379820166676 -0.33330196782853821 0.44126596151352188 0.1078996373648211 -0.21680372526214337 -0.20567248983835776 0.23841829712153798 0.26212150071192575;0.097220188230492874 -0.32331558218186296 0.088194149303561425 -0.016220006492863048 -0.29950920245191637 -0.38558057134468815 0.39187493755057051 -0.30636678895513425 -0.42732750547336384 -0.089591317236964646 0.32491847758509468 -0.24562054286835944 -0.095986239647215615 0.23897655565481468 0.2930734361409843 0.089882990128003631 -0.24142172043281213 -0.45116561612084632 0.48474049041902761 0.2056083653454287 -0.37888492968248344 -0.30870547530040582 -0.30403295626162236 0.20730985066438168 -0.33525076453908215 0.15118606930078493 -0.10901967793987508 -0.4574579819441727 -0.11521711471071573 0.30738631228879265 -0.031177652789328315];

% Layer 2
b2 = [-0.1218874933579738;0.2434318039146004;-0.50579569540243552;-0.077406935914185987];
LW2_1 = [-0.6274351004117098 0.34315996742442095 0.13869460353864799 -0.19140523419451447 0.53346429931584516 -0.20423535112785024 0.48012154418053549 -0.81275512888485935 -0.49155176807229295 0.68033524884340213 -0.083014543395445783 -0.54776959519000956 0.63754953011882665 0.049048447511064165 -0.67878387887798974 -0.81003546728013354 -0.20923388409266508 0.32169560217345994 -0.51857592177770928 -0.26255099764483097 0.74760537051531628 -0.24065778787039582 -0.023661193923266217 -0.13185147999189289 -0.29561309530336899 -0.28279708692741584 0.54122354865882549 0.88013873188210545 0.36460009507996538 -0.76094801437708681 -0.48828220134210071 -0.038197039616575966 -0.9728619595971929 -0.62701625012248741 -0.93037919555218151 0.90314777409009928 -0.11106572001125675 0.13114744953501992 -0.12904246123651811 -0.41916229781947112 -0.095647738165249449 -0.18999772178582211 -0.17030844919494714 0.020760094272611808 -0.82639079133465521 0.33661056131468803 -0.65446862269097061 -0.043953622602098591 0.67121529056522011 0.25977307919042492 0.86832697278188986 -0.93058285205518698 -0.45441320391801543 0.34128760058581664 -0.60727156183556696 0.025850896135930869 -0.071316143737296611 0.30162506995277888 1.1040280155193731 -0.70337665043775122 -0.3292564815871642 -0.8824654057789606 -0.32416688211010158 -0.26312157888600057 -0.93522894466989448 0.062277257125171244 -0.011969814829635439 -0.14652566251770111 0.41387169973056243 0.5052108380141348 0.16295119742359088 0.10859096899168949 -0.56439495207213664 -0.032730984667246048 0.95022291206847109 -0.24321986246324448 -0.13298545769363521 -1.0790122108881623 -0.22207802826611761 0.70817072628018141 0.48182229939192078 -0.5666695188143539 -0.88687665549608474 0.75766958719523858 -0.89237948008843015 -0.51591039001525274 0.46572263474410674 -0.66815632497557287 0.65305922231923685 -0.55697668116352705 -0.0034227893084367396 -0.039675846091621184 -0.7946836045308443 -0.16706230976804123 0.47563584445465024 0.46891821076693546 -0.081179719416477836 -0.75440922168436175 0.73531916989125534 -0.30547066941200768 -0.3435786189101791 -0.1193191338453564 -0.059592359864903736 0.21907433642290472 0.22041244681731875 0.62716169220868689 0.63184411685530117 -0.43344428566283716 -0.47245907199259018 -0.23860610797830348 0.97703838472505455 -0.695545788482413 0.19639041783011654 -1.0198396847716842 -0.080795517527344762 0.14931930014325781 0.81282948710589276 -0.62045325029281484 -0.0094446313663284001 0.28745090470054041 -0.42485014611550803 -0.4851287137332535 0.58934074106612033 0.16917576551380406 0.83022371455340627 -0.23569213745637782 -0.13476099062718089 0.16167970459561271 0.432067111749038 0.70365379676791573 -0.35217445278850773 -0.45631266188865577 -0.44523991908084243 0.045717097207979909 0.096439970094434932 0.55755803906407853 0.39303989547470175 0.51477297822712564 -0.23678918168324969 -0.42965613907153744 0.25854892401017399 -0.051983777811548455 0.13384378308481726 -0.56200717082399398 -0.42527928410528137 -0.15323647330023227 -0.15647020610633508 0.40053899157453021 -0.21188080586740299 -0.71907514041362619 0.15887253922523273 -0.41077666293711013 -1.0319541666802479 -0.76173673120793151 -0.29248694895093685 -0.64180645447255791 0.39737501892077332 -0.61191767143097187 -0.00051314125062795713 -0.95753607617763192 0.96854854308388583 -0.46294373513641202 0.29293275953812092 0.67550628813910307 -0.44285071977199464 -0.7934881692175394 -0.049040324219364086 -0.38931654873217741 -0.0056935202787211092 0.65300955218992407 0.72281760834637165 0.42222303720414489 0.50777035886574728 -0.24461537590174773 -0.50579161704194353 0.43014534835348495 -0.080538612859759218 -0.1848468223252909 0.98420523413134708 -0.94212935978325285 -0.78120229780160388 -0.23638375773406825 -0.88795763682146023 -0.045346143286914033 -0.74956202834020069 0.90350836042841021 0.53505464944518499 -0.72022465947233616 0.20406877425323319 -0.36743023070293257 -0.32524666700406546 0.47480650303638477 0.094275122501857808 -1.0829901718710919 -0.63184338102577253 0.097964256126572197 0.58997975952618675 0.60075498835177787 0.1671599319206937 0.77035995181299455;0.89614429001193208 -0.77528604836871684 -0.53070789691969322 -0.59028195270386075 0.63771166955471836 -0.23841685756482592 -0.0639768161912741 0.83857542759572667 0.91563324259677459 0.37190525499178956 -0.32459704549376522 0.53129545331447103 -0.30974062608395797 -0.38499692071675484 -0.76890272806222137 -0.81271329366684819 0.2783662403030443 0.64992721445667179 0.22258763872707296 0.28125279060519787 0.8995502871294534 0.31010100839074317 -0.18701921629046644 -0.8385064716474927 0.47075508308195468 -0.91728931831483251 0.63066007069235974 0.14399549152968177 0.26072821401896312 0.1361500080550333 0.59330100984242995 -0.76652291375184345 -0.94700640468210762 0.76520284019403118 0.10980026646262676 0.15813733230052676 -0.32272546295780696 -0.64877041883299724 0.1233853630039863 -0.73545449662754914 0.42888259907517262 0.13776808983094158 0.071735514374439549 -0.5559400284558611 0.59796713080484742 -0.54400378523175708 0.16043424565598036 0.64080980741994853 -0.53449018932611292 -0.65025444156534407 0.49704711725451162 -1.0634602577761587 0.964382777622249 -0.43912089386938535 0.21359863075520805 -0.93957561334005502 -0.29746582504592889 0.32727509130701193 -0.52978419407030608 0.022463454881376074 0.21981114303883562 0.00022690582481819775 -0.88265867598462788 0.54821183223348224 -0.9878955564243096 -0.94397421165930051 0.60575785739745669 0.95604042292279945 -0.048086871774684556 0.99415977483734586 0.18887339879825102 0.89811925172940543 0.60442799528519242 -0.6895614256203515 0.042382808066716904 0.28708098648688979 0.45793025147199484 -0.81574528473804753 0.95040476201847224 -0.2346564178466666 -0.35050025177368804 -0.060267555809790825 0.80399790504848367 0.83139988846038393 0.33625762742238835 -0.029597817407941974 -0.74373183316068225 -0.37332590077499034 0.54701450448777822 -0.80765619204292838 -0.18886270049252102 0.30529344501074357 0.29787667201724416 -0.81009162236227661 -0.87791650250206177 0.58641980302179497 0.7169953251996497 -0.8422335857526202 0.82775671791983674 1.0061730934727808 0.23477910306564462 0.30875970305996553 -0.76244070780591089 -1.1649213973318537 -0.28120054080757823 -1.073116008921378 0.29920365740755872 0.86170422079242381 0.96796205286171599 -0.19902025038079135 0.14571409933507437 -0.41492351090087903 -1.0353749329475952 -0.45107160981459887 0.46601560308238621 0.34441116701589397 -0.28602551744499699 -0.36893048044045934 -0.75494122595828417 -0.51373244425727949 -0.48092934916220187 -0.98631624066595347 0.70134258615051071 1.0072352639912707 0.25264690971112091 -0.85959925556131556 -0.61383932678856934 -0.50348817657337286 0.047852241731341401 -0.76634446063100103 1.0045919732096216 -0.36222074115559888 -0.16017512841767889 -0.61944192807860488 -0.076524212902396138 0.35546510838242679 0.53078647720322081 0.43889431276051566 0.71543415983378544 0.19746366803759965 -0.17505838568525534 -0.069523922787961129 0.90204293566022598 0.87498099448962607 0.15177104298649763 -0.062120684779164152 0.19430473438332882 -0.99102575395255954 0.079505191841908476 0.87525102798536714 -0.74483545448470956 -0.83309846709815738 0.29433065135096709 0.070010455838198593 -0.62982744811504321 -0.77306016539598599 -0.29367672136259787 0.49029228147883452 0.066236436099618268 -0.53768884709439879 0.92664267782177689 -0.79629759003365574 -0.08782707270721557 0.64785138514054308 -0.28417887800956337 -0.51277020538892371 0.5925029647472122 0.37422308467674092 -0.3046611932649807 0.66314200980741511 0.86807427312400587 0.15538320416326734 0.26093972781143804 0.95277248878511245 0.55779795140153421 0.75622067901209233 -0.64326771901248059 0.35018936310460858 -0.13867183250816686 -0.79086037368510376 -0.43415584180290795 -0.031124485602565873 0.51279660264882299 -0.25002663316102214 0.080184357827711855 -0.1829967548225519 -0.45653328392940762 0.95096962639583826 -0.85819840682265869 0.28289910368824828 -0.96805206366798791 0.58379925607676286 0.49009899879950319 -0.99680242779289141 0.63435017771605329 -0.44200776787789159 -0.81770643339907778 0.47345620578769676 -0.68389043632291868 0.75357420421025956;0.097118014281264833 -0.50026878359914007 -0.57783247812990723 0.042099149517999743 0.63542138039836871 0.16351516216844522 -0.040393908364499888 0.084384652963247847 0.98144468557984932 0.27704324380736051 0.70496289197626416 0.66138393016738917 0.94136212717563483 -0.63632460027325866 -0.33507122722874938 0.65540516739567545 0.6471915393259664 -0.67181921499869979 0.45055956818340748 0.045214742991266495 0.77021606991803382 0.32548894670340028 -0.52088607895299377 -0.43482339736259351 -0.4785444433635197 -0.75490520239623238 -0.84759650933076569 -0.64268177172271679 -0.53805142223561464 0.16858077943675073 -0.73731138173304711 0.24319705591676946 -0.84733694147209926 0.74020119822894692 0.36023564472409908 -0.85609132561002499 0.8512897139690857 -0.6050277475912389 0.012755858215238893 0.12218860307347845 -0.12749031166304761 0.054477919346537451 -0.74747038620437412 -0.76835495402714971 0.6286203414348821 -0.44591676260923691 0.10432113504460258 0.1346939374906668 -0.86771945169779563 -0.53825710755440859 -0.90339021495433025 -0.80729975253899366 -0.20627052969550533 0.49636898872596441 -0.24252260041571733 0.30271312415848073 0.37358384491404872 0.38585768245432289 -0.80920677852913359 -0.37989818611596227 -0.022249847523301485 6.4472631122177403e-05 -0.32410544469282293 -0.16040072900959645 -0.6495886802691363 0.89940037642650406 0.061717812976226361 -0.70389376913715174 -0.79330935841090444 -0.90417070389059784 -0.31678940025764502 0.025278100571284452 0.1798789546962605 0.6233150832882548 0.55979522233859813 0.36015544784306402 -0.97735661982433653 -0.59331255456102105 0.46504462949362219 -0.5160670283693205 1.0200842028845452 0.64923005979908976 -0.88653392883289195 -0.33928235497383641 0.8127270301663404 0.10469320798421587 0.12943578337631267 -0.67403812588164702 -0.32577258259227226 0.60702202773157876 1.1286740901944041 0.43149240778096681 -0.99666920103700218 0.25452373096141001 0.86771116448615337 -0.20980360301610157 -0.13870529884248003 -0.41498190232360449 0.39052789019509204 0.35772530296135263 -0.17902444429678976 -1.1331962199634524 -0.85212512317519007 0.74719751245548027 0.41611084846971536 -0.22295383088830348 -0.93577152064046987 0.84532400032144128 0.58524216725175815 0.66236771332187716 -0.28685903281091657 -1.0268617930759558 0.48011303365808261 -0.41908914566437733 0.83161060525517128 -0.60484606345413516 0.88240784213737589 -0.071736258726818075 -0.45225893718297677 0.81475170732403435 -0.81758994942247643 0.11298884001697146 0.64839897835585425 0.15323755164213101 -0.21308002987066174 0.37129239932481251 -0.61387049024962881 -0.57392972265371267 0.59877175137735639 -0.42846429029418404 0.74905227659946483 -0.61436810321654822 -0.30248775894527319 0.53803924148972804 -0.85570706233448801 -0.95667740178549032 -0.71612681834327596 -0.16197474100781245 -0.33715125780574984 -0.66361518472622782 -0.41784482257887129 0.90770778662935803 0.18186209087947133 0.44314768865011467 -0.63630387371973152 -0.62245713281692294 0.84607771968606937 0.28223120394421164 0.16909962487939359 1.1240669547657738 0.53498524506139489 0.23562255006047358 0.59023771048710094 0.25423364669278026 0.14833696739267171 0.44286219772788404 -0.71569205655301038 -0.07749529595536174 0.79330766838658195 0.22540261985047003 0.33767952506457033 -0.3486892961471601 0.78902686999693539 -0.66743578598974318 -0.20372096552566571 0.32183646209202632 -0.26186377194780935 0.65658736574719834 0.39545602059103635 0.48203917054226769 -0.62980567892882477 -0.28405088200951689 0.55269937000029401 -0.81795750197468209 -0.66467341113701051 0.011379403059695255 -0.67047607030433354 0.567337738403629 0.22960247398293443 -0.74091136672232427 -0.81840952892842356 -0.077788210084351536 0.26710384058941922 -0.36760347268084104 -0.70800991883778885 0.12993972985676819 -0.68621615134421432 0.63664374948684976 -0.21036679363017816 -0.75514134900524066 0.62209095183783047 -0.044232386233761002 0.23314743555794137 -0.76129464572141903 0.37306981221721414 -0.78425660322452539 0.14252151115156478 -0.95727358267558005 0.64435329541088726 0.34324077725323826;0.45704726905958276 0.41871265517329154 0.83242713625666398 0.85091733677239623 -0.37541199754266263 -0.25788881019769161 0.1767456177694236 -0.82119906446217195 0.93729097457953681 -0.37563312743817118 0.60475828186096592 -0.7990640431318542 -0.25652891623430985 -0.71113253899361684 0.68692885068743037 -0.3331781891795037 -0.23398603693798142 0.37111067352511623 0.47543926008257448 -0.053697179043847867 0.53409953076857941 -0.56516354693775162 -1.0346410148867919 -0.86411456059421921 0.77700010165514888 -0.61392665154297588 -0.98290331965529665 0.079212472182083826 -0.51953487995264624 0.40295832725001018 -0.59342287139203664 -0.005948174471902528 -0.62490323335210418 -0.11685000161110923 -0.65908706394287997 0.73929536169971832 0.25285592255144035 -0.58844214994195254 0.72102100106309164 -0.023153131755920806 -0.087756049955211926 -0.25236256530817641 0.3379816498827678 -0.80646890640249869 0.68128060695451076 -0.57216392404219474 -0.90034444605132957 -0.77263170752120125 0.13728345523706995 0.061591156993852349 1.0312874891647359 0.13445322338905027 0.44151865026397535 -0.18166859409516892 0.26926112887279269 0.90265630293004773 -0.97921126662214342 0.48260662248171782 0.43068467598813281 0.4588949687526539 -0.49604491262098444 -0.63248800757403434 -0.48622423937282711 0.3634810314204559 -0.70957773895837328 -0.028938269822866285 0.35394833594048036 0.50367614762453106 -0.52760449404859855 0.22581779954630632 0.13521690416727963 -0.42129058759390187 0.46452668158083193 -1.0050071645710563 0.077832680568440366 0.71507966817619839 0.24757665218957081 -0.47285371963612449 0.28677460574946656 0.068802186759373871 -0.26071343888976184 0.23408819955789437 -0.049608276006256037 -0.28615612989750283 -0.22893755879320091 0.27882577975817702 -1.0678294827243127 0.72202022134263 -1.0111709619133604 0.82731487022869821 -0.15893049516231869 -0.24152878964826049 0.94683405406051824 0.81358486035405742 0.81581535982093945 0.903389905350242 0.48578652676659512 -0.85680334027238492 -0.47008677915370389 0.029328542825864039 -0.75611571601638572 -0.06232450861398408 -1.0210776992360311 -0.42825202356730702 0.40228040622485856 0.55112330953842315 -0.3256586825768063 0.16221346083988922 -0.043523796059965696 1.0213561779877391 0.3210940433379133 0.90329134949876544 0.34792207933657326 0.19707892606300989 -1.0079953588292168 0.84957741953029686 0.73736184555819861 0.35570743087989737 -0.14515714791900844 -0.64393085930679395 0.85173866979326529 0.079461634371200282 0.37744856355841133 -0.85298824675574847 0.11062954737637101 -0.35915229978914143 0.37282858541558289 0.32484954426438623 -0.65091596456483292 -0.3241267588396734 -0.97514943576261559 0.66389242276712712 0.19054573085757928 -0.059430325717893383 -0.85033123821773127 0.5316970902642546 0.54096392574514096 0.11098001632609149 -0.50999892971971084 -0.088096617731856883 -0.68127146846235387 -0.74917971979931919 0.77135006303167963 -0.61538362479895858 -0.033202232936352341 -0.9996167678421054 -0.53504887940787393 0.96797411672125333 0.69591386034279012 0.52124889450792911 -0.7625230566160085 -0.24343871939358508 0.68496523781320262 -0.94506975610473554 -0.031243014857362413 -0.74651161799546584 0.94432913041838895 -0.42569522470319082 0.54141831407517849 -0.33518969452134773 -0.41459210185363909 0.82462838026701391 0.96820893576448464 -0.79701765591350116 0.52222628519981573 0.50299584506550432 -0.46800722204096007 -0.11375853781197487 -0.67101513893730658 -0.59845858508883276 -0.5933465343237827 -0.58649256812827744 0.5280438556333038 0.70391657255565687 -0.62524662984096924 0.78683440095942714 -0.88314580647348373 -0.28743600187151619 0.69953710246704026 -0.098357573585834121 -0.90371861359091188 0.75819833850064644 0.51154867714885832 -0.5246883306369714 0.45057980002713777 0.69279711504940211 -0.89398900160196371 -0.61538446635669852 -0.33095819984906888 0.80305333876754015 0.29002411157941788 0.7639088018654534 0.34590480902159532 -0.92726878977892735 -0.015824154087467499 0.10331227984877939 -0.55879007663206226 0.76511459327805365 0.057437376054085512 0.68152036921775727];

% ===== SIMULATION ========

% Format Input Arguments
isCellX = iscell(X);
if ~isCellX
    X = {X};
end

% Dimensions
TS = size(X,2); % timesteps
if ~isempty(X)
    Q = size(X{1},1); % samples/series
else
    Q = 0;
end

% Allocate Outputs
Y = cell(1,TS);

% Time loop
for ts=1:TS
    
    % Input 1
    X{1,ts} = X{1,ts}';
    Xp1 = mapminmax_apply(X{1,ts},x1_step1);
    
    % Layer 1
    a1 = tansig_apply(repmat(b1,1,Q) + IW1_1*Xp1);
    
    % Layer 2
    a2 = softmax_apply(repmat(b2,1,Q) + LW2_1*a1);
    
    % Output 1
    Y{1,ts} = a2;
    Y{1,ts} = Y{1,ts}';
end

% Final Delay States
Xf = cell(1,0);
Af = cell(2,0);

% Format Output Arguments
if ~isCellX
    Y = cell2mat(Y);
end
end

% ===== MODULE FUNCTIONS ========

% Map Minimum and Maximum Input Processing Function
function y = mapminmax_apply(x,settings)
y = bsxfun(@minus,x,settings.xoffset);
y = bsxfun(@times,y,settings.gain);
y = bsxfun(@plus,y,settings.ymin);
end

% Competitive Soft Transfer Function
function a = softmax_apply(n,~)
if isa(n,'gpuArray')
    a = iSoftmaxApplyGPU(n);
else
    a = iSoftmaxApplyCPU(n);
end
end
function a = iSoftmaxApplyCPU(n)
nmax = max(n,[],1);
n = bsxfun(@minus,n,nmax);
numerator = exp(n);
denominator = sum(numerator,1);
denominator(denominator == 0) = 1;
a = bsxfun(@rdivide,numerator,denominator);
end
function a = iSoftmaxApplyGPU(n)
nmax = max(n,[],1);
numerator = arrayfun(@iSoftmaxApplyGPUHelper1,n,nmax);
denominator = sum(numerator,1);
a = arrayfun(@iSoftmaxApplyGPUHelper2,numerator,denominator);
end
function numerator = iSoftmaxApplyGPUHelper1(n,nmax)
numerator = exp(n - nmax);
end
function a = iSoftmaxApplyGPUHelper2(numerator,denominator)
if (denominator == 0)
    a = numerator;
else
    a = numerator ./ denominator;
end
end

% Sigmoid Symmetric Transfer Function
function a = tansig_apply(n,~)
a = 2 ./ (1 + exp(-2*n)) - 1;
end
