%% Selecin del n de registro a emplear
clear all;
close all;
clc

%% SELECCIN DE MUESTRAS A ANALIZAR
data_dir = [pwd filesep 'validation' filesep];
% data_dir = [pwd filesep 'training2017' filesep];

%% Guardar resultados en EXCEL (0 -> NO, 1 -> SI)
guardar_excel_comp = 0;  % Resultados clasificacin

%% Add this directory to the MATLAB path.
addpath(pwd)

%% Load the list of records in the validation set.
fid = fopen([data_dir 'RECORDS'],'r'); % lee el fichero RECORDS de Validation
if(fid ~= -1)       % Si es distinto a -1 escanea los resultados
    RECLIST = textscan(fid,'%s');
else                % Si no es distinto a -1 muestra error de no apertura.
    error(['Could not open ' data_dir 'RECORDS for scoring. Exiting...'])
end
fclose(fid);
RECORDS = RECLIST{1};
% RECORDS almacena los nombre de cada uno de los registros
fname = RECORDS;

%% Load the reference classification results
reffile = ['validation' filesep 'REFERENCE.csv'];
fid = fopen(reffile, 'r');
if(fid ~= -1)
    Ref = textscan(fid,'%s %s','Delimiter',',');
else
    error(['Could not open ' reffile ' for scoring. Exiting...'])
end
fclose(fid);

fid=fopen('answers.txt','wt');      % Abre el fichero de respuesta (para escritura de texto)
%% Challenge: Desarrollado
for i = 1:length(RECORDS) 
    fname = RECORDS{i};
    recordName = [data_dir fname]; 
%% #############################  CHALLENGE  ##############################
classifyResult = 'N'; % CLasificacin por defecto como "Ritmo Normal"

%% Determinacin de FA
[tm,ecg,fs,siginfo] = rdmat(recordName); % Extraccin de los datos del fichero
[QRS,sign,en_thres] = qrs_detect2(ecg',0.25,0.6,fs); % Deteccin del Complejo QRS
% QRS indica el nmero de muestra dnde se ha detectado el pico de la onda R

%% Valoracin de FA por irregularidad en el intervalo RR
RR = diff(QRS')/fs; % Obtencin del tiempo RR entre latidos consecutivos
if length(QRS) < 6 
    [QRS,sign,en_thres] = qrs_detect2(ecg',0.3,0.18,fs);
    RR = diff(QRS')/fs; % Obtencin del tiempo RR entre latidos consecutivos
    
    if length(QRS) < 4 
        classifyResult = '~';
        AFEv = 0;    % Esto hay que cambiarlo y sustituirlo por la media de caractersticas
    else
        AFEv = comput_AFEv(RR); % Clcula la caracterstica para determinar si hay FA a partir de los RR
        if AFEv>1         % Si el parametros este es mayor a 1, clasifica el registro como FA
            classifyResult = 'A';
        end
    end
else
    AFEv = comput_AFEv(RR); % Clcula la caracterstica para determinar si hay FA a partir de los RR
    if AFEv>1         % Si el parametros este es mayor a 1, clasifica el registro como FA
        classifyResult = 'A';
    end
end   
 
%% Otras patologas 
% Obtencin de latidos por minuto
bpm = (length(QRS)/(tm(end)+1/fs))*60;

%% Deteccin de registros ruidosos por Entropa y Energa
H = wentropy(ecg,'shannon');  % Clculo de la entropa de Shannon del registro
E = tm(length(tm))*sum(ecg.^2); % Clculo de la energa del registro
if (H<-1300)&&(E>28000)       % Umbral de decisin combinado
    classifyResult = '~';
end

%% Analisis de ondas F y P del registro
if length(QRS) < 3
    En1 = 0;   % Esto hay que cambiarlo y sustituirlo por la media de las muestras de esta de caracterstica
    En2 = 0;   % Esto hay que cambiarlo y sustituirlo por la media de las muestras de esta de caracterstica
    Fd = 0;    % Esto hay que cambiarlo y sustituirlo por la media de las muestras de esta de caracterstica
    Q = 0;
    ampli_P = 0;
    mean_ampli_P = 0;
    var_ampli_P = 0;
    t_PR = 0;
    var_t_PR = 0;
    ampli_T = 0;
    mean_ampli_T = 0;
    var_ampli_T = 0;
    t_RT = 0;
    var_t_RT = 0;
else
    [En1, En2, Fd] = Analizador_onda_F(ecg,tm,fs,QRS);
    [Q ampli_P mean_ampli_P var_ampli_P t_PR var_t_PR] = detector_onda_P(ecg,fs,QRS,1,0);
    [ampli_T mean_ampli_T var_ampli_T t_RT var_t_RT] = detector_onda_T(ecg,fs,QRS,1,0);
end    

%% Obtencin de latidos por minuto
bpm = (length(QRS)/(tm(end)+1/fs))*60;
    
%% Guardar Caractersticas (Definicin vector caracteraticas)
vector_car(i,:) = [bpm AFEv H E En1 En2 Fd Q ampli_P mean_ampli_P var_ampli_P t_PR var_t_PR ampli_T mean_ampli_T var_ampli_T t_RT var_t_RT];

%% Clasificador (Aqu se ha de poner el modelo que clasifica el registro en una de las 4 clases)
% Modelo obtenido mediante un mtodo de clasificacin.


%% ########################################################################
    %% Almacenamiento de calsificacin obtenida
    if classifyResult == 'N'
        Class(i) = 1;
    end
    if classifyResult == 'A'
        Class(i) = 2;
    end
    if classifyResult == 'O'
        Class(i) = 3;
    end
    if classifyResult == '~'
        Class(i) = 4;
    end
    %% NO BORRAR: Por donde vamos y estritura de los datos 
    fprintf(['---Processed ' num2str(i) ' out of ' num2str(length(RECORDS)) ' records.\n'])
end

%% Obtencin de matriz con clasificacin resultante y etiquetas correspondientes
fclose('all');
reffile = [data_dir 'REFERENCE.csv'];
fid = fopen(reffile, 'r');
if(fid ~= -1)
    Ref = textscan(fid,'%s %s','Delimiter',',');
else
    error(['Could not open ' reffile ' for scoring. Exiting...'])
end
fclose(fid);

RECORDS = Ref{1};
target  = Ref{2};
N = length(RECORDS);

for i = 1:1:N
    if target{i} == 'N'
        Label(i) = 1;
    end
    if target{i} == 'A'
        Label(i) = 2;
    end
    if target{i} == 'O'
        Label(i) = 3;
    end
    if target{i} == '~'
        Label(i) = 4;
    end
end

% Matriz en la que se almacena Clasificacin (1 Colum) y Etiqueta (2 Colum)
COMPARAR = [Class', Label'];

% Exportacin de los datos a un excel
if guardar_excel_comp == 1
    ruta_name_excel = 'C:\Users\Roberto\Desktop\Challenge_2017\Resultados\Comparacion.xlsx';
    xlswrite(ruta_name_excel,{'Registro'},'Comprobacion','A1');
    xlswrite(ruta_name_excel,RECORDS,'Comprobacion','A2');
    xlswrite(ruta_name_excel,{'Clasificacin'},'Comprobacion','B1');
    xlswrite(ruta_name_excel,COMPARAR(:,1),'Comprobacion','B2');
    xlswrite(ruta_name_excel,{'Etiqueta'},'Comprobacion','C1');
    xlswrite(ruta_name_excel,COMPARAR(:,2),'Comprobacion','C2');
end

%% Obtencin de medias y desviaciones tpicas y su almacenamiento en un fichero Excel para su estudio de poder discriminante
% Obtencin de los indices de los registros de la clasificacin de cada tipo
index_Class_N = find(COMPARAR(:,1) == 1);
index_Class_A = find(COMPARAR(:,1) == 2);
index_Class_O = find(COMPARAR(:,1) == 3);
index_Class_R = find(COMPARAR(:,1) == 4);

% Obtencin de los indices de las etiquetas de los registros de la clasificacin de cada tipo
index_Label_N = find(COMPARAR(:,2) == 1);
index_Label_A = find(COMPARAR(:,2) == 2);
index_Label_O = find(COMPARAR(:,2) == 3);
index_Label_R = find(COMPARAR(:,2) == 4);

% Calculo de medias, desviaciones estandar, mediana de las caractersticas
% por grupos 
for i=1:1:size(vector_car,2)
    % Clasificacin realizada
    tabla_C(i,1) = mean(vector_car(index_Class_N,i));
    tabla_C(i,2) = std(vector_car(index_Class_N,i)); 

    tabla_C(i,3) = mean(vector_car(index_Class_A,i));
    tabla_C(i,4) = std(vector_car(index_Class_A,i)); 
    
    tabla_C(i,5) = mean(vector_car(index_Class_O,i));
    tabla_C(i,6) = std(vector_car(index_Class_O,i)); 
    
    tabla_C(i,7) = mean(vector_car(index_Class_R,i));
    tabla_C(i,8) = std(vector_car(index_Class_R,i)); 
    
    % Clasificacin de referencia
    tabla_L(i,1) = mean(vector_car(index_Label_N,i));
    tabla_L(i,2) = std(vector_car(index_Label_N,i)); 

    tabla_L(i,3) = mean(vector_car(index_Label_A,i));
    tabla_L(i,4) = std(vector_car(index_Label_A,i)); 
    
    tabla_L(i,5) = mean(vector_car(index_Label_O,i));
    tabla_L(i,6) = std(vector_car(index_Label_O,i)); 
    
    tabla_L(i,7) = mean(vector_car(index_Label_R,i));
    tabla_L(i,8) = std(vector_car(index_Label_R,i)); 
end

% Guardar la tabla en un excel
if guardar_excel_comp == 1
    ruta_name_excel = 'C:\Users\Roberto\Desktop\Challenge_2017\Resultados\Comparacion.xlsx';
    % Posiciones de las caractersticas
    xlswrite(ruta_name_excel,{'N'},'Caracteristicas','A2');
    xlswrite(ruta_name_excel,{'E'},'Caracteristicas','A3');
    xlswrite(ruta_name_excel,{'AFEv'},'Caracteristicas','A4');
    xlswrite(ruta_name_excel,{'En1'},'Caracteristicas','A5');
    xlswrite(ruta_name_excel,{'En2'},'Caracteristicas','A6');
    xlswrite(ruta_name_excel,{'Fd'},'Caracteristicas','A7');
    xlswrite(ruta_name_excel,{'bpm'},'Caracteristicas','A8');
    xlswrite(ruta_name_excel,{'Q'},'Caracteristicas','A9');
    xlswrite(ruta_name_excel,{'ampli_P'},'Caracteristicas','A10');
    xlswrite(ruta_name_excel,{'mean_ampli_P'},'Caracteristicas','A11');
    xlswrite(ruta_name_excel,{'var_ampli_P'},'Caracteristicas','A12');
    xlswrite(ruta_name_excel,{'t_PR'},'Caracteristicas','A13');
    xlswrite(ruta_name_excel,{'var_t_PR'},'Caracteristicas','A14');
    % Posiciones de los estadsticos
    xlswrite(ruta_name_excel,{'mu(N)'},'Caracteristicas','B1');
    xlswrite(ruta_name_excel,{'sigma(N)'},'Caracteristicas','C1');
    xlswrite(ruta_name_excel,{'mu(A)'},'Caracteristicas','D1');
    xlswrite(ruta_name_excel,{'sigma(A)'},'Caracteristicas','E1');
    xlswrite(ruta_name_excel,{'mu(O)'},'Caracteristicas','F1');
    xlswrite(ruta_name_excel,{'sigma(O)'},'Caracteristicas','G1');
    xlswrite(ruta_name_excel,{'mu(~)'},'Caracteristicas','H1');    
    xlswrite(ruta_name_excel,{'sigma(~)'},'Caracteristicas','I1'); 
    % Tabla 
    xlswrite(ruta_name_excel,tabla_L,'Caracteristicas','B2');
end

% Obtener la funcin de distribucin de cada uno de las caractersticas
% (Esto a lo mejor sirve de algo -> Ver como se distribuyen) 
%% Almacenar los datos de caracteristicas de las muestras y de las
if  strcmp(data_dir,'C:\Users\Roberto\Desktop\Challenge_2017\sample2017\validation\')
    vector_car_val = vector_car;
    val_label = COMPARAR(:,2);
    save 'validation.mat' vector_car_val val_label
    disp('Se han guardado la matriz de caracteristicas y el vector de etiquetas');
end

if strcmp(data_dir,'C:\Users\Roberto\Desktop\Challenge_2017\sample2017\training2017\')
    vector_car_test = vector_car;
    test_label = COMPARAR(:,2);
    save 'training.mat' vector_car_test test_label
    disp('Se han guardado la matriz de caracteristicas y el vector de etiquetas');
end

%% Representacin de los boxplot de las caracteristicas para cada una de las clases















