%% Selecin del n de registro a emplear
clear all;
close all;
clc

%% ######################  A RELLENAR ENTRE 1 A 300 #######################
i = 10;                   % Seleccin del registro(va de 1 a 300)
debug = 1;               % 1 para que dibuje grficas de depurado, 0 no dibujar grficas

%% ########################################################################

data_dir = [pwd filesep 'validation' filesep];
% data_dir = [pwd filesep 'training2017' filesep];

%% Add this directory to the MATLAB path.
addpath(pwd)

%% Load the list of records in the validation set.
fid = fopen([data_dir 'RECORDS'],'r'); % lee el fichero RECORDS de Validation
if(fid ~= -1)       % Si es distinto a -1 escanea los resultados
    RECLIST = textscan(fid,'%s');
else                % Si no es distinto a -1 muestra error de no apertura.
    error(['Could not open ' data_dir 'RECORDS for scoring. Exiting...'])
end
fclose(fid);
RECORDS = RECLIST{1};
% RECORDS almacena los nombre de cada uno de los registros
fname = RECORDS{i};

%% Load the reference classification results
reffile = [data_dir 'REFERENCE.csv'];
fid = fopen(reffile, 'r');
if(fid ~= -1)
    Ref = textscan(fid,'%s %s','Delimiter',',');
else
    error(['Could not open ' reffile ' for scoring. Exiting...'])
end
fclose(fid);

%% Challenge: Desarrollado
% classifyResult = challenge([data_dir fname]);
recordName = [data_dir fname] 
classifyResult = 'N'; % CLasificacin por defecto como "Ritmo Normal"
[tm,ecg,fs,siginfo]=rdmat(recordName);
[QRS,sign,en_thres] = qrs_detect2(ecg',0.25,0.6,fs);
[QRS_amp,QRS_pan,delay,ecg_h] = pan_tompkin(ecg,fs,0);

if debug == 1
    figure, plot(tm,ecg);
    hold on,
    for n=1:1:length(QRS)
        plot(QRS(n)*(1/fs),ecg(QRS(n)),'ro');
    end
    for n=1:1:length(QRS_pan)
        plot(QRS_pan(n)*(1/fs),ecg(QRS_pan(n)),'g*');
    end
end

%% Valoracin de FA por irregularidad en el intervalo RR
RR = diff(QRS')/fs; % Obtencin del tiempo RR entre latidos consecutivos
if length(QRS) < 4  % Se vuelve a pasar el detector RR, bajando restriciones del detector (detecte ms picos)
    disp('Pocos picos R detectados, se bajan restricciones para ver si los detecta mejor');
    [QRS,sign,en_thres] = qrs_detect2(ecg',0.3,0.18,fs);
    RR = diff(QRS')/fs; % Obtencin del tiempo RR entre latidos consecutivos

    figure, plot(tm,ecg);
    hold on,
    for n=1:1:length(QRS)
        plot(QRS(n)*(1/fs),ecg(QRS(n)),'ro');
    end
    for n=1:1:length(QRS_pan)
        plot(QRS_pan(n)*(1/fs),ecg(QRS_pan(n)),'g*');
    end
    if length(QRS) < 4 
        classifyResult = '~';
        AFEv = 0;    % Esto hay que cambiarlo y sustituirlo por la media de caractersticas
    else
        AFEv = comput_AFEv(RR); % Clcula la caracterstica para determinar si hay FA a partir de los RR
        if AFEv>1         % Si el parametros este es mayor a 1, clasifica el registro como FA
            classifyResult = 'A';
        end
    end
else
    AFEv = comput_AFEv(RR); % Clcula la caracterstica para determinar si hay FA a partir de los RR
    if AFEv>1         % Si el parametros este es mayor a 1, clasifica el registro como FA
        classifyResult = 'A';
    end
end    

%% Deteccin de registros ruidosos por Entropa y Energa
H = wentropy(ecg,'shannon');  % Clculo de la entropa de Shannon del registro
E = tm(length(tm))*sum(ecg.^2); % Clculo de la energa del registro
if (H<-1300)&&(E>28000)       % Umbral de decisin combinado
    classifyResult = '~';
end

%% Obtencin de patrn y clasificacin complejos QRS y ondas P.
% Obtencin de caracteristicas para deteccin de ondas f
if length(QRS) < 3
    En1 = 0;   % Esto hay que cambiarlo y sustituirlo por la media de las muestras de esta de caracterstica
    En2 = 0;   % Esto hay que cambiarlo y sustituirlo por la media de las muestras de esta de caracterstica
    Fd = 0;    % Esto hay que cambiarlo y sustituirlo por la media de las muestras de esta de caracterstica
    Q = 0;
    ampli_P = 0;
    mean_ampli_P = 0;
    var_ampli_P = 0;
    t_PR = 0;
    var_t_PR = 0;
    ampli_T = 0;
    mean_ampli_T = 0;
    var_ampli_T = 0;
    t_RT = 0;
    var_t_RT = 0;
else
    [En1, En2, Fd] = Analizador_onda_F(ecg,tm,fs,QRS);
    [Q ampli_P mean_ampli_P var_ampli_P t_PR var_t_PR] = detector_onda_P(ecg,fs,QRS,1,debug);
    [ampli_T mean_ampli_T var_ampli_T t_RT var_t_RT] = detector_onda_T(ecg,fs,QRS,1,debug);
end   

%% Obtencin de latidos por minuto
bpm = (length(QRS)/(tm(end)+1/fs))*60;
    
%% Guardar Caractersticas (Definicin vector caracteraticas)
vector_car = [bpm AFEv H E En1 En2 Fd Q ampli_P mean_ampli_P var_ampli_P t_PR var_t_PR ampli_T mean_ampli_T var_ampli_T t_RT var_t_RT];

%% Devolucin de Resultados
classifyResult  % Resultado de clasificacin del registro
% Mostrar solamente la clasificacin de referencia de la seal a analizar
a = Ref{1,2};
classifyReference = a{i}
