% This script will verify that your code is working as you intended, by
% running it on a small subset (300 records) of the training data, then
% comparing the answers.txt file that you submit with your entry with
% answers produced by your code running in our test environment using
% the same records.
%
% In order to run this script, you should have downloaded and extracted
% the validation set into the directory containing this file.
%
%
% Written by: Chengyu Liu and Qiao Li January 20 2017 
%             chengyu.liu@emory.edu  qiao.li@emory.edu
%
% Last modified by:
%
%

clear all;
close all;
% clc

%% Add this directory to the MATLAB path.
pa=pwd;             % Obtencin de la direccin del directorio actual de trabajo
addpath(pa);
  data_dir = [pwd filesep 'validation' filesep];
%data_dir = [pwd filesep 'training2017' filesep];
% addpath([pa,filesep,'clasificador']);
% addpath([pa,filesep,'clasificador',filesep,'Feature Extraction-Selection']);
% addpath([pa,filesep,'clasificador',filesep,'Evaluation']);
% addpath([pa,filesep,'clasificador',filesep,'Decision Plot']);
% addpath([pa,filesep,'clasificador',filesep,'Classifiers']);

%% Check for previous files before starting validation procedure
answers = dir(['answers.txt']);  % Almacena de direccin de las respuestas
% Lo que hace es preguntar si se encuentra un txt de respuestas (Si hay txt
% te pregunta que quieres hacer con el: borrarlo o no).
if(~isempty(answers))            
    while(1)                        
        display(['Found previous answer sheet file in: ' pwd])
        cont = upper(input('Delete it (Y/N/Q)?','s'));
        if(strcmp(cont,'Y') || strcmp(cont,'N') || strcmp(cont,'Q'))
            if(~strcmp(cont,'Y'))
                display('Exiting script!!')
                return;
            end
            break;
        end
    end
    display('Removing previous answer sheet.')
    delete(answers.name);
end

%% Load the list of records in the validation set.
fid = fopen([data_dir 'RECORDS'],'r'); % lee el fichero RECORDS de Validation
if(fid ~= -1)       % Si es distinto a -1 escanea los resultados
    RECLIST = textscan(fid,'%s');
else                % Si no es distinto a -1 muestra error de no apertura.
    error(['Could not open ' data_dir 'RECORDS for scoring. Exiting...'])
end
fclose(fid);
RECORDS = RECLIST{1};   
% RECORDS almacena los nombre de cada uno de los registros


%% Running on the validation set and obtain the score results
classifyResult = zeros(length(RECORDS),1);  % Resultados de la clasificacin
total_time = 0;     % Tiempo total

fid=fopen('answers.txt','wt');      % Abre el fichero de respuesta (para escritura de texto)
for i = 1:length(RECORDS)           % Recorrer todo los registros y mira la clasificacin del challenge
    fname = RECORDS{i};
    tic;
    classifyResult(i) = challenge([data_dir fname]);

    % write the answer to answers.txt file
    fprintf(fid,'%s,%s\n',RECORDS{i},classifyResult(i)); % Escribe los resultado del challenge en answers.txt

    total_time = total_time+toc;  % Contabiliza el tiempo que tarda en hacer la clasificacin 
    fprintf(['---Processed ' num2str(i) ' out of ' num2str(length(RECORDS)) ' records.\n'])
end
fclose(fid);

averageTime = total_time/length(RECORDS);   % Calculo del tiempo medio en clasificar un registro
fprintf(['Generation of validation set completed.\n  Total time = ' ...
    num2str(total_time) '\n  Average time = ' num2str(averageTime) '\n'])

fprintf(['Answer file created as answers.txt.\n  Processing completed.\n'])

fprintf(['Running score2017Challenge.m to get scores on your entry on the validation data in training set....\n'])

%% Scoring
score2017Challenge   % Obtencin de los porcetajes de exito de cada clasificacin (+ TOTAL)

% Lo que hace es decir si quieres guardar tu clasificacin y generar un
% zip con varia cosas (leer con ms detalle).
fprintf(['Scoring complete.\n'])
while(1)
    display(['Do you want to package your entry for scoring?'])
    cont=upper(input('(Y/N/Q)?','s'));
    if(strcmp(cont,'Y') || strcmp(cont,'N') || strcmp(cont,'Q'))
        if(strcmp(cont,'Q'))
            display('Exiting!!')
            return;
        end
        break;
    end
end

if(strcmp(cont,'Y'))
    display(['Packaging your entry (excluding any subdirectories) to: ' pwd filesep 'entry.zip'])
    % Delete any files if they existed previously
    if (exist('entry.zip','file'))
        delete('entry.zip');
    end
    % This will not package any sub-directories !
    zip('entry.zip',{'*.m','*.c','*.mat','*.txt','*.sh'});
end
