%% Funcin de enventanado onda T
% Localiza la onda P del ECG y los organiza en una matriz. En el
% caso de que no haya suficiente seal para enventanar el primer y/o ltimo
% latido, los elimina. Si hay suficiente seal, los mantiene igualmente.
% Entradas:
% - ECG: Seal del ECG a analizar
% - fs: Frecuencia de muestreo de la seal del ECG
% - picos_R: Posicin de los picos R detectados en la seal ECG
% - Entradas opcionales:
%   * v_ant: Ventana anterior al P en ms
%   * v_pos: Ventana posterior al P en ms
%
% Salidas:
% - ondaT: Matriz en la que cada fila es una onda T detectada. 
%          No se almacena la primera o primeras si no entra la ventana
%          anterior.
% - indP: Indice de dnde se encuentra la posicin mxima de la onda P.
%         No se almacena la primera o primeras si no entra la ventana
%         anterior.
% - indR: Indice de dnde se encuentra la onda R correspondiente a la onda
%          P detectada.
% - iso: Valor de la lnea isoelctrica en la onda P detectada.
% - latido: Guarda el latido completo de la onda P detectada. Puede que el
%           primero y el ltimo no sean aadidos si la ventana no entra

function [ondaT,indT,indR,iso,latido,lapso] = enventanaT(ECG,fs,picos_R,v_ant_ms,v_pos_ms,lapso)
%% Comprobacin de parmetros de entrada a la funcin.
if nargin > 4
    % Paso de ms a n de muestras
    v_ant = round((v_ant_ms/10^3)*fs);
    v_pos = round((v_pos_ms/10^3)*fs);
elseif nargin < 4
    % Valores por defecto
    v_ant = round((275/10^3)*fs);
    v_pos = round((425/10^3)*fs);
else
    disp ('Falta ventana posterior, se ha puesto por defecto 75 mseg')
    v_ant = round((v_ant_ms/10^3)*fs);
    v_pos = round((425/10^3)*fs);
end

%% Inicializacin de variables
% Paso de ms a n de muestras
lapso = round(0.1*fs);  % 100 ms de periodo refractario

n_R = length(picos_R);  % N de ondas R detectadas (latidos)
indT = [];              % Indice dnde se ha detectado la onda T
iso = [];               % Valor de la lnea isoelctrica
indR = [];              % Indice dnde se ha detectado la onda R
latido = [];            % Latido entero en el que se ha analizado la onda T
ondaT = [];             % Se almacenan los latidos P detectados correctamente

%% Anlisis de lo latidos (Descartar las ondas T iniciales que no entren en la ventana anterior) -> No se hace correcto anlisis
for i=1:length(picos_R)
    % Si la ventana anterior o posterior no entra 
    if ((picos_R(i) - v_ant) < 1) || ((picos_R(i) + v_pos) > length(ECG))
        % No analiza eese latido
    % Si la ventana anterior si entra 
    else
        ini = picos_R(i) - v_ant;
        fin = picos_R(i) + v_pos;
        
        eval = ECG(ini:fin)';
    
        % Si coge el latido entero se incorpora a latido detectado
        if length(eval) == (v_ant + v_pos + 1)
            latido = [latido; eval];
        end
    
        % Busca en ese periodo de tiempo la onda T como el mximo.
        [maximo,indice] = max(eval(v_ant+lapso+1:end));
        isoelectric = prctile(eval(v_ant+lapso+1:end),25);
        indT = [indT; picos_R(i)+(v_ant+lapso+1+indice)];
        iso = [iso; isoelectric];
        indR = [indR; picos_R(i)]; 
        ondaT = [ondaT; eval(v_ant+lapso+1:end)];
    end
end
end