function [QRST,intervalos] = enventanaQRST(ECG,fs,ECG_R,v_ant_ms,v_pos_ms)

if nargin<4
v_ant_ms=45;
v_pos_ms=350;
end

%Pasamos las posiciones anterior y posterior de la ventana a muestras:
v_ant_mu=round(fs*v_ant_ms/1000);
v_pos_mu=round(fs*v_pos_ms/1000);


%Si no hay suficiente seal para enventar el primer y/0 ultimo latido, se
%eliminan:

if ECG_R(1)<v_ant_mu+1
    ECG_R=ECG_R(2:length(ECG_R));
end
if ECG_R(1)<v_ant_mu+1
    ECG_R=ECG_R(2:length(ECG_R));
end

if (length(ECG)-ECG_R(length(ECG_R)))<v_pos_mu+1
    ECG_R=ECG_R(1:(length(ECG_R)-1));
end
if (length(ECG)-ECG_R(length(ECG_R)))<v_pos_mu+1
    ECG_R=ECG_R(1:(length(ECG_R)-1));
end

QRST=zeros(length(ECG_R),(1+v_pos_mu+v_ant_mu));
intervalos=zeros(length(ECG_R),2);

for i=1:length(ECG_R)
    intervalos(i,:)=[(ECG_R(i)-v_ant_mu) (ECG_R(i)+v_pos_mu)];
    QRST(i,:)=ECG(intervalos(i,1):intervalos(i,2));
end

