%% Funcin de enventanado onda P
% Localiza la onda P del ECG y los organiza en una matriz. En el
% caso de que no haya suficiente seal para enventanar el primer y/o ltimo
% latido, los elimina. Si hay suficiente seal, los mantiene igualmente.
% Entradas:
% - ECG: Seal del ECG a analizar
% - fs: Frecuencia de muestreo de la seal del ECG
% - picos_R: Posicin de los picos R detectados en la seal ECG
% - Entradas opcionales:
%   * v_ant: Ventana anterior al P en ms
%   * v_pos: Ventana posterior al P en ms
%
% Salidas:
% - ondaP: Matriz en la que cada fila es una onda P detectada. 
%          No se almacena la primera o primeras si no entra la ventana
%          anterior.
% - indP: Indice de dnde se encuentra la posicin mxima de la onda P.
%         No se almacena la primera o primeras si no entra la ventana
%         anterior.
% - indR: Indice de dnde se encuentra la onda R correspondiente a la onda
%          P detectada.
% - iso: Valor de la lnea isoelctrica en la onda P detectada.
% - latido: Guarda el latido completo de la onda P detectada. Puede que el
%           primero y el ltimo no sean aadidos si la ventana no entra

function [ondaP,indP,indR,iso,latido] = enventanaP(ECG,fs,picos_R,v_ant_ms,v_pos_ms)
%% Comprobacin de parmetros de entrada a la funcin.
if nargin > 4
    % Paso de ms a n de muestras
    v_ant = round((v_ant_ms/10^3)*fs);
    v_pos = round((v_pos_ms/10^3)*fs);
elseif nargin < 4
    % Valores por defecto
    v_ant = round((275/10^3)*fs);
    v_pos = round((425/10^3)*fs);
else
    disp ('Falta ventana posterior, se ha puesto por defecto 75 mseg')
    v_ant = round((v_ant_ms/10^3)*fs);
    v_pos = round((425/10^3)*fs);
end

%% Inicializacin de variables
% Paso de ms a n de muestras
lapso = round(0.070*fs); % 70 ms de periodo refractario (90ms -> original)

n_R = length(picos_R);  % N de ondas R detectadas (latidos)
indP = [];              % Indice dnde se ha detectado la onda P
iso = [];               % Valor de la lnea isoelctrica
indR = [];              % Indice dnde se ha detectado la onda R
latido = [];            % Latido entero en el que se ha analizado la onda P
ondaP = [];             % Se almacenan los latidos P detectados correctamente

%% Anlisis de lo latidos (Descartar las ondas P iniciales que no entren en la ventana anterior) -> No se hace correcto anlisis
for i=1:length(picos_R)
    % Si la ventana anterior no entra 
    if (picos_R(i) - v_ant) < 1 
        % No almacena la onda P
    % Si la ventana anterior si entra 
    else
        ini = picos_R(i) - v_ant;
        
        % Si la ventana posterior no entra 
        if  (picos_R(i) + v_pos) > length(ECG)
            fin = length(ECG);
        % Si la ventana posterior si entra 
        else 
            fin = picos_R(i) + v_pos;
        end
        
        eval = ECG(ini:fin)';
    
        % Si coge el latido entero se incorpora a latido detectado
        if length(eval) == (v_ant + v_pos + 1)
            latido = [latido; eval];
        end
    
        % Busca en ese periodo de tiempo la onda P como el mximo.
        [maximo,indice] = max(eval(1:v_ant-lapso));
        isoelectric = prctile(eval(1:v_ant-lapso),25);
        indP = [indP; picos_R(i)-(v_ant-indice)-1];
        iso = [iso; isoelectric];
        indR = [indR; picos_R(i)]; 
        ondaP = [ondaP; eval(1:v_ant-lapso)];
    end
end
end