%% Funcin que extrae caracteristicas de la onda T
% La finalidad de este funcin es conseguir discernir bien entre normales y
% otros. Analizando las caracteriscias de la Onda T


function [ampli_T mean_ampli_T var_ampli_T t_RT var_t_RT] = detector_onda_T(ecg,fs,picos_R,filtro,debug)
%% Paso 0: Filtrado de la seal 
if filtro == 1
    [b,a] = butter(5,40*2/fs,'low');  % FPB de orden 5 con fc = 40 Hz
    ecg_fil = filtfilt(b,a,ecg);
end

%% Paso 1: Enventanado ondaP y latido completo
v_ant_ms = 275;
v_pos_ms = 425;
[ondaT,indT,indR,iso,latido,lapso] = enventanaT(ecg,fs,picos_R,v_ant_ms,v_pos_ms);

%% Paso 2: Extraccin de onda T y latido (llevar a 0 V la lnea isoelctrica)
% Correccin lnea isoelctrica de las ondas T
ondaT_corr = ondaT - iso*ones(1,size(ondaT,2));

% Correccin lena isoelctrica latidos
latido_corr = [];
iso_latido = [];
for i=1:size(latido,1)
    iso_latido(i,:) = prctile(latido(i,:),25)*ones(1,size(latido,2));
    latido_corr(i,:) = latido(i,:) - iso_latido(i,:);
end

%% Paso 3: Obtencin de parmetros (Extraccin de caractersticas)
%% Paso 3.1: Analisis de los latidos correlados y que en mayor frecuencia se dan.
%% Paso 3.1.1: Clasificacin de los latidos con una correlacin del 0.9 en 5 clases como mucho
[tipo_latido,patron_latido,num_latido] = ClasificaSenyal(latido_corr,5,0.9); % Clasificacin morfolgica

if debug == 1
    % Dibujar los patrones
    tp = (1/fs)*[0:1:size(patron_latido,2)-1];
    figure, 
    if size(patron_latido,1) == 1
        plot(tp, patron_latido(1,:)), xlabel('Patron 1'),
    elseif size(patron_latido,1) == 2
        subplot(1,2,1), plot(tp, patron_latido(1,:)), xlabel('Patron 1'),
        subplot(1,2,2), plot(tp, patron_latido(2,:)), xlabel('Patron 2'),    
    elseif size(patron_latido,1) == 3
        subplot(2,2,1), plot(tp, patron_latido(1,:)), xlabel('Patron 1'),
        subplot(2,2,2), plot(tp, patron_latido(2,:)), xlabel('Patron 2'),
        subplot(2,2,3), plot(tp, patron_latido(3,:)), xlabel('Patron 3'),    
    elseif size(patron_latido,1) == 4
        subplot(2,2,1), plot(tp, patron_latido(1,:)), xlabel('Patron 1'),
        subplot(2,2,2), plot(tp, patron_latido(2,:)), xlabel('Patron 2'),
        subplot(2,2,3), plot(tp, patron_latido(3,:)), xlabel('Patron 3'),
        subplot(2,2,4), plot(tp, patron_latido(4,:)), xlabel('Patron 4'),
    elseif size(patron_latido,1) == 5
        subplot(2,3,1), plot(tp, patron_latido(1,:)), xlabel('Patron 1'),
        subplot(2,3,2), plot(tp, patron_latido(2,:)), xlabel('Patron 2'),
        subplot(2,3,3), plot(tp, patron_latido(3,:)), xlabel('Patron 3'),
        subplot(2,3,4), plot(tp, patron_latido(4,:)), xlabel('Patron 4'),
        subplot(2,3,5), plot(tp, patron_latido(5,:)), xlabel('Patron 5'),
    else
        subplot(2,3,1), plot(tp, patron_latido(1,:)), xlabel('Patron 1'),
        subplot(2,3,2), plot(tp, patron_latido(2,:)), xlabel('Patron 2'),
        subplot(2,3,3), plot(tp, patron_latido(3,:)), xlabel('Patron 3'),
        subplot(2,3,4), plot(tp, patron_latido(4,:)), xlabel('Patron 4'),
        subplot(2,3,5), plot(tp, patron_latido(5,:)), xlabel('Patron 5'),
        subplot(2,3,6), plot(tp, patron_latido(6,:)), xlabel('Patron 6'),    
    end
end

%% Paso 3.1.2: Ver cual de la frecuencia con la que se dan los patrones y el % de latidos clasificados en cada partn
% Obtencin tabla de frecuencias y porcentajes de cada tipo
% Columnas: 1 tipo latido, 2 frecuencia, 3 porcentaje
tabla_latidos = tabulate(tipo_latido);

% Obtencin de patrones relevantes (capaces de explicar al menos un 20%)
patrones_relev = find(tabla_latidos(:,3) >= 20);

% Obtencin del numero de latidos pertenecientes a cada patrn relevante
frec_relev = tabla_latidos(patrones_relev,2);
tot_frec_relev = sum(frec_relev); % N total de latidos significantes

% Obtencin de los pesos de ponderacin de cada uno de los patrones relevantes
% Estos pesos con los que se multiplicarn por los parmetros que se han
% obtneido, con la finalidad de buscar la mxima representabilidad
for i=1:1:length(frec_relev)
    w(i) = frec_relev(i)/tot_frec_relev;
end

%% Paso 3.1.3: Anlisis onda P una a una de las clases relevantes
for i=1:1:length(patrones_relev)
    %% Obtencin de onda P promedio de la misma clase latido y corregir isoelctrica
    pos_latido_relev = [];
    pos_latido_relev = find(tipo_latido == patrones_relev(i));
    
    if length(pos_latido_relev) > 1
        ondaT_relev(i,:) = mean(ondaT_corr(pos_latido_relev,:));
    else
        ondaT_relev(i,:) = ondaT_corr(pos_latido_relev,:);
    end
    
    iso_relev(i,:) = prctile(ondaT_relev(i,:),25)*ones(1,length(ondaT_relev));
    ondaT_relev_corr(i,:) = ondaT_relev(i,:) - iso_relev(i,:);
     
    %% Obtencin de la amplitud media de la onda R
    pos_R_relev = [];
    pos_R_relev = indR(pos_latido_relev);
    ampli_R_mean(i) = mean(ecg(pos_R_relev)); 
    std_R(i) = std(ecg(pos_R_relev));
      
    %% Si R es - se buca mnimo y si en + se busca maximo (AMPLITUD ONDA P)
    if ampli_R_mean(i) < 0  % Si es negativo calcula el minimo ondaT
        % Obtencin de la amplitud mxima de la onda T promedio de la clase
        [ampli_T_clase(i),pos_T_clase(i)] = min(ondaT_relev_corr(i,:));
        ampli_T_clase(i) = abs(ampli_T_clase(i)); % Forzar que amplitud sea positiva
        
        % Obtener todas las ondas T pertenecientes a la misma clase
        max_T_clase = [];
        pos_T_relev = [];
        ind_max_T = [];
        for j=1:length(pos_latido_relev)
            [max_T_clase(j), ind_max_T(j)] = min(ondaT_corr(pos_latido_relev(j),:)); 
            pos_T_relev(j,1) = pos_R_relev(j) + lapso +  ind_max_T(j);
        end
        
        % Obtencin de la variabilidad tiempo RT
        t_RT_clase(i) = mean((1/fs)*(pos_T_relev - pos_R_relev));
        var_t_RT_clase(i) = var((1/fs)*(pos_T_relev - pos_R_relev));
        
        % Obtencin de la amplitud mxima promedio de las ondas T de la
        % clase misma clase, as como su varianza.
        mean_ampli_T_clase(i) = abs(mean(max_T_clase));
        var_ampli_T_clase(i) = var(max_T_clase);
       
    else                    % Si es positivo que calcule el mximo ondaT
        % Obtencin de la amplitud mxima de la onda T promedio de la clase
        [ampli_T_clase(i),pos_T_clase(i)] = max(ondaT_relev_corr(i,:));
        ampli_T_clase(i) = abs(ampli_T_clase(i)); % Forzar que amplitud sea positiva
        
        % Obtener todas las ondas T pertenecientes a la misma clase
        max_T_clase = [];
        pos_T_relev = [];
        ind_max_T = [];
        for j=1:length(pos_latido_relev)
            [max_T_clase(j), ind_max_T(j)] = max(ondaT_corr(pos_latido_relev(j),:));
            pos_T_relev(j,1) = pos_R_relev(j) + lapso +  ind_max_T(j);
        end
        
        % Obtencin de la variabilidad tiempo RT
        t_RT_clase(i) = mean((1/fs)*(pos_T_relev - pos_R_relev));
        var_t_RT_clase(i) = var((1/fs)*(pos_T_relev - pos_R_relev));
        
        % Obtencin de la amplitud mxima promedio de las ondas T de la
        % clase misma clase, as como su varianza.
        mean_ampli_T_clase(i) = abs(mean(max_T_clase));
        var_ampli_T_clase(i) = var(max_T_clase);
    end     
    
    if debug == 1       
        figure, plot(ondaT_relev(i,:)),
        hold on, plot(ondaT_relev_corr(i,:)),
    end
end

%% Paso 3.1.4: Sumatorio ponderado por pesos de cada una de las caractersticas
% Obtencin de la amplitud de la onda P de los patrones ms relevantes
ampli_T = sum(w .* ampli_T_clase);

% Obtencin de la amplitud  media de la ondas P pertenecientes a las clases relevantes
mean_ampli_T = sum(w .* mean_ampli_T_clase);

% Obtencin de la varianza de la amplitud de la ondas P pertenecientes a las clases relevantes
var_ampli_T = sum(w .* var_ampli_T_clase);

% Obtencin de media de intervalo PR de las ondas P pertenecientes a las clases relevantes
t_RT = sum(w .* t_RT_clase);

% Obtencin de media de intervalo PR de las ondas P pertenecientes a las clases relevantes
var_t_RT = sum(w .* var_t_RT_clase);

end




