function Pred_labels = challenge(recordName)
% INPUTS:
% recordName: Nombre del registro a clasificar los latidos
%
% OUTPUTS:
% classifyResult: Resultado de la clasificacin
%                     N = Ritmo Normal
%                     A = FA (Fibrilacin Auricular
%                     O = Otro ritmo
%                     ~ = Registro ruidoso (poor signal quality)
%
% Para elavual el registro corre el script: "generateValidationSet.m"
%
% The challenge function requires that you have downloaded the challenge
% data 'training_set' in a subdirectory of the current directory.
%    http://physionet.org/physiobank/database/challenge/2017/
%
% This dataset is used by the generateValidationSet.m script to create
% the annotations on your training set that will be used to verify that
% your entry works properly in the PhysioNet testing environment.
%
% Version 1.0
%
% Written by: Chengyu Liu and Qiao Li January 20 2017
%             chengyu.liu@emory.edu  qiao.li@emory.edu
%
% Last modified by: Zazo Manzaneque, Roberto
%

classifyResult = 'N'; % CLasificacin por defecto como "Ritmo Normal"

%% Determinacin de FA
[tm,ecg,fs,siginfo]=rdmat(recordName); % Extraccin de los datos del fichero
[QRS,sign,en_thres] = qrs_detect2(ecg',0.25,0.6,fs); % Deteccin del Complejo QRS
% QRS indica el nmero de muestra dnde se ha detectado el pico de la onda R

%% Valoracin de FA por irregularidad en el intervalo RR
RR = diff(QRS')/fs; % Obtencin del tiempo RR entre latidos consecutivos
if length(QRS) < 6 
    [QRS,sign,en_thres] = qrs_detect2(ecg',0.3,0.18,fs);
    RR = diff(QRS')/fs; % Obtencin del tiempo RR entre latidos consecutivos
    
    if length(QRS) < 4 
        classifyResult = '~';
        AFEv = 0;    % Esto hay que cambiarlo y sustituirlo por la media de caractersticas
    else
        AFEv = comput_AFEv(RR); % Clcula la caracterstica para determinar si hay FA a partir de los RR
        if AFEv>1         % Si el parametros este es mayor a 1, clasifica el registro como FA
            classifyResult = 'A';
        end
    end
else
    AFEv = comput_AFEv(RR); % Clcula la caracterstica para determinar si hay FA a partir de los RR
    if AFEv>1         % Si el parametros este es mayor a 1, clasifica el registro como FA
        classifyResult = 'A';
    end
end   
 
%% Otras patologas 
% Obtencin de latidos por minuto
bpm = (length(QRS)/(tm(end)+1/fs))*60;

%% Deteccin de registros ruidosos por Entropa y Energa
H = wentropy(ecg,'shannon');  % Clculo de la entropa de Shannon del registro
E = tm(length(tm))*sum(ecg.^2); % Clculo de la energa del registro
if (H<-1300)&&(E>28000)       % Umbral de decisin combinado
    classifyResult = '~';
end

%% Analisis de ondas F y P del registro
if length(QRS) < 3
    En1 = 0;   % Esto hay que cambiarlo y sustituirlo por la media de las muestras de esta de caracterstica
    En2 = 0;   % Esto hay que cambiarlo y sustituirlo por la media de las muestras de esta de caracterstica
    Fd = 0;    % Esto hay que cambiarlo y sustituirlo por la media de las muestras de esta de caracterstica
    Q = 0;
    ampli_P = 0;
    mean_ampli_P = 0;
    var_ampli_P = 0;
    t_PR = 0;
    var_t_PR = 0;
    ampli_T = 0;
    mean_ampli_T = 0;
    var_ampli_T = 0;
    t_RT = 0;
    var_t_RT = 0;
else
    [En1, En2, Fd] = Analizador_onda_F(ecg,tm,fs,QRS);
    [Q ampli_P mean_ampli_P var_ampli_P t_PR var_t_PR] = detector_onda_P(ecg,fs,QRS,1,0);
    [ampli_T mean_ampli_T var_ampli_T t_RT var_t_RT] = detector_onda_T(ecg,fs,QRS,1,0);
end     

%% Obtencin de latidos por minuto
bpm = (length(QRS)/(tm(end)+1/fs))*60;
    
%% Guardar Caractersticas (Definicin vector caracteraticas)
vector_car = [bpm AFEv H E En1 En2 Fd Q ampli_P mean_ampli_P var_ampli_P t_PR var_t_PR ampli_T mean_ampli_T var_ampli_T t_RT var_t_RT];

%% Clasificador (Aqu se ha de poner el modelo que clasifica el registro en una de las 4 clases)
% % prueba1.
% load('trainedModel.mat')
% 
% [Pred_labels]= trainedModel.predictFcn(vector_car);
% % [Pred_labels]=Discriminant_test(clasificador,vector_car);
% 
% if Pred_labels==1
%     Pred_labels='N';
% end
% 
% if Pred_labels==2
%     Pred_labels='A';
% end
% 
% if Pred_labels==3
%     Pred_labels='O';
% end
% 
% if Pred_labels==4
%     Pred_labels='~';
% end
% 
% end

% % prueba2.

load('Otros.mat')
load('N_O.mat')
load('FA_NyO.mat')


[Pred_label1]= Otros.predictFcn(vector_car);

if Pred_label1==2
   Pred_labels='~';
else
    
[Pred_label2]= FA_NyO.predictFcn(vector_car([1 2 10:13]));

if Pred_label2==2
   Pred_labels='A';
else
    
[Pred_label3]= N_O.predictFcn(vector_car([1 2 12 13 18]));

if Pred_label3==1
   Pred_labels='N';
else 
   Pred_labels='O'; 
end

end

end

end
    

