%   p = IdentificaPatron(patrones,QRS,umbral,n_patrones)
%
%   Esta funcin identifica el patrn al que corresponde un complejo QRS
%   dado. En el caso de que el QRS no corresponda a ningn tipo de patrn 
%   perteneciente al conjunto de patrones, la funcin devuelve p=0
%   
%   Parmetros de entrada
%       patrones [matriz]:   conjunto de patrones de QRS organizados en filas
%       QRS [vector]:        QRS actual 
%
%   Parmetro de entrada opcional:
%       umbral [real]:       umbral de correlacin para la comparacin de patrones (entre 0 y 1)
%       n_patrones: Nmero mximo de patrones a generar
%       
%   Parmetro de salida
%       p [entero]:          ndice correspondiente al tipo de patrn identificado
%

function p = IdentificaPatron(patrones,senyal,umbral,n_patrones)
% Si no se mete umbral por defecto es 0.9 
% Si no se mete n_patrones por defecto son 8
%% Parmetros opcionales
if nargin < 3
    umbral = 0.9;
elseif nargin < 4
    umbral = umbral;
    n_patrones = 8;         
else
    umbral = umbral;
    n_patrones = n_patrones;
end

%% Obtencin del patron (OBTENCIN POR CORRELACIN)
if (isempty(patrones) && (size(patrones,1) < n_patrones))
% Los patrones son actualizados en la funcin "ClasificaSenyal".
    p = 0;  % No corresponde con ninguno de los patrones que hay
else
    for n=1:1:size(patrones,1)
        cof(n) = corr(patrones(n,:)',senyal'); % Calcula la correlacin entre el patron y el QRS 
    end
    [max_cof,pos_max] = max(cof);
    if max_cof >= umbral
        p = pos_max;  % Posicin del patrn con el que corresponde
    elseif size(patrones,1) >= n_patrones
        p = pos_max;  % Asigna ese complejo al tipo de mxima covarianza 
                      % (mayor similitud morfolgica)
    else
        p = 0; % No corresponde con ningn patron existente
    end
end 
end

